/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateRatFluidPacket;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.network.PacketDistributor;

public class RatMilkCowGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;
    private final Predicate<LivingEntity> COW_PREDICATE = entity -> entity != null && RatUtils.isCow((Entity)entity) && !entity.m_6162_();

    public RatMilkCowGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(false, false)) {
            return false;
        }
        if (!this.rat.transportingFluid.isEmpty() && this.rat.transportingFluid.getAmount() >= this.rat.getMBTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.getTargetEntity() != null;
    }

    public boolean m_8045_() {
        return this.getTargetEntity() != null && (this.rat.transportingFluid.isEmpty() || this.rat.transportingFluid.getAmount() < this.rat.getMBTransferRate());
    }

    public void m_8037_() {
        if (this.getTargetEntity() != null && this.getTargetEntity().m_6084_() && (this.rat.transportingFluid.isEmpty() || this.rat.transportingFluid.getAmount() < this.rat.getMBTransferRate())) {
            this.rat.m_21573_().m_5624_(this.getTargetEntity(), 1.25);
            if (this.rat.m_20280_(this.getTargetEntity()) < this.rat.getRatHarvestDistance(0.0) && this.rat.transportingFluid.isEmpty()) {
                FluidBucketWrapper milkWrapper = new FluidBucketWrapper(new ItemStack((ItemLike)Items.f_42455_));
                FluidStack milkFluid = new FluidStack(milkWrapper.getFluid(), 1000);
                if (milkFluid.isEmpty()) {
                    milkFluid = new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
                }
                if (this.rat.transportingFluid.isEmpty() || this.rat.transportingFluid.getAmount() < this.rat.getMBTransferRate()) {
                    this.rat.transportingFluid = milkFluid.copy();
                    if (!this.rat.m_9236_().m_5776_()) {
                        RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateRatFluidPacket(this.rat.m_19879_(), this.rat.transportingFluid));
                    }
                    this.rat.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                    this.rat.m_146850_(GameEvent.f_223708_);
                    this.m_8041_();
                }
            }
        } else {
            this.m_8041_();
        }
    }

    private void resetTarget() {
        int radius = this.rat.getRadius();
        AABB bb = new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).m_82338_(this.rat.getSearchCenter());
        List list = this.rat.m_9236_().m_6443_(LivingEntity.class, bb, this.COW_PREDICATE);
        LivingEntity closestCow = null;
        for (LivingEntity base : list) {
            if (closestCow != null && !(base.m_20280_((Entity)this.rat) < closestCow.m_20280_((Entity)this.rat))) continue;
            closestCow = base;
        }
        if (closestCow != null) {
            this.setTargetEntity((Entity)closestCow);
        }
    }
}

