/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RatHarvestCropsGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;

    public RatHarvestCropsGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(this.rat.getDepositPos().isPresent(), this.rat.getDepositPos().isPresent())) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.rat.getRadius();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            BlockState state = this.rat.m_9236_().m_8055_(pos);
            if (!this.canHarvestBlock(this.rat.m_9236_(), pos, state)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.getTargetSorter());
            this.setTargetBlock((BlockPos)allBlocks.get(0));
        }
    }

    public boolean m_8045_() {
        return this.checkTheBasics(false, false) && this.getTargetBlock() != null && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null) {
            BlockState block = this.rat.m_9236_().m_8055_(this.getTargetBlock());
            this.rat.m_21573_().m_26519_((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_() + 0.5, 1.25);
            double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
            if (distance < this.rat.getRatHarvestDistance(0.0)) {
                if (block.m_204336_(BlockTags.f_13073_) || block.m_60713_(Blocks.f_50200_)) {
                    CropBlock crop;
                    Block block2 = block.m_60734_();
                    if (block2 instanceof CropBlock && !(crop = (CropBlock)block2).m_52307_(block)) {
                        this.setTargetBlock(null);
                        this.m_8041_();
                        return;
                    }
                    this.rat.m_9236_().m_46961_(this.getTargetBlock(), true);
                    if ((!RatConfig.ratsBreakBlockOnHarvest || RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_REPLANTER.get())) && block.m_60734_() instanceof BonemealableBlock) {
                        this.rat.m_9236_().m_46597_(this.getTargetBlock(), block.m_60734_().m_49966_());
                    }
                    this.m_8041_();
                } else if (block.m_60734_() instanceof SugarCaneBlock) {
                    this.rat.m_9236_().m_46961_(this.getTargetBlock(), true);
                    this.m_8041_();
                } else if (block.m_60713_(Blocks.f_50685_)) {
                    int i = (Integer)block.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                    int j = 1 + this.rat.m_9236_().f_46441_.m_188503_(2) + (i == 3 ? 1 : 0);
                    ItemStack itemstack = this.rat.m_6844_(EquipmentSlot.MAINHAND);
                    if (itemstack.m_41619_()) {
                        this.rat.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42780_));
                        --j;
                    }
                    if (j > 0) {
                        Block.m_49840_((Level)this.rat.m_9236_(), (BlockPos)this.getTargetBlock(), (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
                    }
                    this.rat.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
                    this.rat.m_9236_().m_7731_(this.getTargetBlock(), (BlockState)block.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
                    this.m_8041_();
                } else if (CaveVines.m_152951_((BlockState)block)) {
                    CaveVines.m_269473_((Entity)this.rat, (BlockState)block, (Level)this.rat.m_9236_(), (BlockPos)this.getTargetBlock());
                    this.m_8041_();
                }
            }
        }
    }

    private boolean canHarvestBlock(Level level, BlockPos pos, BlockState state) {
        if (!RatUtils.canRatBreakBlock(this.rat.m_9236_(), pos, this.rat)) {
            return false;
        }
        if (state.m_204336_(BlockTags.f_13073_)) {
            CropBlock crop;
            Block block = state.m_60734_();
            if (block instanceof CropBlock && !(crop = (CropBlock)block).m_52307_(state)) {
                return false;
            }
            if (!(state.m_60734_() instanceof StemBlock) && !(state.m_60734_() instanceof AttachedStemBlock)) {
                return true;
            }
        } else {
            if (state.m_60734_() instanceof SugarCaneBlock) {
                return level.m_8055_(pos.m_7495_()).m_60734_() instanceof SugarCaneBlock;
            }
            if (state.m_60734_() instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3) {
                return true;
            }
        }
        return state.m_60713_(Blocks.f_50685_) && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1 || CaveVines.m_152951_((BlockState)state);
    }
}

