/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.data.tags.RatsItemTags;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WildRatTargetFoodGoal
extends Goal {
    private final AbstractRat rat;
    private final PathNavigation navigation;
    @Nullable
    private ItemEntity targetItem = null;
    protected int nextStartTick;

    public WildRatTargetFoodGoal(AbstractRat rat) {
        this.rat = rat;
        this.navigation = rat.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.rat.canMove() || this.rat.m_269323_() != null || !this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() || this.rat.isEating()) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.m_183277_(RatConfig.ratUpdateDelay);
        List items = this.rat.m_9236_().m_6443_(ItemEntity.class, this.getTargetableArea(), item -> (item.m_20096_() || item.m_20069_()) && RatUtils.isRatFood(item.m_32055_()));
        if (items.isEmpty()) {
            return false;
        }
        items.sort(Comparator.comparingDouble(arg_0 -> ((AbstractRat)this.rat).m_20280_(arg_0)));
        for (ItemEntity item2 : items) {
            Path toPath = this.navigation.m_6570_((Entity)item2, 1);
            if (toPath == null || !toPath.m_77403_()) continue;
            this.targetItem = item2;
            return true;
        }
        return false;
    }

    protected AABB getTargetableArea() {
        return this.rat.m_20191_().m_82400_(32.0);
    }

    public boolean m_8045_() {
        return this.rat.m_6084_() && !this.navigation.m_26571_() && !this.navigation.m_26577_() && this.targetItem != null && !this.targetItem.m_213877_();
    }

    public void m_8056_() {
        if (this.targetItem != null) {
            this.navigation.m_5624_((Entity)this.targetItem, 1.25);
        }
    }

    public void m_8037_() {
        if (this.targetItem != null && !this.targetItem.m_213877_() && this.rat.m_20280_((Entity)this.targetItem) < 4.5 && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            Rat wildBoi;
            ItemStack duplicate = this.targetItem.m_32055_().m_41777_();
            duplicate.m_41764_(1);
            this.targetItem.m_32055_().m_41774_(1);
            if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.rat.m_9236_().m_5776_()) {
                this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            }
            this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
            AbstractRat abstractRat = this.rat;
            if (abstractRat instanceof Rat && !(wildBoi = (Rat)abstractRat).hasPlague() && (abstractRat = this.targetItem.m_19749_()) instanceof Player) {
                Player targetPlayer = (Player)abstractRat;
                if (duplicate.m_204117_(RatsItemTags.CHEESE_ITEMS)) {
                    wildBoi.setFleePos(this.targetItem.m_20183_());
                    wildBoi.wildTrust += 10 + wildBoi.m_217043_().m_188503_(10);
                    ++wildBoi.cheeseFeedings;
                    wildBoi.m_9236_().m_7605_((Entity)wildBoi, (byte)82);
                    if (wildBoi.wildTrust >= 100 && wildBoi.m_217043_().m_188503_(3) == 0 || wildBoi.cheeseFeedings >= 15) {
                        TamedRat tamedRat = RatUtils.tameRat(wildBoi, wildBoi.m_9236_());
                        tamedRat.m_9236_().m_7605_((Entity)wildBoi, (byte)83);
                        tamedRat.m_21828_(targetPlayer);
                        tamedRat.setCommand(RatCommand.SIT);
                    }
                }
            }
            this.m_8041_();
        }
    }
}

