/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RatTargetItemsGoal
extends Goal {
    private final TamedRat rat;
    @Nullable
    private ItemEntity targetItem = null;

    public RatTargetItemsGoal(TamedRat rat) {
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.rat.canMove() || this.rat.isInCage() || this.rat.isCurrentlyWorking) {
            return false;
        }
        if (!this.rat.isTargetCommand() || this.rat.getDepositPos().isEmpty()) {
            return false;
        }
        if (this.checkIfRatCanHold()) {
            List items = this.rat.m_9236_().m_6443_(ItemEntity.class, this.getTargetableArea(), item -> (item.m_20096_() || item.m_20069_()) && this.rat.shouldCollectItem(item.m_32055_()) && this.rat.canRatPickupItem(item.m_32055_()));
            if (items.isEmpty()) {
                return false;
            }
            items.sort(Comparator.comparingDouble(arg_0 -> ((TamedRat)this.rat).m_20280_(arg_0)));
            for (ItemEntity item2 : items) {
                Path toPath = this.rat.m_21573_().m_6570_((Entity)item2, 1);
                if (toPath == null || !toPath.m_77403_() || !this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && !ItemStack.m_150942_((ItemStack)item2.m_32055_(), (ItemStack)this.rat.m_21120_(InteractionHand.MAIN_HAND))) continue;
                this.targetItem = item2;
                return true;
            }
        }
        return false;
    }

    private boolean checkIfRatCanHold() {
        ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41619_()) {
            return true;
        }
        return RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && stack.m_41613_() < 64;
    }

    protected AABB getTargetableArea() {
        if (this.rat.getRadiusCenter().isPresent()) {
            Vec3 center = new Vec3((double)this.rat.getSearchCenter().m_123341_() + 0.5, (double)this.rat.getSearchCenter().m_123342_() + 0.5, (double)this.rat.getSearchCenter().m_123343_() + 0.5);
            double radius = this.rat.getRadius();
            AABB aabb = new AABB(-radius, -radius, -radius, radius, radius, radius);
            return aabb.m_82383_(center);
        }
        return this.rat.m_20191_().m_82400_(8.0);
    }

    public boolean m_8045_() {
        return this.rat.m_6084_() && !this.rat.isCurrentlyWorking && !this.rat.m_21573_().m_26571_() && !this.rat.m_21573_().m_26577_() && this.targetItem != null && !this.targetItem.m_213877_() && this.checkIfRatCanHold();
    }

    public void m_8056_() {
        if (this.targetItem != null) {
            this.rat.m_21573_().m_5624_((Entity)this.targetItem, 1.25);
        }
    }

    public void m_8041_() {
        this.targetItem = null;
    }

    public void m_8037_() {
        if (this.targetItem != null && !this.targetItem.m_213877_()) {
            if (this.rat.m_20280_((Entity)this.targetItem) < this.rat.getRatHarvestDistance(1.0)) {
                ItemStack duplicate = this.targetItem.m_32055_().m_41777_();
                if (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get())) {
                    ItemStack alreadyHolding = this.rat.m_21120_(InteractionHand.MAIN_HAND);
                    int extractSize = alreadyHolding.m_41613_() + duplicate.m_41613_() < 64 ? duplicate.m_41613_() : Math.min(64 - alreadyHolding.m_41613_(), duplicate.m_41613_());
                    duplicate.m_41764_(extractSize);
                    this.targetItem.m_32055_().m_41774_(extractSize);
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)duplicate.m_41720_(), alreadyHolding.m_41613_() + extractSize));
                } else {
                    duplicate.m_41764_(1);
                    this.targetItem.m_32055_().m_41774_(1);
                    if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                        this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                    }
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
                }
                this.m_8041_();
            } else {
                this.rat.m_21573_().m_5624_((Entity)this.targetItem, (double)1.225f);
            }
        }
    }
}

