/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.ai.goal.RatMoveToBlockGoal;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import com.github.alexthe666.rats.server.misc.RatPathingHelper;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.ForgeEventFactory;

public class RatRaidCropsGoal
extends RatMoveToBlockGoal {
    private final DiggingRat rat;

    public RatRaidCropsGoal(DiggingRat rat) {
        super((PathfinderMob)rat, 1.0, 16);
        this.rat = rat;
    }

    public boolean m_8036_() {
        if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        if (!this.rat.canMove() || this.rat.raidCooldown > 0 || !RatConfig.ratsBreakCrops || this.rat.m_269323_() != null) {
            return false;
        }
        return ForgeEventFactory.getMobGriefingEvent((Level)this.rat.m_9236_(), (Entity)this.rat) && super.m_8036_();
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            BlockPos cropsPos = this.f_25602_.m_7494_();
            BlockState block = this.rat.m_9236_().m_8055_(cropsPos);
            double distance = this.rat.m_20275_(cropsPos.m_123341_(), cropsPos.m_123342_(), cropsPos.m_123343_());
            if (distance < 3.5) {
                LootParams.Builder loot = new LootParams.Builder((ServerLevel)this.rat.m_9236_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81460_, (Object)this.rat.m_20182_()).m_287239_(1.0f);
                List drops = block.m_60734_().m_49635_(block, loot);
                if (drops.isEmpty()) {
                    this.m_8041_();
                    return;
                }
                int count = 0;
                for (ItemStack stack2 : drops) {
                    if (count == 0) {
                        ItemStack duplicate = stack2.m_41777_();
                        duplicate.m_41764_(1);
                        if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.rat.m_9236_().m_5776_()) {
                            this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                        }
                        this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
                        drops.remove(stack2);
                    }
                    ++count;
                }
                this.rat.m_9236_().m_46961_(cropsPos, false);
                drops.forEach(stack -> this.rat.m_5552_((ItemStack)stack, 0.0f));
                this.rat.setFleePos(cropsPos);
                this.rat.raidCooldown = 200;
            }
        }
    }

    protected boolean m_6465_(LevelReader reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos);
        BlockState cropState = reader.m_8055_(pos.m_7494_());
        if (state.m_60734_() instanceof FarmBlock) {
            if (!RatPathingHelper.canSeeOrDigToBlock(this.rat, pos.m_7494_())) {
                return false;
            }
            Block block = cropState.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                return crop.m_52307_(cropState);
            }
            return cropState.m_204336_(BlockTags.f_13073_) && !(cropState.m_60734_() instanceof StemBlock) && RatUtils.canRatBreakBlock(this.rat.m_9236_(), pos.m_7494_(), this.rat);
        }
        return false;
    }
}

