/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.server.block.RatTrapBlock;
import com.github.alexthe666.rats.server.block.entity.RatTrapBlockEntity;
import com.github.alexthe666.rats.server.entity.ai.goal.RatMoveToBlockGoal;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RatEnterTrapGoal
extends RatMoveToBlockGoal {
    private final Rat rat;

    public RatEnterTrapGoal(Rat rat) {
        super((PathfinderMob)rat, 1.0, 16);
        this.rat = rat;
    }

    public static boolean isTrap(LevelReader world, BlockPos pos) {
        BlockState block = world.m_8055_(pos.m_7494_());
        if (block.m_60713_((Block)RatsBlockRegistry.RAT_TRAP.get())) {
            BlockEntity rat = world.m_7702_(pos.m_7494_());
            return rat != null && (Boolean)block.m_61143_((Property)RatTrapBlock.SHUT) == false && !((RatTrapBlockEntity)rat).getBait().m_41619_();
        }
        return false;
    }

    public boolean m_8036_() {
        if (this.rat.canMove() && this.rat.m_269323_() == null && !this.rat.m_21523_()) {
            if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return false;
            }
            return (this.f_25600_ > 0 || ForgeEventFactory.getMobGriefingEvent((Level)this.rat.m_9236_(), (Entity)this.rat)) && super.m_8036_();
        }
        return false;
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.rat.isDeadInTrap() && this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public boolean canSeeTrap() {
        BlockHitResult result = this.rat.m_9236_().m_45547_(new ClipContext(this.rat.m_20182_(), Vec3.m_82512_((Vec3i)this.f_25602_), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.rat));
        BlockPos pos = result.m_82425_();
        BlockPos sidePos = result.m_82425_().m_121945_(result.m_82434_());
        return this.rat.m_9236_().m_46859_(sidePos) || this.rat.m_9236_().m_46859_(pos);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            double distance;
            RatTrapBlockEntity trap;
            BlockPos trapPos = this.f_25602_.m_7494_();
            BlockEntity rat = this.rat.m_9236_().m_7702_(trapPos);
            if (rat instanceof RatTrapBlockEntity && !((Boolean)(trap = (RatTrapBlockEntity)rat).m_58900_().m_61143_((Property)RatTrapBlock.SHUT)).booleanValue() && !trap.getBait().m_41619_() && (distance = this.rat.m_20275_(trapPos.m_123341_(), trapPos.m_123342_(), trapPos.m_123343_())) < 1.0 && this.canSeeTrap() && !this.rat.isDeadInTrap()) {
                ItemStack duplicate = trap.getBait().m_41777_();
                duplicate.m_41764_(1);
                if (!this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.rat.m_9236_().m_5776_()) {
                    this.rat.m_5552_(this.rat.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                }
                this.rat.m_21008_(InteractionHand.MAIN_HAND, duplicate);
                trap.getBait().m_41774_(1);
                this.rat.m_9236_().m_7260_(trapPos, this.rat.m_9236_().m_8055_(trapPos), this.rat.m_9236_().m_8055_(trapPos), 3);
                this.rat.setFleePos(this.f_25602_);
            }
        }
    }

    protected boolean m_6465_(LevelReader level, BlockPos pos) {
        return RatEnterTrapGoal.isTrap(level, pos);
    }
}

