/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.server.items.upgrades.CombinedRatUpgradeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class UpgradeSeparatorBlockEntity
extends BlockEntity {
    public float ratRotation;
    public float ratRotationPrev;

    public UpgradeSeparatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.UPGRADE_SEPERATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UpgradeSeparatorBlockEntity te) {
        te.ratRotationPrev = te.ratRotation;
        te.ratRotation += 1.0f;
        float i = (float)pos.m_123341_() + 0.5f;
        float j = (float)pos.m_123342_() + 0.75f;
        float k = (float)pos.m_123343_() + 0.5f;
        double d0 = 0.5;
        for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, new AABB((double)i - d0, (double)j - d0, (double)k - d0, (double)i + d0, (double)j + d0, (double)k + d0))) {
            ItemStack item = itemEntity.m_32055_();
            if (!(item.m_41720_() instanceof CombinedRatUpgradeItem)) continue;
            CompoundTag CompoundNBT1 = item.m_41783_();
            int spawnedItem = 0;
            if (CompoundNBT1 != null && CompoundNBT1.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)CompoundNBT1, (NonNullList)nonnulllist);
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ItemEntity splitEntity = new ItemEntity(level, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), itemstack.m_41777_());
                    if (!level.m_5776_()) {
                        level.m_7967_((Entity)splitEntity);
                    }
                    ++spawnedItem;
                }
            }
            if (spawnedItem <= 0) continue;
            itemEntity.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
            itemEntity.m_6074_();
            ItemEntity splitEntity = new ItemEntity(level, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), new ItemStack((ItemLike)UpgradeSeparatorBlockEntity.getFuel(), spawnedItem));
            if (level.m_5776_()) continue;
            level.m_7967_((Entity)splitEntity);
        }
    }

    public static Item getFuel() {
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED) {
            return (Item)RatlantisItemRegistry.GEM_OF_RATLANTIS.get();
        }
        return Items.f_42616_;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 2, 1));
    }
}

