/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.server.inventory.UpgradeCombinerMenu;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.CombinedRatUpgradeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeCombinerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS_TOP = new int[]{0, 2};
    private static final int[] SLOTS_SIDE = new int[]{1};
    private static final int[] SLOTS_BOTTOM = new int[]{3};
    public int tickCount;
    public float ratRotation;
    public float ratRotationPrev;
    public float tRot;
    public int burnTime;
    public int burnDuration;
    public int cookTime;
    public int totalCookTime;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private NonNullList<ItemStack> combinerStacks = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> UpgradeCombinerBlockEntity.this.cookTime;
                case 1 -> UpgradeCombinerBlockEntity.this.totalCookTime;
                case 2 -> UpgradeCombinerBlockEntity.this.burnTime;
                case 3 -> UpgradeCombinerBlockEntity.this.burnDuration;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    UpgradeCombinerBlockEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    UpgradeCombinerBlockEntity.this.totalCookTime = value;
                    break;
                }
                case 2: {
                    UpgradeCombinerBlockEntity.this.burnTime = value;
                    break;
                }
                case 3: {
                    UpgradeCombinerBlockEntity.this.burnDuration = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public UpgradeCombinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.UPGRADE_COMBINER.get(), pos, state);
    }

    public static int getItemBurnTime(ItemStack stack) {
        return stack.m_41720_() == UpgradeCombinerBlockEntity.getFuel() ? 150 : 0;
    }

    public static Item getFuel() {
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED) {
            return (Item)RatlantisItemRegistry.GEM_OF_RATLANTIS.get();
        }
        return Items.f_42616_;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 2, 1));
    }

    public int m_6643_() {
        return this.combinerStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.combinerStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.combinerStacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.combinerStacks, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.combinerStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.combinerStacks.get(index);
        boolean flag = !stack.m_41619_() && stack.m_150930_(itemstack.m_41720_()) && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack);
        this.combinerStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = 300;
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.combinerStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.combinerStacks);
        this.burnTime = compound.m_128451_("BurnTime");
        this.cookTime = compound.m_128451_("CookTime");
        this.totalCookTime = compound.m_128451_("CookTimeTotal");
        this.burnDuration = UpgradeCombinerBlockEntity.getItemBurnTime((ItemStack)this.combinerStacks.get(1));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BurnTime", (int)((short)this.burnTime));
        compound.m_128405_("CookTime", (int)((short)this.cookTime));
        compound.m_128405_("CookTimeTotal", (int)((short)this.totalCookTime));
        ContainerHelper.m_18973_((CompoundTag)compound, this.combinerStacks);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, UpgradeCombinerBlockEntity te) {
        float f2;
        te.totalCookTime = 300;
        te.ratRotationPrev = te.ratRotation;
        ++te.tickCount;
        Player player = level.m_45924_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 10.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - (double)((float)pos.m_123341_() + 0.5f);
            double d1 = player.m_20189_() - (double)((float)pos.m_123343_() + 0.5f);
            te.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
        } else {
            te.tRot += 0.04f;
        }
        while (te.ratRotation >= (float)Math.PI) {
            te.ratRotation -= (float)Math.PI * 2;
        }
        while (te.ratRotation < (float)(-Math.PI)) {
            te.ratRotation += (float)Math.PI * 2;
        }
        for (f2 = te.tRot - te.ratRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        te.ratRotation += f2 * 0.4f;
        if (te.isBurning()) {
            --te.burnTime;
        }
        if (level.m_5776_()) {
            float radius = (float)Math.sin((double)te.tickCount * 0.1);
            double extraY = (double)pos.m_123342_() + 1.05;
            for (int i = 0; i < 3; ++i) {
                float angle = (float)Math.PI / 180 * (float)(te.tickCount * 4 + i * 120);
                double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + (double)pos.m_123341_() + 0.5;
                double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)RatsParticleRegistry.UPGRADE_COMBINER.get(), extraX, extraY, extraZ, 0.0, 0.0, 0.0);
            }
        }
        ItemStack fuel = (ItemStack)te.combinerStacks.get(1);
        if (te.isBurning() || !fuel.m_41619_() && !((ItemStack)te.combinerStacks.get(0)).m_41619_() && !((ItemStack)te.combinerStacks.get(2)).m_41619_()) {
            if (!te.isBurning() && te.canSmelt()) {
                te.burnDuration = te.burnTime = UpgradeCombinerBlockEntity.getItemBurnTime(fuel);
                if (te.isBurning() && !fuel.m_41619_()) {
                    Item item = fuel.m_41720_();
                    fuel.m_41774_(1);
                    if (fuel.m_41619_()) {
                        ItemStack item1 = item.getCraftingRemainingItem(fuel);
                        te.combinerStacks.set(1, (Object)item1);
                    }
                }
            }
            if (te.isBurning() && te.canSmelt()) {
                ++te.cookTime;
                if (te.cookTime == te.totalCookTime) {
                    te.cookTime = 0;
                    te.totalCookTime = 300;
                    te.smeltItem();
                }
            } else {
                te.cookTime = 0;
            }
        } else if (!te.isBurning() && te.cookTime > 0) {
            te.cookTime = Mth.m_14045_((int)(te.cookTime - 2), (int)0, (int)te.totalCookTime);
        }
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = (ItemStack)this.combinerStacks.get(0);
            ItemStack itemstack2 = (ItemStack)this.combinerStacks.get(3);
            ItemStack itemstack1 = this.getCombinerResult(itemstack, (ItemStack)this.combinerStacks.get(2));
            if (itemstack2.m_41619_()) {
                this.combinerStacks.set(3, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_150930_(itemstack1.m_41720_())) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
            ((ItemStack)this.combinerStacks.get(2)).m_41774_(1);
        }
    }

    private ItemStack getCombinerResult(ItemStack combiner, ItemStack stack) {
        if (!combiner.m_41782_()) {
            combiner.m_41751_(new CompoundTag());
        }
        CompoundTag tag = combiner.m_41783_();
        NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        if (tag != null && tag.m_128441_("Items")) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
        }
        int addIndex = -1;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            if (nonnulllist.get(i) != ItemStack.f_41583_) continue;
            addIndex = i;
            break;
        }
        if (addIndex == -1) {
            return combiner.m_41777_();
        }
        nonnulllist.set(addIndex, (Object)stack.m_41777_());
        ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)nonnulllist);
        combiner.m_41751_(tag);
        return combiner.m_41777_();
    }

    public boolean canSmelt() {
        if (!((ItemStack)this.combinerStacks.get(0)).m_41619_() && ((ItemStack)this.combinerStacks.get(0)).m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED.get())) {
            return CombinedRatUpgradeItem.canCombineWithUpgrade((ItemStack)this.combinerStacks.get(0), (ItemStack)this.combinerStacks.get(2));
        }
        return false;
    }

    public static boolean canCombine(ItemStack combinerSlot, ItemStack toBeCombinedSlot) {
        if (!combinerSlot.m_41619_() && combinerSlot.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_COMBINED.get())) {
            return CombinedRatUpgradeItem.canCombineWithUpgrade(combinerSlot, toBeCombinedSlot);
        }
        return false;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index == 2) {
            return stack.m_41720_() instanceof BaseRatUpgradeItem && !(stack.m_41720_() instanceof CombinedRatUpgradeItem);
        }
        if (index == 1) {
            return stack.m_41720_() == UpgradeCombinerBlockEntity.getFuel();
        }
        return stack.m_41720_() instanceof CombinedRatUpgradeItem;
    }

    public void m_6211_() {
        this.combinerStacks.clear();
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        if (side == Direction.UP) {
            return SLOTS_TOP;
        }
        return SLOTS_SIDE;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && index == 1;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.rats.upgrade_combiner");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new UpgradeCombinerMenu(id, (Container)this, player, this.data);
    }
}

