/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.block.CustomItemRarity;
import com.github.alexthe666.rats.server.block.entity.RatlantisPortalBlockEntity;
import com.github.alexthe666.rats.server.world.RatlantisTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class RatlantisPortalBlock
extends BaseEntityBlock
implements CustomItemRarity {
    public RatlantisPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Rarity getRarity() {
        return Rarity.EPIC;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED && !entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                ServerLevel dest;
                ResourceKey<Level> destination;
                if (!entity.m_9236_().m_5776_() && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                MinecraftServer server = entity.m_9236_().m_7654_();
                ResourceKey<Level> resourceKey = destination = entity.m_9236_().m_46472_() == RatlantisDimensionRegistry.DIMENSION_KEY ? Level.f_46428_ : RatlantisDimensionRegistry.DIMENSION_KEY;
                if (server != null && (dest = server.m_129880_(destination)) != null && server.m_7079_() && !entity.m_20159_()) {
                    entity.m_9236_().m_46473_().m_6180_("ratlantis_portal");
                    entity.m_20091_();
                    entity.changeDimension(dest, (ITeleporter)new RatlantisTeleporter(dest));
                    entity.m_20256_(Vec3.f_82478_);
                    entity.m_9236_().m_46473_().m_7238_();
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurviveAt(level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean canSurviveAt(Level level, BlockPos pos) {
        return !(!level.m_8055_(pos.m_7494_()).m_60713_((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get()) && !level.m_8055_(pos.m_7494_()).m_204336_(RatsBlockTags.MARBLED_CHEESE) || !level.m_8055_(pos.m_7495_()).m_60713_((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get()) && !level.m_8055_(pos.m_7495_()).m_204336_(RatsBlockTags.MARBLED_CHEESE));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity be;
        if (RatsMod.RATLANTIS_DATAPACK_ENABLED && (be = level.m_7702_(pos)) instanceof RatlantisPortalBlockEntity) {
            for (int j = 0; j < 2; ++j) {
                double d0 = (float)pos.m_123341_() + random.m_188501_();
                double d1 = (float)pos.m_123342_() + random.m_188501_();
                double d2 = (float)pos.m_123343_() + random.m_188501_();
                double d3 = ((double)random.m_188501_() - 0.5) * 0.5;
                double d4 = ((double)random.m_188501_() - 0.5) * 0.5;
                double d5 = ((double)random.m_188501_() - 0.5) * 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RatlantisPortalBlockEntity(pos, state);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

