/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import com.github.alexthe666.rats.server.block.entity.RatTubeBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.RatTubeItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RatTubeBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty OPEN_NORTH = BooleanProperty.m_61465_((String)"open_north");
    public static final BooleanProperty OPEN_EAST = BooleanProperty.m_61465_((String)"open_east");
    public static final BooleanProperty OPEN_SOUTH = BooleanProperty.m_61465_((String)"open_south");
    public static final BooleanProperty OPEN_WEST = BooleanProperty.m_61465_((String)"open_west");
    public static final BooleanProperty OPEN_UP = BooleanProperty.m_61465_((String)"open_up");
    public static final BooleanProperty OPEN_DOWN = BooleanProperty.m_61465_((String)"open_down");
    public static final BooleanProperty[] ALL_OPEN_PROPS = new BooleanProperty[]{OPEN_DOWN, OPEN_UP, OPEN_NORTH, OPEN_SOUTH, OPEN_WEST, OPEN_EAST};
    private static final VoxelShape UP_AABB = Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_1 = Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0);
    private static final VoxelShape UP_AABB_CONNECT_2 = Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_3 = Block.m_49796_((double)12.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape UP_AABB_CONNECT_4 = Block.m_49796_((double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0);
    private static final Map<Direction, VoxelShape> AABB_MAP = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> AABB_CONNECTOR_1_MAP = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> AABB_CONNECTOR_2_MAP = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> AABB_CONNECTOR_3_MAP = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> AABB_CONNECTOR_4_MAP = new HashMap<Direction, VoxelShape>();
    private static final Map<String, VoxelShape> OVERALL_AABB_MAP = new HashMap<String, VoxelShape>();

    public RatTubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape rotateAABB(VoxelShape aabb, Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> aabb;
            case Direction.DOWN -> RatTubeBlock.makeCuboidShapeNoResize(aabb.m_83215_().f_82288_, 1.0 - aabb.m_83215_().f_82292_, aabb.m_83215_().f_82290_, aabb.m_83215_().f_82291_, 1.0 - aabb.m_83215_().f_82289_, aabb.m_83215_().f_82293_);
            case Direction.NORTH -> RatTubeBlock.makeCuboidShapeNoResize(aabb.m_83215_().f_82288_, aabb.m_83215_().f_82290_, 1.0 - aabb.m_83215_().f_82292_, aabb.m_83215_().f_82291_, aabb.m_83215_().f_82293_, 1.0 - aabb.m_83215_().f_82289_);
            case Direction.SOUTH -> RatTubeBlock.makeCuboidShapeNoResize(aabb.m_83215_().f_82288_, aabb.m_83215_().f_82290_, aabb.m_83215_().f_82289_, aabb.m_83215_().f_82291_, aabb.m_83215_().f_82293_, aabb.m_83215_().f_82292_);
            case Direction.EAST -> RatTubeBlock.makeCuboidShapeNoResize(aabb.m_83215_().f_82289_, aabb.m_83215_().f_82288_, aabb.m_83215_().f_82290_, aabb.m_83215_().f_82292_, aabb.m_83215_().f_82291_, aabb.m_83215_().f_82293_);
            case Direction.WEST -> RatTubeBlock.makeCuboidShapeNoResize(1.0 - aabb.m_83215_().f_82292_, aabb.m_83215_().f_82288_, aabb.m_83215_().f_82290_, 1.0 - aabb.m_83215_().f_82289_, aabb.m_83215_().f_82291_, aabb.m_83215_().f_82293_);
        };
    }

    public static VoxelShape makeCuboidShapeNoResize(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Shapes.m_166049_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_60734_() instanceof RatTubeBlock) {
            String key = "up:" + state.m_61143_((Property)UP) + " down: " + state.m_61143_((Property)DOWN) + " north: " + state.m_61143_((Property)NORTH) + " east: " + state.m_61143_((Property)EAST) + " south: " + state.m_61143_((Property)SOUTH) + " west: " + state.m_61143_((Property)WEST) + "up_open:" + state.m_61143_((Property)OPEN_UP) + " down_open: " + state.m_61143_((Property)OPEN_DOWN) + " north_open: " + state.m_61143_((Property)OPEN_NORTH) + " east_open: " + state.m_61143_((Property)OPEN_EAST) + " south_open: " + state.m_61143_((Property)OPEN_SOUTH) + " west_open: " + state.m_61143_((Property)OPEN_WEST);
            if (OVERALL_AABB_MAP.get(key) == null) {
                VoxelShape shape = this.generateRatTubeState(state);
                OVERALL_AABB_MAP.put(key, shape);
                return shape;
            }
            return OVERALL_AABB_MAP.get(key);
        }
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape generateRatTubeState(BlockState state) {
        VoxelShape shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        if (state.m_60734_() instanceof RatTubeBlock) {
            if (!((Boolean)state.m_61143_((Property)UP)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_UP)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.UP, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (!((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_DOWN)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.DOWN, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (!((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_NORTH)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.NORTH, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (!((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_SOUTH)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.SOUTH, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (!((Boolean)state.m_61143_((Property)EAST)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_EAST)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.EAST, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (!((Boolean)state.m_61143_((Property)WEST)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN_WEST)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB, Direction.WEST, AABB_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.UP, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.UP, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.UP, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.UP, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.DOWN, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.DOWN, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.DOWN, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.DOWN, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.NORTH, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.NORTH, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.NORTH, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.NORTH, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.SOUTH, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.SOUTH, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.SOUTH, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.SOUTH, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.EAST, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.EAST, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.EAST, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.EAST, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_1, Direction.WEST, AABB_CONNECTOR_1_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_2, Direction.WEST, AABB_CONNECTOR_2_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_3, Direction.WEST, AABB_CONNECTOR_3_MAP), (BooleanOp)BooleanOp.f_82695_);
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.rotateWithMap(UP_AABB_CONNECT_4, Direction.WEST, AABB_CONNECTOR_4_MAP), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape.m_83296_();
    }

    public VoxelShape rotateWithMap(VoxelShape aabb, Direction facing, Map<Direction, VoxelShape> checkMap) {
        if (checkMap.get(facing) == null) {
            VoxelShape newAABB = RatTubeBlock.rotateAABB(aabb, facing);
            checkMap.put(facing, newAABB);
            return newAABB;
        }
        return checkMap.get(facing);
    }

    private boolean canBeOpenNextToBlock(BlockState sideState) {
        return !(sideState.m_60734_() instanceof RatTubeBlock);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, OPEN_NORTH, OPEN_SOUTH, OPEN_EAST, OPEN_WEST, OPEN_UP, OPEN_DOWN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level getter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockPos blockpos6 = blockpos.m_7495_();
        BlockState blockstate = getter.m_8055_(blockpos1);
        BlockState blockstate1 = getter.m_8055_(blockpos2);
        BlockState blockstate2 = getter.m_8055_(blockpos3);
        BlockState blockstate3 = getter.m_8055_(blockpos4);
        BlockState blockstate4 = getter.m_8055_(blockpos5);
        BlockState blockstate5 = getter.m_8055_(blockpos6);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate1)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate2)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate3)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate4)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(blockstate5)));
    }

    private boolean canConnectTo(BlockState state) {
        return state.m_60734_() instanceof RatCageBlock || state.m_60734_() instanceof RatTubeBlock;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_() || player.m_21120_(hand).m_41720_() instanceof BlockItem || player.m_21120_(hand).m_41720_() instanceof RatTubeItem) {
            return InteractionResult.PASS;
        }
        Direction side = hit.m_82434_();
        BooleanProperty[] allOpenVars = new BooleanProperty[]{OPEN_DOWN, OPEN_EAST, OPEN_NORTH, OPEN_SOUTH, OPEN_UP, OPEN_WEST};
        BooleanProperty changing = switch (side) {
            case Direction.NORTH -> OPEN_NORTH;
            case Direction.SOUTH -> OPEN_SOUTH;
            case Direction.EAST -> OPEN_EAST;
            case Direction.WEST -> OPEN_WEST;
            case Direction.DOWN -> OPEN_DOWN;
            default -> OPEN_UP;
        };
        boolean alreadyOpened = false;
        for (BooleanProperty opened : allOpenVars) {
            if (!((Boolean)state.m_61143_((Property)opened)).booleanValue()) continue;
            alreadyOpened = true;
        }
        if (!alreadyOpened && this.canBeOpenNextToBlock(level.m_8055_(pos.m_121945_(side)))) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)changing, (Comparable)Boolean.valueOf(true)));
            this.updateTEOpening(level, pos, side, true);
        } else {
            level.m_46597_(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)OPEN_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN_DOWN, (Comparable)Boolean.valueOf(false)));
            this.updateTEOpening(level, pos, side, false);
        }
        return InteractionResult.SUCCESS;
    }

    private void updateTEOpening(Level world, BlockPos pos, Direction side, boolean open) {
        BlockEntity blockEntity;
        if (world.m_7702_(pos) != null && (blockEntity = world.m_7702_(pos)) instanceof RatTubeBlockEntity) {
            RatTubeBlockEntity tube = (RatTubeBlockEntity)blockEntity;
            tube.setEntranceData(side, open);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity living, ItemStack stack) {
        BlockEntity blockEntity;
        if (level.m_7702_(pos) != null && (blockEntity = level.m_7702_(pos)) instanceof RatTubeBlockEntity) {
            RatTubeBlockEntity tube = (RatTubeBlockEntity)blockEntity;
            tube.setColor(this.getColorFromStack(stack));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity = level.m_7702_(pos);
        if (tileentity instanceof RatTubeBlockEntity && !player.m_7500_()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)RatTubeBlock.getTubeItem((BlockGetter)level, pos));
        }
        super.m_5707_(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter getter, BlockPos pos, Player player) {
        return RatTubeBlock.getTubeItem(getter, pos);
    }

    private static ItemStack getTubeItem(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        int color = 0;
        if (level.m_7702_(pos) != null && (blockEntity = level.m_7702_(pos)) instanceof RatTubeBlockEntity) {
            RatTubeBlockEntity tube = (RatTubeBlockEntity)blockEntity;
            color = tube.getColor();
        }
        Item item = (Item)RatsItemRegistry.RAT_TUBES[Mth.m_14045_((int)color, (int)0, (int)15)].get();
        return new ItemStack((ItemLike)item);
    }

    private int getColorFromStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof RatTubeItem) {
            RatTubeItem tube = (RatTubeItem)item;
            return tube.color.ordinal();
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RatTubeBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty notOpen;
        BooleanProperty connect = switch (facing) {
            case Direction.NORTH -> {
                notOpen = OPEN_NORTH;
                yield NORTH;
            }
            case Direction.SOUTH -> {
                notOpen = OPEN_SOUTH;
                yield SOUTH;
            }
            case Direction.EAST -> {
                notOpen = OPEN_EAST;
                yield EAST;
            }
            case Direction.WEST -> {
                notOpen = OPEN_WEST;
                yield WEST;
            }
            case Direction.DOWN -> {
                notOpen = OPEN_DOWN;
                yield DOWN;
            }
            default -> {
                notOpen = OPEN_UP;
                yield UP;
            }
        };
        BlockState newState = state;
        newState = (BlockState)newState.m_61124_((Property)connect, (Comparable)Boolean.valueOf(this.canConnectTo(facingState)));
        newState = (BlockState)newState.m_61124_((Property)notOpen, (Comparable)Boolean.valueOf(false));
        return newState;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RatTubeBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatsBlockEntityRegistry.RAT_TUBE.get()), RatTubeBlockEntity::tick);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        if (mob instanceof TamedRat) {
            TamedRat rat = (TamedRat)mob;
            return rat.isInTube() || rat.isInCage() ? BlockPathTypes.WALKABLE : BlockPathTypes.BLOCKED;
        }
        return BlockPathTypes.BLOCKED;
    }
}

