/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.server.block.entity.AutoCurdlerBlockEntity;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateCurdlerFluidPacket;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AutoCurdlerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape AABB_BASE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape AABB_TANK = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)18.0, (double)13.0);
    private static final VoxelShape AABB = Shapes.m_83110_((VoxelShape)AABB_BASE, (VoxelShape)AABB_TANK);

    public AutoCurdlerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"block.rats.auto_curdler.desc0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.rats.auto_curdler.desc1").m_130940_(ChatFormatting.GRAY));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof AutoCurdlerBlockEntity) {
            AutoCurdlerBlockEntity curdler = (AutoCurdlerBlockEntity)be;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)curdler);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (AutoCurdlerBlockEntity.isMilk(stack) && (blockEntity = level.m_7702_(pos)) instanceof AutoCurdlerBlockEntity) {
                AutoCurdlerBlockEntity te = (AutoCurdlerBlockEntity)blockEntity;
                if (!level.m_5776_() && FluidUtil.getFluidHandler((ItemStack)stack).resolve().isPresent()) {
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                    IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).resolve().get();
                    FluidStack drain = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if ((drain.getAmount() > 0 || stack.m_150930_(Items.f_42455_)) && te.getTank().fill(fluidStack.copy(), IFluidHandler.FluidAction.SIMULATE) != 0) {
                        int amount = te.getTank().fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                        level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!player.m_7500_()) {
                            fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                            ItemStack container = fluidHandler.getContainer();
                            if (stack != container) {
                                stack.m_41774_(1);
                                player.m_150109_().m_36054_(container);
                            } else if (stack.m_150930_(Items.f_42455_)) {
                                stack.m_41774_(1);
                                player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42446_));
                            }
                        }
                        RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateCurdlerFluidPacket(pos.m_121878_(), te.getTank().getFluid()));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            player.m_5893_(this.m_7246_(state, level, pos));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AutoCurdlerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AutoCurdlerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatsBlockEntityRegistry.AUTO_CURDLER.get()), AutoCurdlerBlockEntity::tick);
    }
}

