/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry;

import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.server.entity.misc.LaserPortal;
import com.github.alexthe666.rats.server.entity.misc.PiratBoat;
import com.github.alexthe666.rats.server.entity.misc.PiratWoodBoat;
import com.github.alexthe666.rats.server.entity.misc.PiratWoodChestBoat;
import com.github.alexthe666.rats.server.entity.misc.RatProtector;
import com.github.alexthe666.rats.server.entity.misc.Ratfish;
import com.github.alexthe666.rats.server.entity.misc.RattlingGun;
import com.github.alexthe666.rats.server.entity.monster.FeralRatlantean;
import com.github.alexthe666.rats.server.entity.monster.GhostPirat;
import com.github.alexthe666.rats.server.entity.monster.Pirat;
import com.github.alexthe666.rats.server.entity.monster.RatlanteanRatbot;
import com.github.alexthe666.rats.server.entity.monster.RatlanteanSpirit;
import com.github.alexthe666.rats.server.entity.monster.boss.Dutchrat;
import com.github.alexthe666.rats.server.entity.monster.boss.NeoRatlantean;
import com.github.alexthe666.rats.server.entity.monster.boss.RatBaron;
import com.github.alexthe666.rats.server.entity.monster.boss.RatBaronPlane;
import com.github.alexthe666.rats.server.entity.monster.boss.RatlanteanAutomaton;
import com.github.alexthe666.rats.server.entity.mount.RatAutomatonMount;
import com.github.alexthe666.rats.server.entity.mount.RatBiplaneMount;
import com.github.alexthe666.rats.server.entity.projectile.CheeseCannonball;
import com.github.alexthe666.rats.server.entity.projectile.DutchratSword;
import com.github.alexthe666.rats.server.entity.projectile.GolemBeam;
import com.github.alexthe666.rats.server.entity.projectile.LaserBeam;
import com.github.alexthe666.rats.server.entity.projectile.RatlanteanFlame;
import com.github.alexthe666.rats.server.entity.projectile.RatlantisArrow;
import com.github.alexthe666.rats.server.entity.projectile.RattlingGunBullet;
import com.github.alexthe666.rats.server.entity.projectile.VialOfSentience;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RatlantisEntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"rats");
    public static final RegistryObject<EntityType<RatlanteanSpirit>> RATLANTEAN_SPIRIT = RatlantisEntityRegistry.registerEntity("ratlantean_spirit", EntityType.Builder.m_20704_(RatlanteanSpirit::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(1.25f, 1.25f), 15580416, 16771247);
    public static final RegistryObject<EntityType<RatlanteanFlame>> RATLANTEAN_FLAME = RatlantisEntityRegistry.registerEntityNoEgg("ratlantean_spirit_flame", EntityType.Builder.m_20704_(RatlanteanFlame::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatlanteanAutomaton>> RATLANTEAN_AUTOMATON = RatlantisEntityRegistry.registerEntity("ratlantean_automaton", EntityType.Builder.m_20704_(RatlanteanAutomaton::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(2.0f, 4.0f), 15262935, 7530837);
    public static final RegistryObject<EntityType<GolemBeam>> RATLANTEAN_AUTOMATON_BEAM = RatlantisEntityRegistry.registerEntityNoEgg("ratlantean_automaton_beam", EntityType.Builder.m_20704_(GolemBeam::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<FeralRatlantean>> FERAL_RATLANTEAN = RatlantisEntityRegistry.registerEntity("feral_ratlantean", EntityType.Builder.m_20704_(FeralRatlantean::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.85f, 1.2f), 0x30333E, 0xECECEC);
    public static final RegistryObject<EntityType<NeoRatlantean>> NEO_RATLANTEAN = RatlantisEntityRegistry.registerEntity("neo_ratlantean", EntityType.Builder.m_20704_(NeoRatlantean::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(0.8f, 1.3f), 0x30333E, 61423);
    public static final RegistryObject<EntityType<LaserBeam>> LASER_BEAM = RatlantisEntityRegistry.registerEntityNoEgg("laser_beam", EntityType.Builder.m_20704_(LaserBeam::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<LaserPortal>> LASER_PORTAL = RatlantisEntityRegistry.registerEntityNoEgg("laser_portal", EntityType.Builder.m_20704_(LaserPortal::new, (MobCategory)MobCategory.MISC).m_20699_(0.95f, 0.95f));
    public static final RegistryObject<EntityType<VialOfSentience>> VIAL_OF_SENTIENCE = RatlantisEntityRegistry.registerEntityNoEgg("vial_of_sentience", EntityType.Builder.m_20704_(VialOfSentience::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f));
    public static final RegistryObject<EntityType<PiratBoat>> PIRAT_BOAT = RatlantisEntityRegistry.registerEntityNoEgg("pirat_boat", EntityType.Builder.m_20704_(PiratBoat::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.75f, 0.8f));
    public static final RegistryObject<EntityType<Pirat>> PIRAT = RatlantisEntityRegistry.registerEntity("pirat", EntityType.Builder.m_20704_(Pirat::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.9f), 0x30333E, 11482682);
    public static final RegistryObject<EntityType<CheeseCannonball>> CHEESE_CANNONBALL = RatlantisEntityRegistry.registerEntityNoEgg("cheese_cannonball", EntityType.Builder.m_20704_(CheeseCannonball::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<GhostPirat>> GHOST_PIRAT = RatlantisEntityRegistry.registerEntity("ghost_pirat", EntityType.Builder.m_20704_(GhostPirat::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 0.75f), 0x54AA55, 0x7BD77D);
    public static final RegistryObject<EntityType<Dutchrat>> DUTCHRAT = RatlantisEntityRegistry.registerEntity("dutchrat", EntityType.Builder.m_20704_(Dutchrat::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.0f, 3.0f).m_20719_(), 0xBBF9BB, 13689525);
    public static final RegistryObject<EntityType<DutchratSword>> DUTCHRAT_SWORD = RatlantisEntityRegistry.registerEntityNoEgg("dutchrat_sword", EntityType.Builder.m_20704_(DutchratSword::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.95f, 0.95f));
    public static final RegistryObject<EntityType<Ratfish>> RATFISH = RatlantisEntityRegistry.registerEntity("ratfish", EntityType.Builder.m_20704_(Ratfish::new, (MobCategory)MobCategory.WATER_AMBIENT).m_20699_(0.45f, 0.45f), 0x30333E, 8300733);
    public static final RegistryObject<EntityType<RattlingGun>> RATTLING_GUN = RatlantisEntityRegistry.registerEntityNoEgg("rattling_gun", EntityType.Builder.m_20704_(RattlingGun::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 1.6f));
    public static final RegistryObject<EntityType<RattlingGunBullet>> RATTLING_GUN_BULLET = RatlantisEntityRegistry.registerEntityNoEgg("rattling_gun_bullet", EntityType.Builder.m_20704_(RattlingGunBullet::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f));
    public static final RegistryObject<EntityType<RatlanteanRatbot>> RATLANTEAN_RATBOT = RatlantisEntityRegistry.registerEntity("ratlantean_ratbot", EntityType.Builder.m_20704_(RatlanteanRatbot::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(1.2f, 1.3f), 0xA3A3A3, 0xFF0000);
    public static final RegistryObject<EntityType<RatAutomatonMount>> RAT_MOUNT_AUTOMATON = RatlantisEntityRegistry.registerEntityNoEgg("rat_mount_automaton", EntityType.Builder.m_20704_(RatAutomatonMount::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(2.0f, 3.5f));
    public static final RegistryObject<EntityType<RatBaron>> RAT_BARON = RatlantisEntityRegistry.registerEntity("rat_baron", EntityType.Builder.m_20704_(RatBaron::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 0.5f), 10422787, 14935514);
    public static final RegistryObject<EntityType<RatBaronPlane>> RAT_BARON_PLANE = RatlantisEntityRegistry.registerEntityNoEgg("rat_baron_plane", EntityType.Builder.m_20704_(RatBaronPlane::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(5.5f, 4.0f));
    public static final RegistryObject<EntityType<RatBiplaneMount>> RAT_MOUNT_BIPLANE = RatlantisEntityRegistry.registerEntityNoEgg("rat_mount_biplane", EntityType.Builder.m_20704_(RatBiplaneMount::new, (MobCategory)MobCategory.MISC).m_20699_(3.5f, 2.3f));
    public static final RegistryObject<EntityType<RatProtector>> RAT_PROTECTOR = RatlantisEntityRegistry.registerEntityNoEgg("rat_protector", EntityType.Builder.m_20704_(RatProtector::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatlantisArrow>> RATLANTIS_ARROW = RatlantisEntityRegistry.registerEntityNoEgg("ratlantis_arrow", EntityType.Builder.m_20704_(RatlantisArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<PiratWoodBoat>> BOAT = RatlantisEntityRegistry.registerEntityNoEgg("boat", EntityType.Builder.m_20704_(PiratWoodBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10));
    public static final RegistryObject<EntityType<PiratWoodChestBoat>> CHEST_BOAT = RatlantisEntityRegistry.registerEntityNoEgg("chest_boat", EntityType.Builder.m_20704_(PiratWoodChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10));

    private static <E extends Mob> RegistryObject<EntityType<E>> registerEntity(String entityName, EntityType.Builder<E> builder, int baseEggColor, int overlayEggColor) {
        ResourceLocation nameLoc = new ResourceLocation("rats", entityName);
        RegistryObject ret = ENTITIES.register(entityName, () -> builder.m_20712_(nameLoc.toString()));
        RatlantisItemRegistry.ITEMS.register(entityName + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)ret, baseEggColor, overlayEggColor, new Item.Properties()));
        return ret;
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> registerEntityNoEgg(String entityName, EntityType.Builder<E> builder) {
        return ENTITIES.register(entityName, () -> builder.m_20712_(new ResourceLocation("rats", entityName).toString()));
    }
}

