/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.data;

import com.github.alexthe666.rats.data.BiomeModifierGenerator;
import com.github.alexthe666.rats.data.BlockModelGenerator;
import com.github.alexthe666.rats.data.ItemModelGenerator;
import com.github.alexthe666.rats.data.RatsAdvancementProvider;
import com.github.alexthe666.rats.data.RatsLangGenerator;
import com.github.alexthe666.rats.data.RatsLootModifierGenerator;
import com.github.alexthe666.rats.data.RatsRecipes;
import com.github.alexthe666.rats.data.RatsStructureUpdater;
import com.github.alexthe666.rats.data.loot.RatsLootTables;
import com.github.alexthe666.rats.data.ratlantis.RatlantisAdvancementProvider;
import com.github.alexthe666.rats.data.ratlantis.RatlantisRecipes;
import com.github.alexthe666.rats.data.ratlantis.RatlantisWorldGenerator;
import com.github.alexthe666.rats.data.ratlantis.loot.RatlantisLootTables;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisBlockTags;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisEntityTags;
import com.github.alexthe666.rats.data.ratlantis.tags.RatlantisItemTags;
import com.github.alexthe666.rats.data.tags.RatsBannerPatternTags;
import com.github.alexthe666.rats.data.tags.RatsBiomeTags;
import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.data.tags.RatsItemTags;
import com.github.alexthe666.rats.data.tags.RatsPoiTags;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="rats")
public class RatsDataRegistry {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        RatsDataRegistry.addArmorTrims(helper);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new RatsLangGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsBannerPatternTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsBiomeTags(output, provider, helper));
        RatsBlockTags tags = new RatsBlockTags(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)tags);
        generator.addProvider(event.includeServer(), (DataProvider)new RatsEntityTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsItemTags(output, provider, tags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsPoiTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsAdvancementProvider(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new BiomeModifierGenerator(output, provider));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsLootTables(output));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsLootModifierGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)new RatsRecipes(output));
        Path mainPath = Paths.get("src/main/resources", new String[0]).toAbsolutePath();
        generator.addProvider(event.includeServer(), (DataProvider)new RatsStructureUpdater(new PackOutput(mainPath), helper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.rats.rats"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
        DataGenerator.PackGenerator ratlantisPack = generator.m_253030_(event.includeServer(), "ratlantis");
        ratlantisPack.m_253108_(ratOutput -> new RatlantisAdvancementProvider(ratOutput, provider, helper));
        ratlantisPack.m_253108_(ratOutput -> RatlantisWorldGenerator.addProviders(ratlantisPack, ratOutput, provider, helper));
        TagsProvider ratlantisBlockTags = (TagsProvider)ratlantisPack.m_253108_(ratOutput -> new RatlantisBlockTags(ratOutput, provider, helper));
        ratlantisPack.m_253108_(ratOutput -> new RatlantisEntityTags(ratOutput, provider, helper));
        ratlantisPack.m_253108_(ratOutput -> new RatlantisItemTags(ratOutput, provider, ratlantisBlockTags.m_274426_(), helper));
        ratlantisPack.m_253108_(RatlantisLootTables::new);
        ratlantisPack.m_253108_(RatlantisRecipes::new);
        ratlantisPack.m_253108_(ratOutput -> new PackMetadataGenerator(ratOutput).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.rats.ratlantis"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }

    private static void addArmorTrims(ExistingFileHelper existingFileHelper) {
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.f_265952_) {
            existingFileHelper.trackGenerated(new ResourceLocation("boots_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("chestplate_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("helmet_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("leggings_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
        }
    }
}

