/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.data;

import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.server.block.DutchratBellBlock;
import com.github.alexthe666.rats.server.block.RatAttractorBlock;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModelGenerator
extends BlockStateProvider {
    public BlockModelGenerator(PackOutput output, ExistingFileHelper helper) {
        super(output, "rats", helper);
    }

    protected void registerStatesAndModels() {
        this.builtinEntity((Block)RatsBlockRegistry.AUTO_CURDLER.get(), Objects.requireNonNull(ResourceLocation.m_135820_((String)"minecraft:block/cauldron_side")));
        this.simpleBlock((Block)RatsBlockRegistry.BLOCK_OF_BLUE_CHEESE.get());
        this.simpleBlock((Block)RatsBlockRegistry.BLOCK_OF_NETHER_CHEESE.get());
        this.simpleBlock((Block)RatsBlockRegistry.BLOCK_OF_CHEESE.get());
        this.simpleBlock((Block)RatsBlockRegistry.CHEESE_CAULDRON.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("cauldron_cheese", new ResourceLocation("rats", "block/template_cauldron_with_transforms"))).texture("bottom", new ResourceLocation("block/cauldron_bottom"))).texture("content", this.blockPrefix("block_of_cheese"))).texture("inside", new ResourceLocation("block/cauldron_inner"))).texture("particle", new ResourceLocation("block/cauldron_side"))).texture("side", new ResourceLocation("block/cauldron_side"))).texture("top", new ResourceLocation("block/cauldron_top")));
        this.simpleBlock((Block)RatsBlockRegistry.BLUE_CHEESE_CAULDRON.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("cauldron_blue_cheese", new ResourceLocation("rats", "block/template_cauldron_with_transforms"))).texture("bottom", new ResourceLocation("block/cauldron_bottom"))).texture("content", this.blockPrefix("block_of_blue_cheese"))).texture("inside", new ResourceLocation("block/cauldron_inner"))).texture("particle", new ResourceLocation("block/cauldron_side"))).texture("side", new ResourceLocation("block/cauldron_side"))).texture("top", new ResourceLocation("block/cauldron_top")));
        this.simpleBlock((Block)RatsBlockRegistry.NETHER_CHEESE_CAULDRON.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("cauldron_nether_cheese", new ResourceLocation("rats", "block/template_cauldron_with_transforms"))).texture("bottom", new ResourceLocation("block/cauldron_bottom"))).texture("content", this.blockPrefix("block_of_nether_cheese"))).texture("inside", new ResourceLocation("block/cauldron_inner"))).texture("particle", new ResourceLocation("block/cauldron_side"))).texture("side", new ResourceLocation("block/cauldron_side"))).texture("top", new ResourceLocation("block/cauldron_top")));
        this.simpleBlock((Block)RatsBlockRegistry.MILK_CAULDRON.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("cauldron_milk", new ResourceLocation("rats", "block/template_cauldron_with_transforms"))).texture("bottom", new ResourceLocation("block/cauldron_bottom"))).texture("content", new ResourceLocation("forge", "block/milk_still"))).texture("inside", new ResourceLocation("block/cauldron_inner"))).texture("particle", new ResourceLocation("block/cauldron_side"))).texture("side", new ResourceLocation("block/cauldron_side"))).texture("top", new ResourceLocation("block/cauldron_top")));
        this.simpleBlock((Block)RatsBlockRegistry.COMPRESSED_GARBAGE.get());
        this.simpleBlock((Block)RatsBlockRegistry.CURSED_GARBAGE.get());
        this.simpleBlock((Block)RatsBlockRegistry.DYE_SPONGE.get());
        this.simpleBlock((Block)RatsBlockRegistry.FISH_BARREL.get(), (ModelFile)((BlockModelBuilder)this.models().cube("fish_barrel", new ResourceLocation("block/barrel_bottom"), this.blockPrefix("fish_barrel_top"), new ResourceLocation("block/barrel_side"), new ResourceLocation("block/barrel_side"), new ResourceLocation("block/barrel_side"), new ResourceLocation("block/barrel_side"))).texture("particle", new ResourceLocation("block/barrel_side")));
        ConfiguredModel[] TRASH = new ConfiguredModel[8];
        for (int i = 0; i < TRASH.length; ++i) {
            TRASH[i] = ConfiguredModel.builder().weight(i == 0 ? 10 : 1).modelFile((ModelFile)this.models().cubeAll("garbage_" + i, this.blockPrefix("garbage_" + i))).buildLast();
        }
        this.simpleBlock((Block)RatsBlockRegistry.GARBAGE_PILE.get(), TRASH);
        this.horizontalBlock((Block)RatsBlockRegistry.JACK_O_RATERN.get(), (ModelFile)this.models().orientable("jack_o_ratern", new ResourceLocation("block/pumpkin_side"), this.blockPrefix("jack_o_ratern"), new ResourceLocation("block/pumpkin_top")));
        this.trapdoorBlockWithRenderType((TrapDoorBlock)RatsBlockRegistry.MANHOLE.get(), this.blockPrefix("manhole"), true, "translucent");
        this.simpleBlock((Block)RatsBlockRegistry.MARBLED_CHEESE_RAW.get());
        this.simpleBlock((Block)RatsBlockRegistry.PIED_GARBAGE.get());
        this.simpleBlock((Block)RatsBlockRegistry.PIED_WOOL.get());
        this.simpleBlock((Block)RatsBlockRegistry.PURIFIED_GARBAGE.get());
        this.getVariantBuilder((Block)RatsBlockRegistry.RAT_ATTRACTOR.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_attractor" + ((Boolean)state.m_61143_((Property)RatAttractorBlock.POWERED) != false ? "_active" : "") + ((Boolean)state.m_61143_((Property)RatAttractorBlock.CONNECTED_UP) != false ? "" : "_no_chain")))).build());
        this.cageBlock((Block)RatsBlockRegistry.RAT_CAGE.get());
        this.cageBlock((Block)RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN.get());
        this.cageBlock((Block)RatsBlockRegistry.RAT_CAGE_DECORATED.get());
        this.cageBlock((Block)RatsBlockRegistry.RAT_CAGE_WHEEL.get());
        this.simpleBlock((Block)RatsBlockRegistry.RAT_CRAFTING_TABLE.get(), (ModelFile)((BlockModelBuilder)this.models().cube("rat_crafting_table", this.blockPrefix("block_of_cheese"), this.blockPrefix("rat_crafting_table_top"), this.blockPrefix("rat_crafting_table_side"), this.blockPrefix("rat_crafting_table_side"), this.blockPrefix("rat_crafting_table"), this.blockPrefix("rat_crafting_table"))).texture("particle", this.blockPrefix("rat_crafting_table")));
        this.builtinEntity((Block)RatsBlockRegistry.RAT_HOLE.get(), Objects.requireNonNull(ResourceLocation.m_135820_((String)"minecraft:block/oak_planks")));
        this.simpleBlock((Block)RatsBlockRegistry.RAT_QUARRY.get(), (ModelFile)((BlockModelBuilder)this.models().cube("rat_quarry", this.blockPrefix("rat_quarry_bottom"), this.blockPrefix("rat_quarry_top"), this.blockPrefix("rat_quarry_side"), this.blockPrefix("rat_quarry_side"), this.blockPrefix("rat_quarry_side"), this.blockPrefix("rat_quarry_side"))).texture("particle", this.blockPrefix("rat_quarry_side")));
        this.simpleBlock((Block)RatsBlockRegistry.RAT_QUARRY_PLATFORM.get(), (ModelFile)this.models().getExistingFile(this.blockPrefix("rat_quarry_platform")));
        this.simpleBlock((Block)RatsBlockRegistry.RAT_TRAP.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("block/oak_planks")));
        this.directionalBlock((Block)RatsBlockRegistry.RAT_UPGRADE_BLOCK.get(), (ModelFile)this.models().cubeAll("rat_upgrade_block", new ResourceLocation("rats", "block/rat_upgrade_block")));
        this.simpleBlock((Block)RatsBlockRegistry.TRASH_CAN.get(), (ModelFile)this.models().cubeAll("trash_can", new ResourceLocation("block/cauldron_side")));
        this.simpleBlock((Block)RatsBlockRegistry.UPGRADE_COMBINER.get(), (ModelFile)this.models().getExistingFile(this.blockPrefix("upgrade_combiner")));
        this.simpleBlock((Block)RatsBlockRegistry.UPGRADE_SEPARATOR.get(), (ModelFile)this.models().getExistingFile(this.blockPrefix("upgrade_separator")));
        this.simpleBlock((Block)RatlantisBlockRegistry.AIR_RAID_SIREN.get(), (ModelFile)this.models().getExistingFile(this.blockPrefix("air_raid_siren")));
        this.simpleBlock((Block)RatlantisBlockRegistry.BLACK_MARBLED_CHEESE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.BRAIN_BLOCK.get(), (ModelFile)((BlockModelBuilder)this.models().cube("brain_block", this.blockPrefix("brain_bottom"), this.blockPrefix("brain_top"), this.blockPrefix("brain_front"), this.blockPrefix("brain_back"), this.blockPrefix("brain_side"), this.blockPrefix("brain_side"))).texture("particle", this.blockPrefix("brain_side")));
        this.simpleBlock((Block)RatlantisBlockRegistry.CHEESE_ORE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.CHUNKY_CHEESE_TOKEN.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll("chunky_cheese_token", this.itemPrefix("chunky_cheese_token"))).renderType(new ResourceLocation("cutout")));
        this.horizontalBlock((Block)RatlantisBlockRegistry.COMPRESSED_RAT.get(), (ModelFile)((BlockModelBuilder)this.models().cube("compressed_rat", this.blockPrefix("compressed_rat_top"), this.blockPrefix("compressed_rat_top"), this.blockPrefix("compressed_rat_front"), this.blockPrefix("compressed_rat_back"), this.blockPrefix("compressed_rat_other_side"), this.blockPrefix("compressed_rat_side"))).texture("particle", this.blockPrefix("compressed_rat_side")));
        this.getVariantBuilder((Block)RatlantisBlockRegistry.DUTCHRAT_BELL.get()).forAllStates(state -> {
            BlockModelBuilder type = switch ((BellAttachType)state.m_61143_((Property)DutchratBellBlock.f_49680_)) {
                default -> throw new IncompatibleClassChangeError();
                case BellAttachType.FLOOR -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("dutchrat_bell_floor", new ResourceLocation("block/bell_floor"))).renderType("minecraft:translucent")).texture("particle", this.blockPrefix("pirat_log"))).texture("bar", this.blockPrefix("pirat_log"))).texture("post", this.blockPrefix("pirat_log"));
                case BellAttachType.CEILING -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("dutchrat_bell_ceiling", new ResourceLocation("block/bell_ceiling"))).renderType("minecraft:translucent")).texture("particle", this.blockPrefix("pirat_log"))).texture("bar", this.blockPrefix("pirat_log"));
                case BellAttachType.SINGLE_WALL -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("dutchrat_bell_wall", new ResourceLocation("block/bell_wall"))).renderType("minecraft:translucent")).texture("particle", this.blockPrefix("pirat_log"))).texture("bar", this.blockPrefix("pirat_log"));
                case BellAttachType.DOUBLE_WALL -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("dutchrat_bell_between_walls", new ResourceLocation("block/bell_between_walls"))).renderType("minecraft:translucent")).texture("particle", this.blockPrefix("pirat_log"))).texture("bar", this.blockPrefix("pirat_log"));
            };
            return ConfiguredModel.builder().modelFile((ModelFile)type).rotationY((int)((Direction)state.m_61143_((Property)DutchratBellBlock.f_49679_)).m_122435_() + (state.m_61143_((Property)DutchratBellBlock.f_49680_) == BellAttachType.FLOOR ? 0 : 90)).build();
        });
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK.get());
        this.stairsBlock((StairBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_STAIRS.get(), this.blockPrefix("marbled_cheese_brick"));
        this.slabBlock((SlabBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_SLAB.get(), this.blockPrefix("marbled_cheese_brick"), this.blockPrefix("marbled_cheese_brick"));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CHISELED.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED.get());
        this.stairsBlock((StairBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_STAIRS.get(), this.blockPrefix("marbled_cheese_brick_cracked"));
        this.slabBlock((SlabBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED_SLAB.get(), this.blockPrefix("marbled_cheese_brick_cracked"), this.blockPrefix("marbled_cheese_brick_cracked"));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY.get());
        this.stairsBlock((StairBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_STAIRS.get(), this.blockPrefix("marbled_cheese_brick_mossy"));
        this.slabBlock((SlabBlock)RatlantisBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY_SLAB.get(), this.blockPrefix("marbled_cheese_brick_mossy"), this.blockPrefix("marbled_cheese_brick_mossy"));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_CHISELED.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_DIRT.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("marbled_cheese_dirt", this.blockPrefix("overlay_block"))).texture("particle", new ResourceLocation("block/dirt"))).texture("tex", new ResourceLocation("block/dirt"))).texture("overlay", this.blockPrefix("marbled_cheese_overlay")));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GRASS.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("marbled_cheese_grass", this.blockPrefix("grass_overlay_double"))).texture("particle", new ResourceLocation("block/dirt"))).texture("side", new ResourceLocation("block/grass_block_side"))).texture("bottom", new ResourceLocation("block/dirt"))).texture("top", new ResourceLocation("block/grass_block_top"))).texture("overlay", new ResourceLocation("block/grass_block_side_overlay"))).texture("overlay2", this.blockPrefix("marbled_cheese_overlay")));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_PILLAR.get(), (ModelFile)this.models().cubeColumn("marbled_cheese_pillar", this.blockPrefix("marbled_cheese_pillar"), this.blockPrefix("marbled_cheese_pillar_top")));
        this.horizontalBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get(), (ModelFile)this.models().getExistingFile(this.blockPrefix("marbled_cheese_rat_head")));
        this.stairsBlock((StairBlock)RatlantisBlockRegistry.MARBLED_CHEESE_STAIRS.get(), this.blockPrefix("marbled_cheese"));
        this.slabBlock((SlabBlock)RatlantisBlockRegistry.MARBLED_CHEESE_SLAB.get(), this.blockPrefix("marbled_cheese"), this.blockPrefix("marbled_cheese"));
        this.simpleBlock((Block)RatlantisBlockRegistry.MARBLED_CHEESE_TILE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.ORATCHALCUM_BLOCK.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.ORATCHALCUM_ORE.get());
        this.buttonBlockTranslucent((ButtonBlock)RatlantisBlockRegistry.PIRAT_BUTTON.get(), this.blockPrefix("pirat_planks"));
        this.doorBlockWithRenderType((DoorBlock)RatlantisBlockRegistry.PIRAT_DOOR.get(), this.blockPrefix("pirat_door_bottom"), this.blockPrefix("pirat_door_top"), "minecraft:translucent");
        this.fenceBlockWithRenderType((FenceBlock)RatlantisBlockRegistry.PIRAT_FENCE.get(), this.blockPrefix("pirat_planks"), "minecraft:translucent");
        this.fenceGateBlockWithRenderType((FenceGateBlock)RatlantisBlockRegistry.PIRAT_FENCE_GATE.get(), this.blockPrefix("pirat_planks"), "minecraft:translucent");
        this.builtinEntity((Block)RatlantisBlockRegistry.PIRAT_HANGING_SIGN.get(), this.blockPrefix("pirat_planks"));
        this.simpleBlockTranslucent((Block)RatlantisBlockRegistry.PIRAT_LEAVES.get());
        this.logBlockWithRenderType((RotatedPillarBlock)RatlantisBlockRegistry.PIRAT_LOG.get(), "minecraft:translucent");
        this.simpleBlockTranslucent((Block)RatlantisBlockRegistry.PIRAT_PLANKS.get());
        this.pressurePlateBlockTranslucent((PressurePlateBlock)RatlantisBlockRegistry.PIRAT_PRESSURE_PLATE.get(), this.blockPrefix("pirat_planks"));
        this.simpleBlock((Block)RatlantisBlockRegistry.PIRAT_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().cross("pirat_sapling", this.blockPrefix("pirat_sapling"))).renderType(new ResourceLocation("tripwire")));
        this.simpleBlock((Block)RatlantisBlockRegistry.POTTED_PIRAT_SAPLING.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RatlantisBlockRegistry.POTTED_PIRAT_SAPLING.getId().m_135815_(), "block/flower_pot_cross")).renderType(new ResourceLocation("tripwire"))).texture("plant", this.blockTexture((Block)RatlantisBlockRegistry.PIRAT_SAPLING.get())));
        this.builtinEntity((Block)RatlantisBlockRegistry.PIRAT_SIGN.get(), this.blockPrefix("pirat_planks"));
        this.slabBlockTranslucent((SlabBlock)RatlantisBlockRegistry.PIRAT_SLAB.get(), this.blockPrefix("pirat_planks"), this.blockPrefix("pirat_planks"));
        this.stairsBlockWithRenderType((StairBlock)RatlantisBlockRegistry.PIRAT_STAIRS.get(), this.blockPrefix("pirat_planks"), "minecraft:translucent");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)RatlantisBlockRegistry.PIRAT_TRAPDOOR.get(), this.blockPrefix("pirat_trapdoor"), true, "minecraft:translucent");
        this.builtinEntity((Block)RatlantisBlockRegistry.PIRAT_WALL_SIGN.get(), this.blockPrefix("pirat_planks"));
        this.builtinEntity((Block)RatlantisBlockRegistry.PIRAT_WALL_HANGING_SIGN.get(), this.blockPrefix("pirat_planks"));
        this.axisBlockWithRenderType((RotatedPillarBlock)RatlantisBlockRegistry.PIRAT_WOOD.get(), this.blockPrefix("pirat_log"), this.blockPrefix("pirat_log"), "minecraft:translucent");
        this.simpleBlock((Block)RatlantisBlockRegistry.RATGLOVE_FLOWER.get(), (ModelFile)((BlockModelBuilder)this.models().cross("ratglove_flower", this.blockPrefix("ratglove_flower"))).renderType(new ResourceLocation("cutout")));
        this.simpleBlock((Block)RatlantisBlockRegistry.POTTED_RATGLOVE_FLOWER.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RatlantisBlockRegistry.POTTED_RATGLOVE_FLOWER.getId().m_135815_(), "block/flower_pot_cross")).renderType(new ResourceLocation("cutout"))).texture("plant", this.blockTexture((Block)RatlantisBlockRegistry.RATGLOVE_FLOWER.get())));
        this.simpleBlock((Block)RatlantisBlockRegistry.RATLANTEAN_GEM_ORE.get());
        this.simpleBlock((Block)RatlantisBlockRegistry.RATLANTIS_PORTAL.get(), (ModelFile)this.models().cubeAll("ratlantis_portal", new ResourceLocation("block/yellow_stained_glass")));
        this.simpleBlock((Block)RatlantisBlockRegistry.RATLANTIS_REACTOR.get());
        this.directionalBlock((Block)RatlantisBlockRegistry.RATLANTIS_UPGRADE_BLOCK.get(), (ModelFile)this.models().cubeAll("ratlantis_upgrade_block", new ResourceLocation("rats", "block/ratlantis_upgrade_block")));
        this.logBlock((RotatedPillarBlock)RatlantisBlockRegistry.STRIPPED_PIRAT_LOG.get());
        this.axisBlock((RotatedPillarBlock)RatlantisBlockRegistry.STRIPPED_PIRAT_WOOD.get(), this.blockPrefix("stripped_pirat_log"), this.blockPrefix("stripped_pirat_log"));
    }

    public void simpleBlockTranslucent(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), this.blockTexture(block))).renderType("minecraft:translucent"));
    }

    public void slabBlockTranslucent(SlabBlock block, ResourceLocation doubleslab, ResourceLocation texture) {
        this.slabBlock(block, (ModelFile)((BlockModelBuilder)this.models().slab(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), texture, texture, texture)).renderType("minecraft:translucent"), (ModelFile)((BlockModelBuilder)this.models().slabTop(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_top", texture, texture, texture)).renderType("minecraft:translucent"), (ModelFile)this.models().getExistingFile(doubleslab));
    }

    public void pressurePlateBlockTranslucent(PressurePlateBlock block, ResourceLocation texture) {
        ModelBuilder pressurePlate = ((BlockModelBuilder)this.models().pressurePlate(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), texture)).renderType("minecraft:translucent");
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)this.models().pressurePlateDown(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_down", texture)).renderType("minecraft:translucent");
        this.pressurePlateBlock(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
    }

    public void buttonBlockTranslucent(ButtonBlock block, ResourceLocation texture) {
        ModelBuilder button = ((BlockModelBuilder)this.models().button(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), texture)).renderType("minecraft:translucent");
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().buttonPressed(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_pressed", texture)).renderType("minecraft:translucent");
        this.buttonBlock(block, (ModelFile)button, (ModelFile)buttonPressed);
    }

    private void builtinEntity(Block b, ResourceLocation particle) {
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particle));
    }

    private void cageBlock(Block block) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_top_tube"))).uvLock(false).addModel()).condition((Property)RatCageBlock.UP, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom_tube"))).uvLock(false).addModel()).condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars_tube"))).uvLock(false).rotationY(180).addModel()).condition((Property)RatCageBlock.SOUTH, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars_tube"))).uvLock(false).rotationY(90).addModel()).condition((Property)RatCageBlock.EAST, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars_tube"))).uvLock(false).rotationY(270).addModel()).condition((Property)RatCageBlock.WEST, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars_tube"))).uvLock(false).addModel()).condition((Property)RatCageBlock.NORTH, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_top"))).uvLock(false).addModel()).condition((Property)RatCageBlock.UP, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom"))).uvLock(false).addModel()).condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars"))).uvLock(false).rotationY(180).addModel()).condition((Property)RatCageBlock.SOUTH, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars"))).uvLock(false).rotationY(90).addModel()).condition((Property)RatCageBlock.EAST, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars"))).uvLock(false).rotationY(270).addModel()).condition((Property)RatCageBlock.WEST, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bars"))).uvLock(false).addModel()).condition((Property)RatCageBlock.NORTH, (Comparable[])new Integer[]{0}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom_right"))).uvLock(false).addModel()).nestedGroup().condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{0, 2}).condition((Property)RatCageBlock.EAST, (Comparable[])new Integer[]{0, 2}).end().end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom_left"))).uvLock(false).addModel()).nestedGroup().condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{0, 2}).condition((Property)RatCageBlock.WEST, (Comparable[])new Integer[]{0, 2}).end().end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom_left"))).uvLock(false).rotationY(90).addModel()).nestedGroup().condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{0, 2}).condition((Property)RatCageBlock.NORTH, (Comparable[])new Integer[]{0, 2}).end().end().part().modelFile((ModelFile)this.models().getExistingFile(this.blockPrefix("rat_cage_bottom_right"))).uvLock(false).rotationY(90).addModel()).nestedGroup().condition((Property)RatCageBlock.DOWN, (Comparable[])new Integer[]{0, 2}).condition((Property)RatCageBlock.SOUTH, (Comparable[])new Integer[]{0, 2}).end().end();
    }

    private ResourceLocation blockPrefix(String name) {
        return new ResourceLocation("rats", "block/" + name);
    }

    private ResourceLocation itemPrefix(String name) {
        return new ResourceLocation("rats", "item/" + name);
    }
}

