/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityRenderingUtil {
    private static final Map<ResourceLocation, Entity> ENTITY_MAP = new HashMap<ResourceLocation, Entity>();
    private static final Set<ResourceLocation> IGNORED_ENTITIES = new HashSet<ResourceLocation>();

    @Nullable
    public static LivingEntity fetchEntity(@Nullable ResourceLocation entityName, @Nullable Level level) {
        EntityType type;
        if (entityName != null && level != null && !IGNORED_ENTITIES.contains(entityName) && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityName)) != null) {
            Object entity = type == EntityType.f_20532_ ? Minecraft.m_91087_().f_91074_ : ENTITY_MAP.computeIfAbsent(entityName, t -> ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(t)).m_20615_(level));
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return living;
            }
            EntityRenderingUtil.addEntityToBlacklist(entityName);
        }
        return null;
    }

    public static int getAdjustedMobScale(ResourceLocation entityName) {
        LivingEntity entity = EntityRenderingUtil.fetchEntity(entityName, (Level)Minecraft.m_91087_().f_91073_);
        if (entity != null) {
            int scale = 35;
            float height = entity.m_20206_();
            float width = entity.m_20205_();
            if (height > 2.0f || width > 2.0f) {
                scale = (int)(64.0f / Math.max(height, width));
            }
            return scale;
        }
        return 0;
    }

    public static void addEntityToBlacklist(ResourceLocation entityName) {
        IGNORED_ENTITIES.add(entityName);
        ENTITY_MAP.remove(entityName);
    }

    public static void drawEntityOnScreen(GuiGraphics graphics, int posX, int posY, int scale, float mouseX, float mouseY, @Nullable LivingEntity entity, boolean rotating) {
        if (entity != null) {
            float rotate = (Minecraft.m_91087_().getPartialTick() + (float)Minecraft.m_91087_().f_91074_.f_19797_) * 2.0f;
            float f = (float)Math.atan(mouseX / 40.0f);
            float f1 = (float)Math.atan(mouseY / 40.0f);
            Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
            Quaternionf quaternion1 = Axis.f_252529_.m_252977_(f1 * 20.0f);
            Quaternionf quaternion2 = Axis.f_252436_.m_252977_(rotate);
            quaternion.mul((Quaternionfc)quaternion1);
            float f2 = entity.f_20883_;
            float f3 = entity.m_146908_();
            float f4 = entity.m_146909_();
            float f5 = entity.f_20886_;
            float f6 = entity.f_20885_;
            entity.f_20883_ = 180.0f + f * 20.0f;
            entity.m_146922_(180.0f + f * 40.0f);
            entity.m_146926_(-f1 * 20.0f);
            entity.f_20885_ = entity.m_146908_();
            entity.f_20886_ = entity.m_146908_();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)posX, (double)posY, 50.0);
            graphics.m_280168_().m_252931_(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
            graphics.m_280168_().m_252781_(quaternion);
            if (rotating) {
                graphics.m_280168_().m_252781_(quaternion2);
            }
            Lighting.m_166384_();
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            quaternion1.conjugate();
            dispatcher.m_252923_(quaternion1);
            dispatcher.m_114468_(false);
            RenderSystem.runAsFancy(() -> dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0));
            graphics.m_280262_();
            dispatcher.m_114468_(true);
            graphics.m_280168_().m_85849_();
            Lighting.m_84931_();
            entity.f_20883_ = f2;
            entity.m_146922_(f3);
            entity.m_146926_(f4);
            entity.f_20886_ = f5;
            entity.f_20885_ = f6;
        }
    }
}

