/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.events.ModClientEvents;
import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.client.model.entity.PinkieModel;
import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.client.render.entity.AbstractRatRenderer;
import com.github.alexthe666.rats.client.render.entity.layer.TamedRatEyesLayer;
import com.github.alexthe666.rats.client.render.entity.layer.TamedRatOverlayLayer;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesTextureUpgrade;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;

public class TamedRatRenderer
extends AbstractRatRenderer<TamedRat, AbstractRatModel<TamedRat>> {
    private static final RatModel<TamedRat> RAT_MODEL = new RatModel();
    private static final PinkieModel<TamedRat> PINKIE_MODEL = new PinkieModel();
    private static final ResourceLocation PINKIE_TEXTURE = new ResourceLocation("rats", "textures/entity/rat/baby.png");
    private static final String[] FISHING_PROGRESS = new String[]{".", "..", "..."};
    private static final ImmutableMap<String, ResourceLocation> SPECIAL_SKINS = ImmutableMap.builder().put((Object)"brick", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/brick.png")).put((Object)"bugraak", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/bugraak.png")).put((Object)"dino", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/dino.png")).put((Object)"friar", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/friar.png")).put((Object)"gizmo", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/gizmo.png")).put((Object)"julian", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/julian.png")).put((Object)"lil_cheese", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/lil_cheese.png")).put((Object)"ratatla", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/ratatla.png")).put((Object)"riddler", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/riddler.png")).put((Object)"sharva", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/sharva.png")).put((Object)"shizuka", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/shizuka.png")).put((Object)"skrat", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/skrat.png")).put((Object)"splinter", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/splinter.png")).put((Object)"ultrakill", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/ultrakill.png")).put((Object)"zura", (Object)new ResourceLocation("rats", "textures/entity/rat/patreon_skins/zura.png")).build();

    public TamedRatRenderer(EntityRendererProvider.Context context) {
        super(context, new RatModel());
        this.m_115326_(new TamedRatOverlayLayer((RenderLayerParent<TamedRat, AbstractRatModel<TamedRat>>)this));
        this.m_115326_(new TamedRatEyesLayer((RenderLayerParent<TamedRat, AbstractRatModel<TamedRat>>)this));
    }

    protected boolean shouldShowName(TamedRat entity) {
        return ModClientEvents.shouldRenderNameplates() && super.m_6512_((Mob)entity);
    }

    public void render(TamedRat entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        this.f_115290_ = entity.m_6162_() ? PINKIE_MODEL : RAT_MODEL;
        super.m_7392_((Mob)entity, entityYaw, partialTicks, stack, buffer, light);
        if (ModClientEvents.shouldRenderNameplates() && entity.crafting && RatUpgradeUtils.hasUpgrade(entity, (Item)RatsItemRegistry.RAT_UPGRADE_FISHERMAN.get())) {
            boolean hasName = this.shouldShowName(entity);
            stack.m_85836_();
            stack.m_252880_(0.0f, hasName ? 1.3f : 1.05f, 0.0f);
            stack.m_252781_(this.f_114476_.m_253208_());
            stack.m_85841_(0.25f, 0.25f, 0.25f);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks) / 5.0f)) * 20.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)Items.f_42523_), ItemDisplayContext.GUI, light, OverlayTexture.f_118083_, stack, buffer, null, entity.m_19879_());
            stack.m_85849_();
            stack.m_85836_();
            stack.m_252880_(0.0f, entity.m_20206_() + 0.5f, 0.0f);
            stack.m_252781_(this.f_114476_.m_253208_());
            stack.m_85841_(-0.025f, -0.025f, 0.025f);
            String dots = FISHING_PROGRESS[(int)(Util.m_137550_() / 300L % (long)FISHING_PROGRESS.length)];
            this.m_114481_().m_272078_(dots, (float)(-this.m_114481_().m_92895_(dots) / 2), hasName ? -10.0f : 0.0f, 0xFFFFFF, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, this.m_114481_().m_92718_());
            stack.m_85849_();
        }
    }

    protected void renderAdditionalInfo(TamedRat entity, PoseStack stack, MultiBufferSource source, int light) {
        double d0 = this.f_114476_.m_114471_((Entity)entity);
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)entity, (double)d0)) {
            float f = entity.m_278726_();
            stack.m_85836_();
            stack.m_252880_(0.0f, f, 0.0f);
            stack.m_252781_(this.f_114476_.m_253208_());
            stack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = stack.m_85850_().m_252922_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font font = this.m_114481_();
            MutableComponent rf = Component.m_237113_((String)("RF: " + entity.getHeldRF()));
            float f2 = -font.m_92852_((FormattedText)rf) / 2;
            font.m_272077_((Component)rf, f2, -20.0f, 0x20FFFFFF, false, matrix4f, source, Font.DisplayMode.NORMAL, j, light);
            MutableComponent fluid = Component.m_237113_((String)("Fluid: " + entity.transportingFluid.getAmount()));
            f2 = -font.m_92852_((FormattedText)rf) / 2;
            font.m_272077_((Component)fluid, f2, -10.0f, 0x20FFFFFF, false, matrix4f, source, Font.DisplayMode.NORMAL, j, light);
            MutableComponent pickupSides = Component.m_237113_((String)("Deposit: " + entity.depositFacing.m_122433_() + ", Pickup: " + entity.pickupFacing.m_122433_()));
            f2 = -font.m_92852_((FormattedText)rf) / 2;
            font.m_272077_((Component)pickupSides, f2, 0.0f, 0x20FFFFFF, false, matrix4f, source, Font.DisplayMode.NORMAL, j, light);
            stack.m_85849_();
        }
    }

    @Override
    public ResourceLocation getTextureLocation(TamedRat entity) {
        String name;
        if (entity.m_6162_()) {
            return PINKIE_TEXTURE;
        }
        AtomicReference<Object> upgradeTex = new AtomicReference<Object>(null);
        RatUpgradeUtils.forEachUpgrade(entity, item -> item instanceof ChangesTextureUpgrade, (stack, slot) -> {
            if (entity.isSlotVisible((EquipmentSlot)slot)) {
                upgradeTex.set(((ChangesTextureUpgrade)stack.m_41720_()).getTexture().toString());
            }
        });
        if (upgradeTex.get() != null) {
            return new ResourceLocation((String)upgradeTex.get());
        }
        if (entity.m_8077_() && SPECIAL_SKINS.containsKey((Object)(name = entity.m_7770_().getString().toLowerCase(Locale.ROOT)))) {
            return Objects.requireNonNull((ResourceLocation)SPECIAL_SKINS.get((Object)name));
        }
        return super.getTextureLocation(entity);
    }
}

