/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.entity.monster.boss.RatlanteanAutomaton;
import com.github.alexthe666.rats.server.entity.mount.RatAutomatonMount;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class RatlanteanAutomatonModel<T extends Mob>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox body;
    public final AdvancedModelBox armLeft1;
    public final AdvancedModelBox armRight1;
    public final AdvancedModelBox thruster;
    public final AdvancedModelBox upperbody;
    public final AdvancedModelBox ear1;
    public final AdvancedModelBox ear2;
    public final AdvancedModelBox armLeft2;
    public final AdvancedModelBox drillArm1;
    public final AdvancedModelBox drillArm2;
    public final AdvancedModelBox drilArm3;
    public final AdvancedModelBox blade;
    public final AdvancedModelBox armRight2;
    public final AdvancedModelBox cannon;
    public final AdvancedModelBox headBase;
    public final AdvancedModelBox snout;
    public final AdvancedModelBox nose;
    public final AdvancedModelBox riderPlate;
    public final AdvancedModelBox riderPlatePivot;
    private final ModelAnimator animator;
    private final boolean mount;

    public RatlanteanAutomatonModel(boolean mount) {
        this.mount = mount;
        this.texWidth = 128;
        this.texHeight = 96;
        this.upperbody = new AdvancedModelBox((AdvancedEntityModel)this, 0, 34);
        this.upperbody.setRotationPoint(0.0f, -5.0f, 0.0f);
        this.upperbody.addBox(-11.0f, -5.0f, -6.0f, 22.0f, 10.0f, 12.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body.addBox(-6.0f, -3.5f, -5.0f, 12.0f, 16.0f, 10.0f, 0.0f);
        this.ear2 = new AdvancedModelBox((AdvancedEntityModel)this, 34, 0);
        this.ear2.mirror = true;
        this.ear2.setRotationPoint(-7.0f, -3.0f, 5.0f);
        this.ear2.addBox(-7.0f, -6.0f, 0.0f, 7.0f, 7.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.ear2, -0.2617994f, 0.9075712f, 0.0f);
        this.drilArm3 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.drilArm3.setRotationPoint(0.0f, 11.0f, 0.0f);
        this.drilArm3.addBox(-0.5f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.drilArm3, 0.0f, 0.0f, -0.13962634f);
        this.cannon = new AdvancedModelBox((AdvancedEntityModel)this, 68, 47);
        this.cannon.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.cannon.addBox(-3.0f, 0.0f, -4.0f, 6.0f, 14.0f, 7.0f, 0.0f);
        this.setRotateAngle(this.cannon, -0.34906584f, -0.13321877f, -0.31359068f);
        this.armRight1 = new AdvancedModelBox((AdvancedEntityModel)this, 82, 0);
        this.armRight1.mirror = true;
        this.armRight1.setRotationPoint(-17.0f, -4.0f, 0.0f);
        this.armRight1.addBox(-3.0f, -4.0f, -2.5f, 5.0f, 18.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.armRight1, -0.05235988f, 0.2617994f, 0.2268928f);
        this.thruster = new AdvancedModelBox((AdvancedEntityModel)this, 36, 18);
        this.thruster.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.thruster.addBox(-5.0f, -1.0f, -4.0f, 10.0f, 8.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.thruster, 0.34906584f, 0.0f, 0.0f);
        this.drillArm2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 26);
        this.drillArm2.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.drillArm2.addBox(-1.0f, 0.0f, -1.0f, 1.0f, 12.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.drillArm2, 0.0f, 0.0f, 0.13962634f);
        this.armLeft2 = new AdvancedModelBox((AdvancedEntityModel)this, 107, 26);
        this.armLeft2.setRotationPoint(0.0f, 18.0f, -2.0f);
        this.armLeft2.addBox(-1.5f, -1.0f, -2.5f, 3.0f, 18.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.armLeft2, -1.0471976f, -0.08726646f, 0.2268928f);
        this.drillArm1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 26);
        this.drillArm1.setRotationPoint(0.0f, 17.0f, 0.0f);
        this.drillArm1.addBox(0.0f, 0.0f, -1.0f, 1.0f, 12.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.drillArm1, 0.0f, 0.0f, -0.13962634f);
        this.armLeft1 = new AdvancedModelBox((AdvancedEntityModel)this, 82, 0);
        this.armLeft1.setRotationPoint(17.0f, -4.0f, 0.0f);
        this.armLeft1.addBox(-2.0f, -4.0f, -2.5f, 5.0f, 18.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.armLeft1, -0.05235988f, -0.2617994f, -0.2268928f);
        this.blade = new AdvancedModelBox((AdvancedEntityModel)this, 0, 42);
        this.blade.setRotationPoint(1.5f, 0.0f, 0.0f);
        this.blade.addBox(0.0f, -7.0f, -7.0f, 0.0f, 14.0f, 14.0f, 0.0f);
        this.setRotateAngle(this.blade, 0.7853982f, 0.0f, 0.0f);
        this.ear1 = new AdvancedModelBox((AdvancedEntityModel)this, 34, 0);
        this.ear1.setRotationPoint(7.0f, -3.0f, 5.0f);
        this.ear1.addBox(0.0f, -6.0f, 0.0f, 7.0f, 7.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.ear1, -0.2617994f, -0.9075712f, 0.0f);
        this.armRight2 = new AdvancedModelBox((AdvancedEntityModel)this, 107, 26);
        this.armRight2.setRotationPoint(0.0f, 18.0f, -2.0f);
        this.armRight2.addBox(-1.5f, -1.0f, -2.5f, 3.0f, 18.0f, 5.0f, 0.0f);
        this.setRotateAngle(this.armRight2, -1.0471976f, 0.08726646f, -0.2268928f);
        this.riderPlatePivot = new AdvancedModelBox((AdvancedEntityModel)this, 34, 0);
        this.riderPlatePivot.setRotationPoint(0.0f, -15.0f, 0.0f);
        this.riderPlate = new AdvancedModelBox((AdvancedEntityModel)this, 34, 0);
        this.riderPlate.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.riderPlate.addBox(-3.5f, -3.5f, 0.0f, 7.0f, 7.0f, 1.0f, 0.3f);
        this.setRotateAngle(this.riderPlate, (float)Math.toRadians(90.0), 0.0f, 0.0f);
        this.headBase = new AdvancedModelBox((AdvancedEntityModel)this, 44, 0);
        this.headBase.setRotationPoint(0.0f, -15.0f, 0.0f);
        this.headBase.addBox(-4.0f, -6.0f, -7.0f, 8.0f, 7.0f, 11.0f, 0.0f);
        this.setRotateAngle(this.headBase, 0.22759093f, 0.0f, 0.0f);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this, 64, 18);
        this.nose.setRotationPoint(0.0f, -3.0f, -3.0f);
        this.nose.addBox(-1.5f, -2.0f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.nose, 0.17453292f, 0.0f, 0.0f);
        this.snout = new AdvancedModelBox((AdvancedEntityModel)this, 72, 23);
        this.snout.setRotationPoint(0.0f, 0.0f, -8.0f);
        this.snout.addBox(-3.0f, -4.0f, -5.0f, 6.0f, 5.0f, 6.0f, 0.0f);
        this.headBase.addChild((BasicModelPart)this.ear2);
        this.snout.addChild((BasicModelPart)this.nose);
        this.headBase.addChild((BasicModelPart)this.ear1);
        this.headBase.addChild((BasicModelPart)this.snout);
        this.body.addChild((BasicModelPart)this.upperbody);
        this.drillArm2.addChild((BasicModelPart)this.drilArm3);
        this.armRight2.addChild((BasicModelPart)this.cannon);
        this.body.addChild((BasicModelPart)this.thruster);
        this.armLeft2.addChild((BasicModelPart)this.drillArm2);
        this.armLeft1.addChild((BasicModelPart)this.armLeft2);
        this.armLeft2.addChild((BasicModelPart)this.drillArm1);
        this.drilArm3.addChild((BasicModelPart)this.blade);
        this.armRight1.addChild((BasicModelPart)this.armRight2);
        this.riderPlatePivot.addChild((BasicModelPart)this.ear2);
        this.riderPlatePivot.addChild((BasicModelPart)this.ear1);
        this.riderPlatePivot.addChild((BasicModelPart)this.riderPlate);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body, (Object)this.riderPlatePivot, (Object)this.headBase, (Object)this.armLeft1, (Object)this.armRight1);
    }

    public void animate(IAnimatedEntity entity) {
        this.resetToDefaultPose();
        this.animator.update(entity);
        this.animator.setAnimation(this.mount ? RatAutomatonMount.ANIMATION_MELEE : RatlanteanAutomaton.ANIMATION_MELEE);
        this.animator.startKeyframe(5);
        this.rotateFrom(this.body, 0.0f, -20.0f, 0.0f);
        this.rotateFrom(this.armLeft1, -60.0f, -20.0f, 10.0f);
        this.rotateFrom(this.armLeft2, -100.0f, -5.0f, 30.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.rotateFrom(this.armLeft1, 0.0f, 40.0f, -10.0f);
        this.rotateFrom(this.armLeft2, -30.0f, 40.0f, -30.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(this.mount ? RatAutomatonMount.ANIMATION_RANGED : RatlanteanAutomaton.ANIMATION_RANGED);
        this.animator.startKeyframe(5);
        this.animator.move(this.armRight2, -1.0f, 0.0f, 2.5f);
        this.rotateFrom(this.armRight1, -90.0f, -10.0f, 10.0f);
        this.rotateFrom(this.armRight2, 10.0f, 0.0f, 0.0f);
        this.rotateFrom(this.cannon, 0.0f, 10.0f, 5.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(5);
        this.animator.endKeyframe();
    }

    public void renderHead(PoseStack stack, VertexConsumer buffer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.headBase.render(stack, buffer, light, overlay, red, green, blue, alpha);
    }

    public void setTERotationAngles(float tickCount) {
        this.resetToDefaultPose();
        this.ear1.rotationPointZ = 3.0f;
        this.ear2.rotationPointZ = 3.0f;
        float idleSpeed = 0.1f;
        float idleDegree = 0.7f;
        this.bob(this.headBase, idleSpeed, idleDegree, 0.0f, 0.0f, false, tickCount, 1.0f);
        this.bob(this.ear2, idleSpeed, idleDegree, -1.0f, 0.0f, false, tickCount, 1.0f);
        this.bob(this.ear1, idleSpeed, idleDegree, -1.0f, 0.0f, false, tickCount, 1.0f);
        this.walk(this.headBase, idleSpeed * 0.4f, idleDegree * 0.1f, false, 0.0f, 0.0f, tickCount, 1.0f);
        this.swing(this.ear1, idleSpeed * 0.4f, idleDegree * 0.4f, false, 0.0f, 0.0f, tickCount, 1.0f);
        this.swing(this.ear2, idleSpeed * 0.4f, idleDegree * 0.4f, true, 0.0f, 0.0f, tickCount, 1.0f);
    }

    public void setupAnim(T rat, float f, float f1, float f2, float f3, float f4) {
        this.animate((IAnimatedEntity)rat);
        this.blade.showModel = false;
        this.blade.rotateAngleX = (float)Math.toRadians(Mth.m_14177_((float)(f2 * 50.0f)));
        float idleSpeed = 0.3f;
        float idleDegree = 0.7f;
        this.bob(this.body, idleSpeed, idleDegree, -1.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.headBase, idleSpeed, idleDegree, 0.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.ear2, idleSpeed, idleDegree, -1.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.ear1, idleSpeed, idleDegree, -1.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.armRight1, idleSpeed, idleDegree, 2.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.armRight2, idleSpeed, idleDegree, 2.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.armLeft1, idleSpeed, idleDegree, 3.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.armLeft2, idleSpeed, idleDegree, 3.0f, 0.0f, false, f2, 1.0f);
        this.bob(this.cannon, idleSpeed, idleDegree, 3.0f, 0.0f, false, f2, 1.0f);
        this.walk(this.headBase, idleSpeed * 0.4f, idleDegree * 0.1f, false, 0.0f, 0.0f, f2, 1.0f);
        this.swing(this.ear1, idleSpeed * 0.4f, idleDegree * 0.4f, false, 0.0f, 0.0f, f2, 1.0f);
        this.swing(this.ear2, idleSpeed * 0.4f, idleDegree * 0.4f, true, 0.0f, 0.0f, f2, 1.0f);
        this.walk(this.armRight1, idleSpeed * 0.4f, idleDegree * 0.1f, false, 0.0f, 0.0f, f2, 1.0f);
        this.walk(this.armRight2, idleSpeed * 0.4f, idleDegree * 0.1f, false, 1.0f, -0.1f, f2, 1.0f);
        this.walk(this.cannon, idleSpeed * 0.4f, idleDegree * -0.2f, false, 1.0f, 0.0f, f2, 1.0f);
        this.walk(this.armLeft1, idleSpeed * 0.4f, idleDegree * 0.1f, false, 0.0f, 0.0f, f2, 1.0f);
        this.walk(this.armLeft2, idleSpeed * 0.4f, idleDegree * 0.1f, false, 1.0f, -0.1f, f2, 1.0f);
        this.walk(this.body, idleSpeed * 0.4f, idleDegree * 0.1f, false, 1.0f, 0.1f, f2, 1.0f);
        this.walk(this.thruster, idleSpeed * 0.4f, idleDegree * 0.2f, false, 1.0f, 0.1f, f2, 1.0f);
        this.faceTarget(f3, f4, 1.0f, new AdvancedModelBox[]{this.headBase});
        this.headBase.showModel = !this.mount;
        this.snout.showModel = !this.mount;
        this.nose.showModel = !this.mount;
        this.riderPlate.showModel = this.mount;
        this.riderPlatePivot.showModel = this.mount;
    }

    public void bob(AdvancedModelBox box, float speed, float degree, float offset, float weight, boolean bounce, float f, float f1) {
        float movementScale = box.getModel().getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale) + offset) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree) + (double)(f1 * weight));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed + offset) * (double)f1 * (double)degree + (double)(f1 * weight)));
        }
        box.rotationPointY += bob;
    }

    public void setRotateAngle(AdvancedModelBox box, float x, float y, float z) {
        box.rotateAngleX = x;
        box.rotateAngleY = y;
        box.rotateAngleZ = z;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.armLeft1, (Object)this.armRight1, (Object)this.thruster, (Object)this.upperbody, (Object)this.ear1, (Object)this.ear2, (Object)this.armLeft2, (Object)this.drillArm1, (Object)this.drillArm2, (Object)this.drilArm3, (Object)this.blade, (Object[])new AdvancedModelBox[]{this.armRight2, this.cannon, this.riderPlate, this.riderPlatePivot, this.headBase, this.nose, this.snout});
    }

    private void rotateFrom(AdvancedModelBox renderer, float degX, float degY, float degZ) {
        this.animator.rotate(renderer, (float)Math.toRadians(degX) - renderer.defaultRotationX, (float)Math.toRadians(degY) - renderer.defaultRotationY, (float)Math.toRadians(degZ) - renderer.defaultRotationZ);
    }
}

