/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.entity.misc.Ratfish;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;

public class RatFishModel<T extends Ratfish>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox head;
    public final AdvancedModelBox snout;
    public final AdvancedModelBox leftEar;
    public final AdvancedModelBox rightEar;
    public final AdvancedModelBox leftEye;
    public final AdvancedModelBox rightEye;
    public final AdvancedModelBox nose;
    public final AdvancedModelBox wisker1;
    public final AdvancedModelBox wisker2;
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox finRight;
    private final AdvancedModelBox finLeft;
    private final AdvancedModelBox finTop;

    public RatFishModel(float scale) {
        this.texWidth = 64;
        this.texHeight = 32;
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this, 32, 26);
        this.nose.setRotationPoint(0.0f, -0.6f, -2.1f);
        this.nose.addBox(-0.5f, -0.3f, -1.0f, 1.0f, 1.0f, 2.0f, 0.0f);
        this.rightEye = new AdvancedModelBox((AdvancedEntityModel)this, 37, 20);
        this.rightEye.setRotationPoint(-2.0f, -0.5f, -1.6f);
        this.rightEye.addBox(-0.5f, -0.7f, -0.5f, 1.0f, 1.0f, 1.0f, scale);
        this.wisker2 = new AdvancedModelBox((AdvancedEntityModel)this, 35, 3);
        this.wisker2.setRotationPoint(-1.0f, 0.0f, -1.0f);
        this.wisker2.addBox(-2.5f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, scale);
        this.wisker1 = new AdvancedModelBox((AdvancedEntityModel)this, 40, 3);
        this.wisker1.setRotationPoint(1.0f, 0.0f, -1.0f);
        this.wisker1.addBox(0.5f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, scale);
        this.leftEye = new AdvancedModelBox((AdvancedEntityModel)this, 37, 20);
        this.leftEye.setRotationPoint(2.0f, -0.5f, -1.6f);
        this.leftEye.addBox(-0.5f, -0.7f, -0.5f, 1.0f, 1.0f, 1.0f, scale);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, 22, 20);
        this.head.setRotationPoint(0.0f, 21.5f, -1.0f);
        this.head.addBox(-2.0f, -1.5f, -2.5f, 4.0f, 3.0f, 3.0f, scale);
        this.setRotateAngle(this.head, 0.18656418f, 0.0f, 0.0f);
        this.snout = new AdvancedModelBox((AdvancedEntityModel)this, 22, 26);
        this.snout.setRotationPoint(0.0f, 0.5f, -2.5f);
        this.snout.addBox(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f, scale);
        this.leftEar = new AdvancedModelBox((AdvancedEntityModel)this, 33, 20);
        this.leftEar.mirror = true;
        this.leftEar.setRotationPoint(1.5f, -0.5f, 0.0f);
        this.leftEar.addBox(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, scale);
        this.setRotateAngle(this.leftEar, 0.0f, -0.7853982f, 0.0f);
        this.rightEar = new AdvancedModelBox((AdvancedEntityModel)this, 33, 20);
        this.rightEar.setRotationPoint(-1.5f, -0.5f, 0.0f);
        this.rightEar.addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, scale);
        this.setRotateAngle(this.rightEar, 0.0f, 0.7853982f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body.addBox(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, scale);
        this.body.setRotationPoint(0.0f, 22.0f, 0.0f);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this, 22, -6);
        this.tail.addBox(0.0f, -1.5f, 0.0f, 0.0f, 6.0f, 6.0f, scale);
        this.tail.setRotationPoint(0.0f, 22.0f, 3.0f);
        this.finRight = new AdvancedModelBox((AdvancedEntityModel)this, 2, 16);
        this.finRight.addBox(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, scale);
        this.finRight.setRotationPoint(-1.0f, 22.5f, 0.0f);
        this.finRight.rotateAngleY = 0.7853982f;
        this.finLeft = new AdvancedModelBox((AdvancedEntityModel)this, 2, 12);
        this.finLeft.addBox(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, scale);
        this.finLeft.setRotationPoint(1.0f, 22.5f, 0.0f);
        this.finLeft.rotateAngleY = -0.7853982f;
        this.finTop = new AdvancedModelBox((AdvancedEntityModel)this, 10, -5);
        this.finTop.addBox(0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 6.0f, scale);
        this.finTop.setRotationPoint(0.0f, 20.5f, -3.0f);
        this.snout.addChild((BasicModelPart)this.nose);
        this.head.addChild((BasicModelPart)this.rightEye);
        this.snout.addChild((BasicModelPart)this.wisker1);
        this.snout.addChild((BasicModelPart)this.wisker2);
        this.head.addChild((BasicModelPart)this.leftEye);
        this.head.addChild((BasicModelPart)this.leftEar);
        this.head.addChild((BasicModelPart)this.rightEar);
        this.head.addChild((BasicModelPart)this.snout);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.tail, (Object)this.finLeft, (Object)this.finRight, (Object)this.finTop);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float speedIdle = 0.75f;
        float degreeIdle = 0.15f;
        float f = 1.0f;
        if (!entity.m_20069_()) {
            f = 1.5f;
        }
        this.tail.rotateAngleY = -f * 0.45f * Mth.m_14031_((float)(0.6f * ageInTicks));
        float ulatingScale = 0.9f + (float)Math.sin(ageInTicks * 0.75f) * 0.1f;
        this.swing(this.wisker2, speedIdle, degreeIdle, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.wisker1, speedIdle, degreeIdle, true, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.wisker2, speedIdle, degreeIdle, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.wisker1, speedIdle, degreeIdle, false, 1.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.wisker2, speedIdle, degreeIdle, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.wisker1, speedIdle, degreeIdle, false, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.nose.setScale(ulatingScale, ulatingScale, ulatingScale);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.head, (Object)this.snout, (Object)this.leftEar, (Object)this.rightEar, (Object)this.leftEye, (Object)this.rightEye, (Object)this.nose, (Object)this.wisker1, (Object)this.wisker2, (Object)this.body, (Object)this.tail, (Object)this.finRight, (Object[])new AdvancedModelBox[]{this.finLeft, this.finTop});
    }
}

