/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client;

import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    public final ForgeConfigSpec.BooleanValue plagueHearts;
    public final ForgeConfigSpec.BooleanValue singleRowPlagueOverlay;
    public final ForgeConfigSpec.BooleanValue synesthesiaShader;
    public final ForgeConfigSpec.BooleanValue funnyFluteSound;
    public final ForgeConfigSpec.BooleanValue ratFartNoises;
    public final ForgeConfigSpec.BooleanValue ratGodGlint;
    public final ForgeConfigSpec.BooleanValue ratAngelGlint;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.plagueHearts = ClientConfig.buildBoolean(builder, "Plague Heart Overlay", true, "True if player UI has plague hearts render when the effect is active.");
        this.singleRowPlagueOverlay = ClientConfig.buildBoolean(builder, "Single Row Plague Heart Overlay", false, "If true, the plague heart overlay will render as a single row of hearts instead of multiple. Turn this on if you have a mod like Mantle or Armor Points ++ installed.");
        this.synesthesiaShader = ClientConfig.buildBoolean(builder, "Synesthesia Shader", true, "If true, being under the effect of Synesthesia will tint your screen yellow.");
        this.funnyFluteSound = ClientConfig.buildBoolean(builder, "Rat Flutes play Spongebob flute sound", true, "True if rats flutes can occasionally play the flute sound at the end of the Spongebob intro. Might be smart to disable this while streaming.");
        this.ratFartNoises = ClientConfig.buildBoolean(builder, "Rat Fart Noises", true, "True if rats should rarely make a funny noise when creating rat nuggets.");
        this.ratGodGlint = ClientConfig.buildBoolean(builder, "Rat God Upgrade Glint", true, "If true, rats that have the rat upgrade: god will display with an enchantment overlay.");
        this.ratAngelGlint = ClientConfig.buildBoolean(builder, "Rat Angel Upgrade Glint", true, "If true, rats that have the rat upgrade: angel will display with a white overlay when respawning.");
    }

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }
}

