/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.util.rope;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.HopsCropHeadBlock;
import net.satisfy.brewery.entity.rope.HangingRopeEntity;
import net.satisfy.brewery.entity.rope.RopeCollisionEntity;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.BreweryMath;
import net.satisfy.brewery.util.rope.RopeHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeConnection {
    public static final double VISIBLE_RANGE = 2048.0;
    private final RopeKnotEntity from;
    private final Entity to;
    private boolean alive = true;
    public boolean removeSilently = false;
    private final List<Integer> collisions = new ArrayList<Integer>();
    private final List<Integer> hangingRopes = new ArrayList<Integer>();
    private int activeRopes;

    public RopeKnotEntity from() {
        return this.from;
    }

    public Entity to() {
        return this.to;
    }

    public boolean dead() {
        return !this.alive;
    }

    public int activeHangingRopes() {
        return this.activeRopes;
    }

    public Level getLevel() {
        return this.from.m_9236_();
    }

    public double getSquaredDistance() {
        return this.from.m_20280_(this.to);
    }

    public Vec3 getConnectionVec(float tickDelta) {
        Vec3 fromPos = this.from.m_20182_().m_82549_(this.from.m_7939_());
        Vec3 toPos = this.to.m_7398_(tickDelta);
        return toPos.m_82546_(fromPos);
    }

    public void setActive(boolean active, int id) {
        int index = this.hangingRopes.indexOf(id);
        if (index >= 0) {
            this.activeRopes = active ? (this.activeRopes &= ~(1 << index)) : (this.activeRopes |= 1 << index);
        } else {
            Brewery.LOGGER.debug("Cant change hanging entity, storage doesnt contain reference to Entity {} .", (Object)id);
        }
    }

    private RopeConnection(RopeKnotEntity from, Entity to, int activeRopes) {
        this.from = from;
        this.to = to;
        this.activeRopes = activeRopes;
    }

    @Nullable
    public static RopeConnection create(@NotNull RopeKnotEntity fromKnot, @NotNull Entity to) {
        return RopeConnection.create(fromKnot, to, 0);
    }

    @Nullable
    public static RopeConnection create(@NotNull RopeKnotEntity fromKnot, @NotNull Entity to, int activeRopes) {
        Level level;
        RopeConnection connection = new RopeConnection(fromKnot, to, activeRopes);
        if (fromKnot.sameConnectionExist(connection)) {
            return null;
        }
        fromKnot.addConnection(connection);
        if (to instanceof RopeKnotEntity) {
            RopeKnotEntity toKnot = (RopeKnotEntity)to;
            toKnot.addConnection(connection);
            connection.createCollision();
            connection.createHangingRopes();
        }
        if ((level = fromKnot.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            connection.sendAttachRopePacket(serverLevel);
        }
        return connection;
    }

    private void sendAttachRopePacket(ServerLevel serverLevel) {
        Set<ServerPlayer> trackingPlayers = RopeConnection.getTrackingPlayers(serverLevel, this);
        for (ServerPlayer player : trackingPlayers) {
            FriendlyByteBuf buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.from.m_19879_());
            buf.writeInt(this.to.m_19879_());
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BreweryNetworking.ATTACH_ROPE_S2C_ID, (FriendlyByteBuf)buf);
        }
    }

    private void createCollision() {
        if (!this.collisions.isEmpty()) {
            return;
        }
        if (this.from.m_9236_().m_5776_()) {
            return;
        }
        float distance = this.from.m_20270_(this.to);
        float step = ((EntityType)EntityRegistry.ROPE_COLLISION.get()).m_20678_() * 2.5f / distance;
        float centerHoldout = ((EntityType)EntityRegistry.ROPE_COLLISION.get()).m_20678_() / distance;
        Vec3 startPos = this.from.m_20182_().m_82549_(this.from.m_7939_());
        Vec3 endPos = this.to.m_20182_().m_82549_(this.to.m_245894_(this.to.m_20192_()));
        for (double v = (double)step; v < (double)(0.5f - centerHoldout); v += (double)step) {
            Entity toCollider;
            Entity fromCollider = this.spawnCollision(startPos, endPos, v);
            if (fromCollider != null) {
                this.collisions.add(fromCollider.m_19879_());
            }
            if ((toCollider = this.spawnCollision(endPos, startPos, v)) == null) continue;
            this.collisions.add(toCollider.m_19879_());
        }
        Entity centerCollider = this.spawnCollision(startPos, endPos, 0.5);
        if (centerCollider != null) {
            this.collisions.add(centerCollider.m_19879_());
        }
    }

    @Nullable
    private Entity spawnCollision(Vec3 startPos, Vec3 endPos, double v) {
        assert (this.from.m_9236_() instanceof ServerLevel);
        Vec3 ropeVec = endPos.m_82546_(startPos);
        Vec3 currentVec = ropeVec.m_82490_(v);
        Vec3 currentPos = startPos.m_82549_(currentVec);
        double y = RopeHelper.getYHanging(currentVec.m_82553_(), endPos.m_82546_(startPos));
        RopeCollisionEntity collisionEntity = RopeCollisionEntity.create(this.from.m_9236_(), currentPos.m_7096_(), currentPos.m_7098_() + (y -= (double)(((EntityType)EntityRegistry.ROPE_COLLISION.get()).m_20679_() / 2.0f)), currentPos.m_7094_(), this);
        if (this.from.m_9236_().m_7967_((Entity)collisionEntity)) {
            return collisionEntity;
        }
        Brewery.LOGGER.warn("FAILED to summon collision entity for a rope.");
        return null;
    }

    private void createHangingRopes() {
        if (this.from.m_9236_().m_5776_()) {
            return;
        }
        Vec3 startPos = this.from.m_20182_().m_82549_(this.from.m_7939_());
        Vec3 endPos = this.to.m_20182_().m_82549_(this.to.m_245894_(this.to.m_20192_()));
        Vec3 ropeVec = endPos.m_82546_(startPos);
        int i = 0;
        Set<BlockPos> blockPositions = BreweryMath.lineIntersection(this);
        for (BlockPos blockPos : blockPositions) {
            BlockPos currentPos = blockPos.m_121996_((Vec3i)this.from.m_31748_());
            Vec3 currentVec = new Vec3((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_());
            double y = RopeHelper.getYHanging(currentVec.m_82553_(), ropeVec);
            boolean active = (this.activeRopes & 1 << i) == 0;
            HangingRopeEntity hangingRopeEntity = HangingRopeEntity.create(this.from.m_9236_(), blockPos.m_123341_(), startPos.m_82549_((Vec3)currentVec).f_82480_ + (y -= (double)((EntityType)EntityRegistry.HANGING_ROPE.get()).m_20679_()), blockPos.m_123343_(), this, active);
            hangingRopeEntity.m_146917_(0);
            boolean added = this.from.m_9236_().m_7967_((Entity)hangingRopeEntity);
            if (added) {
                this.hangingRopes.add(hangingRopeEntity.m_19879_());
            } else {
                Brewery.LOGGER.warn("FAILED to summon hanging rope entity.");
            }
            ++i;
        }
    }

    public boolean needsBeDestroyed() {
        return this.from.m_213877_() || this.to.m_213877_();
    }

    public void destroy(boolean mayDrop) {
        Player player;
        if (!this.alive) {
            return;
        }
        this.alive = false;
        Level level = this.from.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        boolean drop = mayDrop;
        Entity entity = this.to;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            drop = false;
        }
        if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
            drop = false;
        }
        if (drop) {
            ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.ROPE.get());
            Entity entity2 = this.to;
            if (entity2 instanceof Player) {
                Player player2 = (Player)entity2;
                player2.m_36356_(stack);
            } else {
                Vec3 middle = BreweryMath.middleOf(this.from.m_20182_(), this.to.m_20182_());
                ItemEntity itemEntity = new ItemEntity(level, middle.f_82479_, middle.f_82480_, middle.f_82481_, stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        this.destroyCollision();
        this.destroyHangingRopes();
        entity = this.from.m_9236_();
        if (entity instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (!this.from.m_213877_() && !this.to.m_213877_()) {
                this.sendDetachChainPacket(serverLevel);
            }
        }
    }

    private void sendDetachChainPacket(ServerLevel serverLevel) {
        Set<ServerPlayer> trackingPlayers = RopeConnection.getTrackingPlayers(serverLevel, this);
        for (ServerPlayer player : trackingPlayers) {
            FriendlyByteBuf buf = BreweryNetworking.createPacketBuf();
            buf.writeInt(this.from.m_19879_());
            buf.writeInt(this.to.m_19879_());
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BreweryNetworking.DETACH_ROPE_S2C_ID, (FriendlyByteBuf)buf);
        }
    }

    private void destroyCollision() {
        for (Integer entityId : this.collisions) {
            Entity e = this.from.m_9236_().m_6815_(entityId.intValue());
            if (e instanceof RopeCollisionEntity) {
                e.m_146870_();
                continue;
            }
            Brewery.LOGGER.warn("Collision storage contained reference to {} (#{}) which is not a collision entity.", (Object)e, (Object)entityId);
        }
        this.collisions.clear();
    }

    private void destroyHangingRopes() {
        Integer entityId2;
        for (Integer entityId2 : this.hangingRopes) {
            Entity entity = this.from.m_9236_().m_6815_(entityId2.intValue());
            if (entity instanceof HangingRopeEntity) {
                entity.m_146870_();
                continue;
            }
            Brewery.LOGGER.warn("Hanging storage contained reference to {} (#{}) which is not a hanging rope entity.", (Object)entity, (Object)entityId2);
        }
        entityId2 = this.from.m_9236_();
        if (entityId2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entityId2;
            Set<BlockPos> blockPositions = BreweryMath.lineIntersection(this);
            for (BlockPos blockPos : blockPositions) {
                HangingRopeEntity.notifyBlock(blockPos, serverLevel, HopsCropHeadBlock.getHeadBlock());
            }
        }
        this.collisions.clear();
    }

    private static Set<ServerPlayer> getTrackingPlayers(ServerLevel serverLevel, RopeConnection connection) {
        HashSet<ServerPlayer> trackingPlayers = new HashSet<ServerPlayer>();
        RopeKnotEntity from = connection.from();
        Entity to = connection.to();
        trackingPlayers.addAll(serverLevel.m_6907_().stream().filter(player -> player.m_20275_(from.m_20182_().m_7096_(), from.m_20182_().m_7098_(), from.m_20182_().m_7094_()) <= 2048.0).toList());
        trackingPlayers.addAll(serverLevel.m_6907_().stream().filter(player -> player.m_20275_(to.m_20182_().m_7096_(), to.m_20182_().m_7098_(), to.m_20182_().m_7094_()) <= 2048.0).toList());
        return trackingPlayers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RopeConnection)) {
            return false;
        }
        RopeConnection that = (RopeConnection)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) || Objects.equals(this.from, that.to) && Objects.equals(this.to, that.from);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

