/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.mixin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.satisfy.brewery.Brewery;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLoadingScreen.class})
public abstract class DisclaimerMixin
extends Screen {
    @Unique
    private static final Component[] DISCLAIMERS = new Component[]{Component.m_237115_((String)"disclaimer.brewery.drugs"), Component.m_237115_((String)"disclaimer.brewery.drive"), Component.m_237115_((String)"disclaimer.brewery.alcohol")};
    @Unique
    private final Component disclaimer = DISCLAIMERS[RandomSource.m_216327_().m_216339_(0, DISCLAIMERS.length)];
    @Unique
    private boolean added = false;

    protected DisclaimerMixin(Component component) {
        super(component);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderDisclaimer(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        String[] disclaimers = this.disclaimer.getString().split("\n");
        if (!this.added) {
            this.added = true;
            MutableComponent title = Component.m_237115_((String)"disclaimer.brewery.disclaimer").m_130940_(ChatFormatting.YELLOW);
            int width = this.f_96547_.m_92852_((FormattedText)title);
            int x = (this.f_96543_ - width) / 2;
            Objects.requireNonNull(this.f_96547_);
            this.m_142416_((GuiEventListener)new PlainTextButton(x, this.f_96544_ - 9 * (disclaimers.length + 1) - 4, width, 10, (Component)title, button -> {
                String url = "https://www.who.int/news-room/fact-sheets/detail/alcohol";
                try {
                    Util.m_137581_().m_137650_(new URL(url));
                }
                catch (MalformedURLException e) {
                    Brewery.LOGGER.debug("Unable to load URL: [" + url + "]");
                }
            }, this.f_96547_));
        }
        for (int y = disclaimers.length; y > 0; --y) {
            String info = disclaimers[disclaimers.length - y];
            int width = this.f_96547_.m_92895_(info);
            int x = (this.f_96543_ - width) / 2;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(0.0, 0.0, 2.0);
            MutableComponent mutableComponent = Component.m_237113_((String)info).m_130940_(ChatFormatting.WHITE);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280430_(this.f_96547_, (Component)mutableComponent, x, this.f_96544_ - 9 * y - 4, 0xFFFF55);
            guiGraphics.m_280168_().m_85849_();
        }
        super.m_88315_(guiGraphics, i, j, f);
    }
}

