/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.entity.rope;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.entity.rope.IRopeEntity;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RopeCollisionEntity
extends Entity
implements IRopeEntity {
    @Nullable
    private RopeConnection connection;

    public RopeCollisionEntity(EntityType<? extends RopeCollisionEntity> entityType, Level level) {
        super(entityType, level);
    }

    private RopeCollisionEntity(Level level, double x, double y, double z, @NotNull RopeConnection connection) {
        this((EntityType<? extends RopeCollisionEntity>)((EntityType)EntityRegistry.ROPE_COLLISION.get()), level);
        this.connection = connection;
        this.m_6034_(x, y, z);
    }

    public static RopeCollisionEntity create(Level level, double x, double y, double z, RopeConnection connection) {
        return new RopeCollisionEntity(level, x, y, z, connection);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.connection != null && this.connection.needsBeDestroyed()) {
            this.connection.destroy(true);
        }
        if (this.connection == null || this.connection.dead()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_6469_(this.m_269291_().m_269075_(player), 0.0f);
        } else {
            this.m_5496_(SoundEvents.f_12641_, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        InteractionResult result = IRopeEntity.onDamageFrom(this, damageSource);
        if (result.m_19077_()) {
            this.destroyConnections(result == InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double d) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_21093_(itemStack -> itemStack.m_150930_(Items.f_42574_))) {
            return super.m_6783_(d);
        }
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    public void destroyConnections(boolean mayDrop) {
        if (this.connection != null) {
            this.connection.destroy(mayDrop);
        }
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

