/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.client.model.RopeKnotEntityModel;
import net.satisfy.brewery.client.render.block.RopeRender;
import net.satisfy.brewery.entity.rope.RopeKnotEntity;
import net.satisfy.brewery.registry.ModelRegistry;
import net.satisfy.brewery.util.BreweryIdentifier;
import net.satisfy.brewery.util.BreweryMath;
import net.satisfy.brewery.util.rope.RopeConnection;
import org.jetbrains.annotations.NotNull;

public class RopeKnotRenderer
extends EntityRenderer<RopeKnotEntity> {
    private static final ResourceLocation KNOT_TEXTURE = new BreweryIdentifier("textures/rope/rope_knot.png");
    private final RopeRender hopRopeRenderer = new RopeRender();
    private final RopeKnotEntityModel<RopeKnotEntity> model;

    public RopeKnotRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RopeKnotEntityModel(context.m_174023_(ModelRegistry.ROPE_KNOT));
    }

    public boolean shouldRender(RopeKnotEntity entity, Frustum frustum, double d, double e, double f) {
        if (entity.f_19811_) {
            return true;
        }
        for (RopeConnection connection : entity.getConnections()) {
            if (connection.from() != entity) continue;
            if (connection.to() instanceof Player) {
                return true;
            }
            if (!connection.to().m_6000_(d, e, f)) continue;
            return true;
        }
        return super.m_5523_((Entity)entity, frustum, d, e, f);
    }

    public void render(RopeKnotEntity entity, float f, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (entity.shouldRenderKnot()) {
            poseStack.m_85836_();
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.model.m_6973_(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(this.model.m_103119_(KNOT_TEXTURE));
            this.model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        Set<RopeConnection> connections = entity.getConnections();
        for (RopeConnection connection : connections) {
            if (connection.from() != entity || connection.dead()) continue;
            this.renderRopeConnection(connection, tickDelta, poseStack, multiBufferSource);
        }
        super.m_7392_((Entity)entity, f, tickDelta, poseStack, multiBufferSource, light);
    }

    private void renderRopeConnection(RopeConnection connection, float tickDelta, PoseStack poseStack, MultiBufferSource vertexConsumerProvider) {
        RopeKnotEntity fromKnot = connection.from();
        Entity toEntity = connection.to();
        Vec3 ropeVec = connection.getConnectionVec(tickDelta);
        RenderType entityCutout = RenderType.m_110458_((ResourceLocation)new BreweryIdentifier("textures/rope/rope.png"));
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(entityCutout);
        BlockPos blockPosOfStart = BreweryMath.ofFloored(fromKnot.m_20299_(tickDelta));
        BlockPos blockPosOfEnd = BreweryMath.ofFloored(toEntity.m_20299_(tickDelta));
        int blockLightLevelOfStart = fromKnot.m_9236_().m_45517_(LightLayer.BLOCK, blockPosOfStart);
        int blockLightLevelOfEnd = toEntity.m_9236_().m_45517_(LightLayer.BLOCK, blockPosOfEnd);
        int skylightLevelOfStart = fromKnot.m_9236_().m_45517_(LightLayer.SKY, blockPosOfStart);
        int skylightLevelOfEnd = toEntity.m_9236_().m_45517_(LightLayer.SKY, blockPosOfEnd);
        poseStack.m_85836_();
        Vec3 leashOffset = fromKnot.m_7939_();
        poseStack.m_85837_(leashOffset.f_82479_, leashOffset.f_82480_, leashOffset.f_82481_);
        this.hopRopeRenderer.render(vertexConsumer, poseStack, ropeVec, fromKnot.m_19879_(), blockLightLevelOfStart, blockLightLevelOfEnd, skylightLevelOfStart, skylightLevelOfEnd);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(RopeKnotEntity entity) {
        return new ResourceLocation("");
    }
}

