/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RenderEvents {
    private static final ResourceLocation MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/icons/microphone.png");
    private static final ResourceLocation WHISPER_MICROPHONE_ICON = new ResourceLocation("voicechat", "textures/icons/microphone_whisper.png");
    private static final ResourceLocation MICROPHONE_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/microphone_off.png");
    private static final ResourceLocation SPEAKER_ICON = new ResourceLocation("voicechat", "textures/icons/speaker.png");
    private static final ResourceLocation WHISPER_SPEAKER_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_whisper.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_off.png");
    private static final ResourceLocation DISCONNECT_ICON = new ResourceLocation("voicechat", "textures/icons/disconnected.png");
    private static final ResourceLocation GROUP_ICON = new ResourceLocation("voicechat", "textures/icons/group.png");
    private final Minecraft minecraft = Minecraft.m_91087_();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(GuiGraphics guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showHudIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHud.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(GuiGraphics guiGraphics, ResourceLocation texture) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.m_280168_().m_85837_((double)this.minecraft.m_91268_().m_85445_(), 0.0, 0.0);
        }
        if (posY < 0) {
            guiGraphics.m_280168_().m_85837_(0.0, (double)this.minecraft.m_91268_().m_85446_(), 0.0);
        }
        guiGraphics.m_280168_().m_85837_((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280163_(texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.m_280168_().m_85849_();
    }

    private void onRenderName(Entity entity, Component component, PoseStack stack, MultiBufferSource vertexConsumers, int light) {
        if (component == null) {
            return;
        }
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showNametagIcons.get().booleanValue()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (entity == this.minecraft.f_91074_) {
            return;
        }
        if (!this.minecraft.f_91066_.f_92062_) {
            ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
            ClientVoicechat client = ClientManager.getClient();
            UUID groupId = manager.getGroup(player);
            if (client != null && client.getTalkCache().isWhispering((Entity)player)) {
                this.renderPlayerIcon(player, component, WHISPER_SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (client != null && client.getTalkCache().isTalking((Entity)player)) {
                this.renderPlayerIcon(player, component, SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisconnected(player)) {
                this.renderPlayerIcon(player, component, DISCONNECT_ICON, stack, vertexConsumers, light);
            } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
                this.renderPlayerIcon(player, component, GROUP_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisabled(player)) {
                this.renderPlayerIcon(player, component, SPEAKER_OFF_ICON, stack, vertexConsumers, light);
            }
        }
    }

    private void renderPlayerIcon(Player player, Component component, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource buffer, int light) {
        if (!ClientPluginManager.instance().shouldRenderPlayerIcons(player.m_20148_())) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)player.m_20206_() + 0.5, 0.0);
        matrixStackIn.m_252781_(this.minecraft.m_91290_().m_253208_());
        matrixStackIn.m_85841_(-0.025f, -0.025f, 0.025f);
        matrixStackIn.m_85837_(0.0, -1.0, 0.0);
        float offset = this.minecraft.f_91062_.m_92852_((FormattedText)component) / 2 + 2;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)texture));
        int alpha = 32;
        if (player.m_20163_()) {
            RenderEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        } else {
            RenderEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, light);
            VertexConsumer builderSeeThrough = buffer.m_6299_(RenderType.m_110500_((ResourceLocation)texture));
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        }
        matrixStackIn.m_85849_();
    }

    private boolean shouldShowIcons() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.m_91092_() == null || this.minecraft.m_91092_().m_6992_();
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        PoseStack.Pose entry = matrixStack.m_85850_();
        builder.m_252986_(entry.m_252922_(), x, y, z).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(entry.m_252943_(), 0.0f, 0.0f, -1.0f).m_5752_();
    }
}

