/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.TransformStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public abstract class AbstractSpellCastingMobModel
extends DefaultedEntityGeoModel<AbstractSpellCastingMob> {
    protected TransformStack transformStack = new TransformStack();
    private long lastRenderedInstance = -1L;

    public AbstractSpellCastingMobModel() {
        super(IronsSpellbooks.id("spellcastingmob"));
    }

    public ResourceLocation getModelResource(AbstractSpellCastingMob object) {
        return AbstractSpellCastingMob.modelResource;
    }

    public abstract ResourceLocation getTextureResource(AbstractSpellCastingMob var1);

    public ResourceLocation getAnimationResource(AbstractSpellCastingMob animatable) {
        return AbstractSpellCastingMob.animationInstantCast;
    }

    public void handleAnimations(AbstractSpellCastingMob entity, long instanceId, AnimationState<AbstractSpellCastingMob> animationState) {
        boolean isReRender;
        AnimatableManager manager = entity.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = (Double)animationState.getData(DataTickets.TICK);
        float partialTick = animationState.getPartialTick();
        double currentFrameTime = entity instanceof Entity || entity instanceof GeoReplacedEntity ? currentTick + (double)partialTick : currentTick - manager.getFirstTickTime();
        boolean bl = isReRender = !manager.isFirstTick() && currentFrameTime == manager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        this.lastRenderedInstance = instanceId;
        this.transformStack.resetDirty();
        super.handleAnimations((GeoAnimatable)entity, instanceId, animationState);
        this.transformStack.popStack();
    }

    public void setCustomAnimations(AbstractSpellCastingMob entity, long instanceId, AnimationState<AbstractSpellCastingMob> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (!entity.shouldBeExtraAnimated()) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone body = this.getAnimationProcessor().getBone("body");
        CoreGeoBone torso = this.getAnimationProcessor().getBone("torso");
        CoreGeoBone rightArm = this.getAnimationProcessor().getBone("right_arm");
        CoreGeoBone leftArm = this.getAnimationProcessor().getBone("left_arm");
        CoreGeoBone rightLeg = this.getAnimationProcessor().getBone("right_leg");
        CoreGeoBone leftLeg = this.getAnimationProcessor().getBone("left_leg");
        if (!entity.isAnimating() || entity.shouldAlwaysAnimateHead()) {
            this.transformStack.pushRotation(head, Mth.m_14179_((float)partialTick, (float)(-entity.f_19860_), (float)(-entity.m_146909_())) * ((float)Math.PI / 180), Mth.m_14179_((float)partialTick, (float)(Mth.m_14177_((float)(-entity.f_20886_ + entity.f_20884_)) * ((float)Math.PI / 180)), (float)(Mth.m_14177_((float)(-entity.f_20885_ + entity.f_20883_)) * ((float)Math.PI / 180))), 0.0f);
        }
        Vector2f limbSwing = this.getLimbSwing(entity, entity.f_267362_, partialTick);
        float limbSwingAmount = limbSwing.x;
        float limbSwingSpeed = limbSwing.y;
        if (entity.m_20159_() && entity.m_20202_().shouldRiderSit()) {
            this.transformStack.pushRotation(rightLeg, 1.4137167f, -0.31415927f, -0.07853982f);
            this.transformStack.pushRotation(leftLeg, 1.4137167f, 0.31415927f, 0.07853982f);
        } else if (!entity.isAnimating() || entity.shouldAlwaysAnimateLegs()) {
            float strength = 0.75f;
            Vec3 facing = entity.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            Vec3 momentum = entity.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            Vec3 facingOrth = new Vec3(-facing.f_82481_, 0.0, facing.f_82479_);
            float directionForward = (float)facing.m_82526_(momentum);
            float directionSide = (float)facingOrth.m_82526_(momentum) * 0.35f;
            float rightLateral = -Mth.m_14031_((float)(limbSwingSpeed * 0.6662f)) * 4.0f * limbSwingAmount;
            float leftLateral = -Mth.m_14031_((float)(limbSwingSpeed * 0.6662f - (float)Math.PI)) * 4.0f * limbSwingAmount;
            this.transformStack.pushPosition(rightLeg, rightLateral * directionSide, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f)) * 4.0f * strength * limbSwingAmount, rightLateral * directionForward);
            this.transformStack.pushRotation(rightLeg, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f)) * 1.4f * limbSwingAmount * strength, 0.0f, 0.0f);
            this.transformStack.pushPosition(leftLeg, leftLateral * directionSide, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f - (float)Math.PI)) * 4.0f * strength * limbSwingAmount, leftLateral * directionForward);
            this.transformStack.pushRotation(leftLeg, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * strength, 0.0f, 0.0f);
            if (entity.bobBodyWhileWalking()) {
                this.transformStack.pushPosition(body, 0.0f, Mth.m_14154_((float)Mth.m_14089_((float)((limbSwingSpeed * 1.2662f - 1.5707964f) * 0.5f))) * 2.0f * strength * limbSwingAmount, 0.0f);
            }
        }
        if (!entity.isAnimating()) {
            this.transformStack.pushRotation(rightArm, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f, 0.0f, 0.0f);
            this.transformStack.pushRotation(leftArm, Mth.m_14089_((float)(limbSwingSpeed * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f, 0.0f, 0.0f);
            this.bobBone(rightArm, (float)entity.f_19797_ + partialTick, 1.0f);
            this.bobBone(leftArm, (float)entity.f_19797_ + partialTick, -1.0f);
            if (entity.isDrinkingPotion()) {
                this.transformStack.pushRotation(entity.m_21526_() ? leftArm : rightArm, 0.61086524f, (float)(entity.m_21526_() ? -25 : 25) * ((float)Math.PI / 180), (float)(entity.m_21526_() ? 15 : -15) * ((float)Math.PI / 180));
            }
        }
    }

    protected void bobBone(CoreGeoBone bone, float offset, float multiplier) {
        float z = multiplier * (Mth.m_14089_((float)(offset * 0.09f)) * 0.05f + 0.05f);
        float x = multiplier * Mth.m_14031_((float)(offset * 0.067f)) * 0.05f;
        this.transformStack.pushRotation(bone, x, 0.0f, z);
    }

    protected Vector2f getLimbSwing(AbstractSpellCastingMob entity, WalkAnimationState walkAnimationState, float partialTick) {
        float limbSwingAmount = 0.0f;
        float limbSwingSpeed = 0.0f;
        if (entity.m_6084_()) {
            limbSwingAmount = walkAnimationState.m_267711_(partialTick);
            limbSwingSpeed = walkAnimationState.m_267590_(partialTick);
            if (entity.m_6162_()) {
                limbSwingSpeed *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        return new Vector2f(limbSwingAmount, limbSwingSpeed);
    }
}

