/*
 * Decompiled with CFR 0.152.
 */
package net.lazrproductions.chess.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@OnlyIn(value=Dist.CLIENT)
public class ChessClientMod {
    public static ChessClientMod instance;
    private int offsetX = 0;
    private int offsetZ = 0;
    private boolean showGrid = true;
    private boolean isBlocks = true;
    private int maximumMoveDistance = 20;
    private float[] blockColor = this.colorToRgb(16308224);
    private float[] blockColor2 = this.colorToRgb(0xFFFFFF);
    private float[] opponentColor = this.colorToRgb(0xC60000);
    private float blockColorSpeed = 0.02f;
    private boolean dump = true;
    private long lastDumpTime;
    private long thisDumpTime;
    public GamePiece selectedPiece = null;
    public Moveset[] pieceMoves = new Moveset[]{new Moveset(new String[]{"     ", " !?! ", "  O  ", "     ", "     "}), new Moveset(new String[]{" 1 1 ", "1   1", "  O  ", "1   1", " 1 1 "}), new Moveset(new String[]{"     ", " * * ", "  O  ", " * * ", "     "}), new Moveset(new String[]{"     ", "  *  ", " *O* ", "  *  ", "     "}), new Moveset(new String[]{"     ", " 111 ", " 1O1 ", " 111 ", "     "}), new Moveset(new String[]{"     ", " *** ", " *O* ", " *** ", "     "}), new Moveset(new String[]{"     ", " 1 1 ", "  O  ", "     ", "     "}), new Moveset(new String[]{"     ", " 1 1 ", "  O  ", " 1 1 ", "     "})};
    float t = 0.0f;

    public ChessClientMod() {
        instance = this;
    }

    private float[] colorToRgb(int color) {
        float[] result = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f};
        return result;
    }

    public void clearSelectedPiece() {
        this.selectedPiece = null;
    }

    public boolean selectPiece(GamePiece piece) {
        if (this.selectedPiece != null) {
            return false;
        }
        this.selectedPiece = piece;
        return true;
    }

    public boolean selectPiece(BlockPos pos, int piece, int color, int facing) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            return false;
        }
        this.selectedPiece = new GamePiece(pos, piece, color, facing);
        return true;
    }

    public boolean deselectPiece(GamePiece piece) {
        if (this.selectedPiece == piece) {
            this.selectedPiece = null;
            return true;
        }
        return false;
    }

    public boolean deselectPiece(BlockPos pos) {
        if (this.selectedPiece.pos == pos) {
            this.selectedPiece = null;
            return true;
        }
        return false;
    }

    public boolean deselectPiece() {
        this.selectedPiece = null;
        return true;
    }

    public boolean pieceIsSelected(GamePiece piece) {
        return this.selectedPiece == piece;
    }

    public boolean pieceIsSelected(BlockPos pos) {
        return this.selectedPiece != null && this.selectedPiece.pos == pos;
    }

    public boolean changeSelectedPiece(BlockPos pos, int piece) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            this.selectedPiece.piece = piece;
            return true;
        }
        return false;
    }

    public boolean changeSelectedPieceColor(BlockPos pos, int color) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            this.selectedPiece.color = color;
            return true;
        }
        return false;
    }

    private void drawSquare(VertexConsumer consumer, PoseStack stack, float x, float y, float z, float r, float g, float b, float from, float to) {
        this.drawLine(consumer, stack, x + from, x + to, y, y, z + from, z + from, r, g, b);
        this.drawLine(consumer, stack, x + to, x + to, y, y, z + from, z + to, r, g, b);
        this.drawLine(consumer, stack, x + to, x + from, y, y, z + to, z + to, r, g, b);
        this.drawLine(consumer, stack, x + from, x + from, y, y, z + to, z + from, r, g, b);
    }

    private void drawLine(VertexConsumer consumer, PoseStack stack, float x1, float x2, float y1, float y2, float z1, float z2, float red, float green, float blue) {
        Matrix4f model;
        if (this.dump) {
            System.out.println("line from " + x1 + "," + y1 + "," + z1 + " to " + x2 + "," + y2 + "," + z2);
        }
        if ((model = new Matrix4f((Matrix4fc)stack.m_85850_().m_252922_())) != null) {
            consumer.m_252986_(model, x1, y1, z1).m_85950_(red, green, blue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            consumer.m_252986_(model, x2, y2, z2).m_85950_(red, green, blue, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        }
    }

    public ArrayList<MovesetDirection> movesetToDirections(Level world, String[] move, int facing) {
        ArrayList<MovesetDirection> positions = new ArrayList<MovesetDirection>(0);
        for (int i = 0; i < 5; ++i) {
            for (int p = 0; p < 5; ++p) {
                if (facing == 0) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new BlockPos(p - 2, 0, i - 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new BlockPos(p - 2, 0, i - 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new BlockPos(p - 2, 0, i - 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new BlockPos(p - 2, 0, i - 2), false, false, true));
                    continue;
                }
                if (facing == 1) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new BlockPos(-p + 2, 0, -i + 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new BlockPos(-p + 2, 0, -i + 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new BlockPos(-p + 2, 0, -i + 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new BlockPos(-p + 2, 0, -i + 2), false, false, true));
                    continue;
                }
                if (facing == 2) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new BlockPos(i - 2, 0, p - 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new BlockPos(i - 2, 0, p - 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new BlockPos(i - 2, 0, p - 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new BlockPos(i - 2, 0, p - 2), false, false, true));
                    continue;
                }
                if (facing != 3) continue;
                if (move[i].charAt(p) == '1') {
                    positions.add(new MovesetDirection(new BlockPos(-i + 2, 0, -p + 2), false, false, false));
                    continue;
                }
                if (move[i].charAt(p) == '*') {
                    positions.add(new MovesetDirection(new BlockPos(-i + 2, 0, -p + 2), true, false, false));
                    continue;
                }
                if (move[i].charAt(p) == '!') {
                    positions.add(new MovesetDirection(new BlockPos(-i + 2, 0, -p + 2), false, true, false));
                    continue;
                }
                if (move[i].charAt(p) != '?') continue;
                positions.add(new MovesetDirection(new BlockPos(-i + 2, 0, -p + 2), false, false, true));
            }
        }
        return positions;
    }

    public class GamePiece {
        public int piece;
        public BlockPos pos;
        public int color;
        public int facing;

        public GamePiece(BlockPos pos, int piece, int color, int facing) {
            this.piece = piece;
            this.pos = pos;
            this.color = color;
            this.facing = facing;
        }
    }

    public class Moveset {
        public String[] movements = new String[]{"     ", "  1  ", " 1O1 ", "  1  ", "     "};

        public Moveset(String[] movements) {
            this.movements = movements;
        }
    }

    class MovesetDirection {
        public BlockPos direction;
        public boolean infinite;
        public boolean mustDefeat;
        public boolean cannotDefeat;

        public MovesetDirection(BlockPos p, boolean inf, boolean mustDefeat, boolean cannotDefeat) {
            this.direction = p;
            this.infinite = inf;
            this.mustDefeat = mustDefeat;
            this.cannotDefeat = cannotDefeat;
        }
    }

    class Selection {
        public BlockPos pos;
        public float[] color;

        public Selection(BlockPos p, float[] color) {
            this.pos = p;
            this.color = color;
        }
    }

    public class GameBoard {
        public GamePiece piece;
        public BlockPos pos;

        public GameBoard(BlockPos pos, GamePiece piece) {
            this.piece = piece;
            this.pos = pos;
        }
    }
}

