/*
 * Decompiled with CFR 0.152.
 */
package net.lazrproductions.chess.block.custom;

import javax.annotation.Nullable;
import net.lazrproductions.chess.block.ModBlocks;
import net.lazrproductions.chess.util.ChessClientMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChessPieceBlock
extends Block {
    public static final IntegerProperty PIECE = IntegerProperty.m_61631_((String)"piece", (int)0, (int)7);
    public static final IntegerProperty COLOR = IntegerProperty.m_61631_((String)"dye", (int)0, (int)16);
    public static final IntegerProperty FACING = IntegerProperty.m_61631_((String)"facing", (int)0, (int)3);
    static final Item[] dyes = new Item[]{Items.f_42589_, Items.f_42535_, Items.f_42491_, Items.f_42490_, Items.f_42498_, Items.f_42495_, Items.f_42497_, Items.f_42536_, Items.f_42539_, Items.f_42540_, Items.f_42496_, Items.f_42492_, Items.f_42538_, Items.f_42494_, Items.f_42493_, Items.f_42537_, Items.f_42489_};
    static final VoxelShape pawnShape = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
    static final VoxelShape rookShape = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)17.0, (double)13.0);
    static final VoxelShape bishopShape = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)23.0, (double)13.0);
    static final VoxelShape knightShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)19.0, (double)14.0);
    static final VoxelShape kingShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)29.0, (double)14.0);
    static final VoxelShape queenShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)26.0, (double)14.0);
    static final VoxelShape checkersShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    public ChessPieceBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)PIECE) == 0) {
            return pawnShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 1) {
            return knightShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 2) {
            return bishopShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 3) {
            return rookShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 4) {
            return kingShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 5) {
            return queenShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) >= 6) {
            return checkersShape;
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)PIECE) == 0) {
            return pawnShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 1) {
            return knightShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 2) {
            return bishopShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 3) {
            return rookShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 4) {
            return kingShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) == 5) {
            return queenShape;
        }
        if ((Integer)state.m_61143_((Property)PIECE) >= 6) {
            return checkersShape;
        }
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41720_() != null && player.m_21120_(hand).m_41720_() != Items.f_41852_) {
            if (this.IsDye(player.m_21120_(hand).m_41720_()) <= -1 && player.m_21120_(hand).m_41720_() == Items.f_42398_) {
                int currentPiece = (Integer)state.m_61143_((Property)PIECE);
                int nextPiece = currentPiece + 1;
                if (nextPiece > 7) {
                    nextPiece = 0;
                }
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)PIECE, (Comparable)Integer.valueOf(nextPiece)), 10);
                world.m_5594_(null, pos, SoundEvents.f_12634_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.IsDye(player.m_21120_(hand).m_41720_()) > -1 && this.IsDye(player.m_21120_(hand).m_41720_()) != ((Integer)state.m_61143_((Property)COLOR)).intValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(this.IsDye(player.m_21120_(hand).m_41720_()))), 10);
                if (this.IsDye(player.m_21120_(hand).m_41720_()) > 0) {
                    world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!player.m_7500_()) {
                    if (this.IsDye(player.m_21120_(hand).m_41720_()) > 0) {
                        player.m_21120_(hand).m_41774_(1);
                    } else {
                        player.m_21120_(hand).m_41774_(1);
                        ItemEntity i = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f + (float)hit.m_82434_().m_122429_()), (double)((float)pos.m_123342_() + 0.5f + (float)hit.m_82434_().m_122430_()), (double)((float)pos.m_123343_() + 0.5f + (float)hit.m_82434_().m_122431_()), new ItemStack((ItemLike)Items.f_42590_, 1));
                        i.m_32060_();
                        world.m_7967_((Entity)i);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (world.m_5776_() && hand == InteractionHand.MAIN_HAND && !ChessClientMod.instance.pieceIsSelected(pos)) {
            ChessClientMod.instance.selectPiece(pos, (Integer)state.m_61143_((Property)PIECE), (Integer)state.m_61143_((Property)COLOR), (Integer)state.m_61143_((Property)FACING));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (this.IsDye(player.m_150109_().m_8020_(player.m_150109_().f_35977_).m_41720_()) <= -1 && player.m_150109_().m_8020_(player.m_150109_().f_35977_).m_41720_() == Items.f_42398_) {
            int currentPiece = (Integer)state.m_61143_((Property)PIECE);
            int nextPiece = currentPiece - 1;
            if (nextPiece < 0) {
                nextPiece = 7;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PIECE, (Comparable)Integer.valueOf(nextPiece)), 10);
            level.m_5594_(null, pos, SoundEvents.f_12634_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PIECE, COLOR, FACING});
    }

    public boolean m_222958_(BlockState p_222959_, BlockGetter p_222960_, BlockPos p_222961_) {
        return false;
    }

    public void m_6786_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.CHESS_PIECE.get());
            CompoundTag nbt = new CompoundTag();
            itemStack.m_41751_(nbt);
            nbt.m_128405_("piece", ((Integer)state.m_61143_((Property)PIECE)).intValue());
            nbt.m_128405_("dye", ((Integer)state.m_61143_((Property)COLOR)).intValue());
            itemStack.m_41714_((Component)Component.m_237113_((String)this.getPieceName((Integer)state.m_61143_((Property)PIECE), (Integer)state.m_61143_((Property)COLOR))));
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_6786_(level, pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt != null && nbt.m_128423_("dye") != null && nbt.m_128423_("piece") != null) {
            if (entity != null) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(nbt.m_128451_("dye")))).m_61124_((Property)PIECE, (Comparable)Integer.valueOf(nbt.m_128451_("piece")))).m_61124_((Property)FACING, (Comparable)Integer.valueOf(this.getFacingDirection(new BlockPos((int)entity.m_20154_().f_82479_, (int)entity.m_20154_().f_82480_, (int)entity.m_20154_().f_82481_)))), 10);
            } else {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)COLOR, (Comparable)Integer.valueOf(nbt.m_128451_("dye")))).m_61124_((Property)PIECE, (Comparable)Integer.valueOf(nbt.m_128451_("piece")))).m_61124_((Property)FACING, (Comparable)Integer.valueOf(this.getFacingDirection(new BlockPos(0, 0, 0)))), 10);
            }
        } else if (entity != null) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)Integer.valueOf(this.getFacingDirection(new BlockPos((int)entity.m_20154_().f_82479_, (int)entity.m_20154_().f_82480_, (int)entity.m_20154_().f_82481_)))), 10);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)Integer.valueOf(this.getFacingDirection(new BlockPos(0, 0, 0)))), 10);
        }
        super.m_6402_(level, pos, state, entity, stack);
    }

    private int IsDye(Item item) {
        for (int i = 0; i < dyes.length; ++i) {
            if (item != dyes[i]) continue;
            return i;
        }
        return -1;
    }

    private String getPieceName(int piece, int color) {
        String[] pieceNames = new String[]{"Pawn", "Knight", "Bishop", "Rook", "King", "Queen", "Checkers Piece", "Checkers King Piece"};
        String[] colorNames = new String[]{"", "White", "Light Gray", "Gray", "Black", "Brown", "Red", "Orange", "Yellow", "Lime", "Green", "Cyan", "Light Blue", "Blue", "Purple", "Magenta", "Pink"};
        if (colorNames[color] == "") {
            return pieceNames[piece];
        }
        return colorNames[color] + " " + pieceNames[piece];
    }

    int getFacingDirection(BlockPos direction) {
        if (direction.equals((Object)new Vec3i(0, 0, -1))) {
            return 0;
        }
        if (direction.equals((Object)new Vec3i(0, 0, 1))) {
            return 1;
        }
        if (direction.equals((Object)new Vec3i(-1, 0, 0))) {
            return 2;
        }
        if (direction.equals((Object)new Vec3i(1, 0, 0))) {
            return 3;
        }
        return 0;
    }
}

