/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.mixin.sodium;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.managers.AsyncOcclusionTracker;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererGetter;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererSetter;
import me.cortex.nvidium.sodiumCompat.IRenderSectionExtension;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.NvidiumCompactChunkVertex;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSectionManager;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RenderSectionManager.class}, remap=false)
public class MixinRenderSectionManager
implements INvidiumWorldRendererGetter {
    @Shadow
    @Final
    private RenderRegionManager regions;
    @Shadow
    @Final
    private Long2ReferenceMap<RenderSection> sectionByPosition;
    @Shadow
    @NotNull
    private Map<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildLists;
    @Shadow
    @Final
    private int renderDistance;
    @Unique
    private NvidiumWorldRenderer renderer;
    @Unique
    private Viewport viewport;

    @Unique
    private static void updateNvidiumIsEnabled() {
        Nvidium.IS_ENABLED = !Nvidium.FORCE_DISABLE && Nvidium.IS_COMPATIBLE && IrisCheck.checkIrisShouldDisable();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel world, int renderDistance, CommandList commandList, CallbackInfo ci) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED) {
            if (this.renderer != null) {
                throw new IllegalStateException("Cannot have multiple world renderers");
            }
            this.renderer = new NvidiumWorldRenderer(Nvidium.config.async_bfs ? new AsyncOcclusionTracker(renderDistance, this.sectionByPosition, (Level)world, this.rebuildLists) : null);
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(this.renderer);
        }
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/compile/executor/ChunkBuilder;<init>(Lnet/minecraft/client/world/ClientWorld;Lme/jellysquid/mods/sodium/client/render/chunk/vertex/format/ChunkVertexType;)V", remap=true), index=1)
    private ChunkVertexType modifyVertexType(ChunkVertexType vertexType) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED) {
            return NvidiumCompactChunkVertex.INSTANCE;
        }
        return vertexType;
    }

    @Inject(method={"destroy"}, at={@At(value="TAIL")})
    private void destroy(CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            if (this.renderer == null) {
                throw new IllegalStateException("Pipeline already destroyed");
            }
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(null);
            this.renderer.delete();
            this.renderer = null;
        }
    }

    @Redirect(method={"onSectionRemoved"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;delete()V"))
    private void deleteSection(RenderSection section) {
        if (Nvidium.IS_ENABLED && Nvidium.config.region_keep_distance == 32) {
            this.renderer.deleteSection(section);
        }
        section.delete();
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void trackViewport(Camera camera, Viewport viewport, int frame, boolean spectator, CallbackInfo ci) {
        this.viewport = viewport;
    }

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            ci.cancel();
            pass.startDrawing();
            if (pass == DefaultTerrainRenderPasses.SOLID) {
                this.renderer.renderFrame(this.viewport, matrices, x, y, z);
            } else if (pass == DefaultTerrainRenderPasses.TRANSLUCENT) {
                this.renderer.renderTranslucent();
            }
            pass.endDrawing();
        }
    }

    @Inject(method={"getDebugStrings"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectDebug(CallbackInfoReturnable<Collection<String>> cir) {
        if (Nvidium.IS_ENABLED) {
            ArrayList<String> debugStrings = new ArrayList<String>();
            this.renderer.addDebugInfo(debugStrings);
            cir.setReturnValue(debugStrings);
            cir.cancel();
        }
    }

    @Override
    public NvidiumWorldRenderer getRenderer() {
        return this.renderer;
    }

    @Inject(method={"createTerrainRenderList"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectTerrainRenderList(Camera camera, Viewport viewport, int frame, boolean spectator, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ci.cancel();
        }
    }

    @Redirect(method={"submitRebuildTasks"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;setPendingUpdate(Lme/jellysquid/mods/sodium/client/render/chunk/ChunkUpdateType;)V"))
    private void injectEnqueueFalse(RenderSection instance, ChunkUpdateType type) {
        instance.setPendingUpdate(type);
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ((IRenderSectionExtension)instance).isSubmittedRebuild(false);
        }
    }

    @Unique
    private boolean isSectionVisibleBfs(RenderSection section) {
        int delta = Math.abs(section.getLastVisibleFrame() - this.renderer.getAsyncFrameId());
        return delta <= 1;
    }

    @Inject(method={"isSectionVisible"}, at={@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;getLastVisibleFrame()I", shift=At.Shift.BEFORE)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void redirectIsSectionVisible(int x, int y, int z, CallbackInfoReturnable<Boolean> cir, RenderSection render) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            cir.setReturnValue((Object)this.isSectionVisibleBfs(render));
        }
    }

    @Inject(method={"tickVisibleRenders"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectAnimatedSpriteUpdates(CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs && SodiumClientMod.options().performance.animateOnlyVisibleTextures) {
            ci.cancel();
            TextureAtlasSprite[] sprites = this.renderer.getAnimatedSpriteSet();
            if (sprites == null) {
                return;
            }
            for (TextureAtlasSprite sprite : sprites) {
                SpriteUtil.markSpriteActive((TextureAtlasSprite)sprite);
            }
        }
    }

    @Inject(method={"scheduleRebuild"}, at={@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/chunk/RenderSection;setPendingUpdate(Lme/jellysquid/mods/sodium/client/render/chunk/ChunkUpdateType;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void instantReschedule(int x, int y, int z, boolean important, CallbackInfo ci, RenderSection section, ChunkUpdateType pendingUpdate) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ArrayDeque<RenderSection> queue = this.rebuildLists.get(pendingUpdate);
            if (this.isSectionVisibleBfs(section) && queue.size() < pendingUpdate.getMaximumQueueSize()) {
                ((IRenderSectionExtension)section).isSubmittedRebuild(true);
                this.rebuildLists.get(pendingUpdate).add(section);
            }
        }
    }
}

