/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import me.cortex.nvidium.sodiumCompat.IRenderSectionExtension;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AsyncOcclusionTracker {
    private final OcclusionCuller occlusionCuller;
    private final Thread cullThread;
    private final Level world;
    private volatile boolean running = true;
    private volatile int frame = 0;
    private volatile Viewport viewport = null;
    private final Semaphore framesAhead = new Semaphore(0);
    private final AtomicReference<List<RenderSection>> atomicBfsResult = new AtomicReference();
    private final AtomicReference<List<RenderSection>> blockEntitySectionsRef = new AtomicReference(new ArrayList());
    private final AtomicReference<TextureAtlasSprite[]> visibleAnimatedSpritesRef = new AtomicReference();
    private final Map<ChunkUpdateType, ArrayDeque<RenderSection>> outputRebuildQueue;
    private final float renderDistance;
    private volatile long iterationTimeMillis;
    private volatile boolean shouldUseOcclusionCulling = true;

    public AsyncOcclusionTracker(int renderDistance, Long2ReferenceMap<RenderSection> sections, Level world, Map<ChunkUpdateType, ArrayDeque<RenderSection>> outputRebuildQueue) {
        this.occlusionCuller = new OcclusionCuller(sections, world);
        this.cullThread = new Thread(this::run);
        this.cullThread.setName("Cull thread");
        this.cullThread.setPriority(10);
        this.cullThread.start();
        this.renderDistance = (float)renderDistance * 16.0f;
        this.outputRebuildQueue = outputRebuildQueue;
        this.world = world;
    }

    private void run() {
        while (this.running) {
            List previous;
            this.framesAhead.acquireUninterruptibly();
            if (!this.running) break;
            long startTime = System.currentTimeMillis();
            boolean animateVisibleSpritesOnly = SodiumClientMod.options().performance.animateOnlyVisibleTextures;
            ArrayList chunkUpdates = new ArrayList();
            ArrayList blockEntitySections = new ArrayList();
            HashSet animatedSpriteSet = animateVisibleSpritesOnly ? new HashSet() : null;
            OcclusionCuller.Visitor visitor = (section, visible) -> {
                TextureAtlasSprite[] animatedSprites;
                if (section.getPendingUpdate() != null && section.getBuildCancellationToken() == null && !((IRenderSectionExtension)section).isSubmittedRebuild() && !((IRenderSectionExtension)section).isSeen()) {
                    ((IRenderSectionExtension)section).isSeen(true);
                    chunkUpdates.add(section);
                }
                if (!visible) {
                    return;
                }
                if ((section.getFlags() & 2) != 0 && section.getPosition().m_123314_((Vec3i)this.viewport.getChunkCoord(), 33.0)) {
                    blockEntitySections.add(section);
                }
                if (animateVisibleSpritesOnly && (section.getFlags() & 4) != 0 && section.getPosition().m_123314_((Vec3i)this.viewport.getChunkCoord(), 33.0) && (animatedSprites = section.getAnimatedSprites()) != null) {
                    animatedSpriteSet.addAll(List.of(animatedSprites));
                }
            };
            ++this.frame;
            float searchDistance = this.getSearchDistance();
            boolean useOcclusionCulling = this.shouldUseOcclusionCulling;
            try {
                this.occlusionCuller.findVisible(visitor, this.viewport, searchDistance, useOcclusionCulling, this.frame);
            }
            catch (Throwable e) {
                System.err.println("Error doing traversal");
                e.printStackTrace();
            }
            if (!chunkUpdates.isEmpty() && (previous = (List)this.atomicBfsResult.getAndSet(chunkUpdates)) != null) {
                for (RenderSection section2 : previous) {
                    if (section2.isDisposed()) continue;
                    ((IRenderSectionExtension)section2).isSeen(false);
                }
            }
            this.blockEntitySectionsRef.set(blockEntitySections);
            this.visibleAnimatedSpritesRef.set(animatedSpriteSet == null ? null : animatedSpriteSet.toArray(new TextureAtlasSprite[0]));
            this.iterationTimeMillis = System.currentTimeMillis() - startTime;
        }
    }

    public final void update(Viewport viewport, Camera camera, boolean spectator) {
        List bfsResult;
        this.shouldUseOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        this.viewport = viewport;
        if (this.framesAhead.availablePermits() < 5) {
            this.framesAhead.release();
        }
        if ((bfsResult = (List)this.atomicBfsResult.getAndSet(null)) != null) {
            for (RenderSection section : bfsResult) {
                ArrayDeque<RenderSection> queue;
                if (section.isDisposed()) continue;
                ChunkUpdateType type = section.getPendingUpdate();
                if (type != null && section.getBuildCancellationToken() == null && (queue = this.outputRebuildQueue.get(type)).size() < type.getMaximumQueueSize()) {
                    ((IRenderSectionExtension)section).isSubmittedRebuild(true);
                    queue.add(section);
                }
                ((IRenderSectionExtension)section).isSeen(false);
            }
        }
    }

    public void delete() {
        this.running = false;
        this.framesAhead.release(1000);
        try {
            this.cullThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private float getSearchDistance() {
        return this.renderDistance;
    }

    private float getSearchDistance2() {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance() : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(Camera camera, boolean spectator) {
        BlockPos origin = camera.m_90588_();
        boolean useOcclusionCulling = spectator && this.world.m_8055_(origin).m_60804_((BlockGetter)this.world, origin) ? false : Minecraft.m_91087_().f_90980_;
        return useOcclusionCulling;
    }

    private float getEffectiveRenderDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        float renderDistance = this.getRenderDistance();
        return !Mth.m_14033_((float)color[3], (float)1.0f) ? renderDistance : Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return this.renderDistance;
    }

    public int getFrame() {
        return this.frame;
    }

    public List<RenderSection> getLatestSectionsWithEntities() {
        return this.blockEntitySectionsRef.get();
    }

    @Nullable
    public TextureAtlasSprite[] getVisibleAnimatedSprites() {
        return this.visibleAnimatedSpritesRef.get();
    }

    public long getIterationTime() {
        return this.iterationTimeMillis;
    }

    public int[] getBuildQueueSizes() {
        int[] ret = new int[this.outputRebuildQueue.size()];
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            ret[type.ordinal()] = this.outputRebuildQueue.get(type).size();
        }
        return ret;
    }
}

