/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.gl;

import java.lang.ref.Cleaner;
import me.cortex.nvidium.Nvidium;

public abstract class TrackedObject {
    private final Ref ref = TrackedObject.register(this);
    private static final Cleaner cleaner = Cleaner.create();

    protected void free0() {
        if (this.isFreed()) {
            throw new IllegalStateException("Object " + this + " was double freed.");
        }
        this.ref.freedRef[0] = true;
        this.ref.cleanable.clean();
    }

    public abstract void free();

    public void assertNotFreed() {
        if (this.isFreed()) {
            throw new IllegalStateException("Object " + this + " should not be free, but is");
        }
    }

    public boolean isFreed() {
        return this.ref.freedRef[0];
    }

    public static Ref register(Object obj) {
        String clazz = obj.getClass().getName();
        Throwable trace = Nvidium.IS_DEBUG ? new Throwable() : null;
        boolean[] freed = new boolean[1];
        Cleaner.Cleanable clean = cleaner.register(obj, () -> {
            if (!freed[0]) {
                System.err.println("Object named: " + clazz + " was not freed, location at:\n");
                if (trace != null) {
                    trace.printStackTrace();
                } else {
                    System.err.println("Unknown location, turn on debug mode");
                }
                System.err.flush();
            }
        });
        return new Ref(clean, freed);
    }

    public record Ref(Cleaner.Cleanable cleanable, boolean[] freedRef) {
    }
}

