/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion;

import fuzs.extensibleenums.api.v2.BuiltInEnumFactories;
import fuzs.illagerinvasion.config.RaidWavesConfigHelper;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.handler.PlatinumTrimHandler;
import fuzs.illagerinvasion.handler.VillagerGoalHandler;
import fuzs.illagerinvasion.init.ModEntityTypes;
import fuzs.illagerinvasion.init.ModItems;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.level.BlockEvents;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterPotionBrewingMixesCallback;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3732;
import net.minecraft.class_3763;
import net.minecraft.class_44;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.class_9169;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IllagerInvasion
implements ModConstructor {
    public static final String MOD_ID = "illagerinvasion";
    public static final String MOD_NAME = "Illager Invasion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Illager Invasion");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"illagerinvasion").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        IllagerInvasion.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        BreakSpeedCallback.EVENT.register(PlatinumTrimHandler::onBreakSpeed);
        LivingExperienceDropCallback.EVENT.register(PlatinumTrimHandler::onLivingExperienceDrop);
        BlockEvents.FARMLAND_TRAMPLE.register(PlatinumTrimHandler::onFarmlandTrample);
        ServerEntityLevelEvents.LOAD.register(VillagerGoalHandler::onEntityLoad);
        LootTableLoadEvents.MODIFY.register((resourceLocation, addLootPool, removeLootPool) -> {
            IllagerInvasion.injectLootPool(resourceLocation, addLootPool, (class_5321<class_52>)class_1299.field_6065.method_16351(), ModRegistry.ILLUSIONER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(resourceLocation, addLootPool, (class_5321<class_52>)class_1299.field_6105.method_16351(), ModRegistry.PILLAGER_INJECT_LOOT_TABLE);
            IllagerInvasion.injectLootPool(resourceLocation, addLootPool, (class_5321<class_52>)class_1299.field_6134.method_16351(), ModRegistry.RAVAGER_INJECT_LOOT_TABLE);
        });
        RegisterPotionBrewingMixesCallback.EVENT.register(IllagerInvasion::registerPotionRecipes);
    }

    private static void injectLootPool(class_2960 resourceLocation, Consumer<class_55> addPool, class_5321<class_52> builtInLootTable, class_5321<class_52> injectedLootTable) {
        if (resourceLocation.equals((Object)builtInLootTable.method_29177())) {
            addPool.accept(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_83.method_428(injectedLootTable)).method_355());
        }
    }

    public void onCommonSetup() {
        IllagerInvasion.registerRaiderTypes();
        VillagerGoalHandler.init();
    }

    private static void registerRaiderTypes() {
        IllagerInvasion.registerRaiderType(ModEntityTypes.BASHER_ENTITY_TYPE, RaidWavesConfigHelper.BASHER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.PROVOKER_ENTITY_TYPE, RaidWavesConfigHelper.PROVOKER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.NECROMANCER_ENTITY_TYPE, RaidWavesConfigHelper.NECROMANCER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.SORCERER_ENTITY_TYPE, RaidWavesConfigHelper.SORCERER_RAID_WAVES);
        BuiltInEnumFactories.INSTANCE.createRaiderType(IllagerInvasion.id("illusioner"), class_1299.field_6065, RaidWavesConfigHelper.ILLUSIONER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.ARCHIVIST_ENTITY_TYPE, RaidWavesConfigHelper.ARCHIVIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.MARAUDER_ENTITY_TYPE, RaidWavesConfigHelper.MARAUDER_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.INQUISITOR_ENTITY_TYPE, RaidWavesConfigHelper.INQUISITOR_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.ALCHEMIST_ENTITY_TYPE, RaidWavesConfigHelper.ALCHEMIST_RAID_WAVES);
        IllagerInvasion.registerRaiderType(ModEntityTypes.INVOKER_ENTITY_TYPE, RaidWavesConfigHelper.INVOKER_RAID_WAVES);
    }

    private static void registerRaiderType(class_6880.class_6883<? extends class_1299<? extends class_3763>> holder, int[] spawnsPerWaveBeforeBonus) {
        BuiltInEnumFactories.INSTANCE.createRaiderType(holder.method_40237().method_29177(), (class_1299)holder.comp_349(), spawnsPerWaveBeforeBonus);
    }

    private static void registerPotionRecipes(RegisterPotionBrewingMixesCallback.Builder builder) {
        builder.registerPotionRecipe(class_1847.field_8999, class_1802.field_39057, ModRegistry.BERSERKING_POTION);
        builder.registerPotionRecipe(ModRegistry.BERSERKING_POTION, class_1802.field_8725, ModRegistry.LONG_BERSERKING_POTION);
        builder.registerPotionRecipe(ModRegistry.BERSERKING_POTION, class_1802.field_8601, ModRegistry.STRONG_BERSERKING_POTION);
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModEntityTypes.ALCHEMIST_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.36));
        context.registerEntityAttributes((class_1299)ModEntityTypes.BASHER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.31).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23722, 0.2));
        context.registerEntityAttributes((class_1299)ModEntityTypes.FIRECALLER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModEntityTypes.INQUISITOR_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.33).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 1.6).method_26868(class_5134.field_23718, 0.8));
        context.registerEntityAttributes((class_1299)ModEntityTypes.INVOKER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 250.0).method_26868(class_5134.field_23719, 0.36).method_26868(class_5134.field_23718, 0.3).method_26868(class_5134.field_23721, 8.0));
        context.registerEntityAttributes((class_1299)ModEntityTypes.MARAUDER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.3));
        context.registerEntityAttributes((class_1299)ModEntityTypes.PROVOKER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 24.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModEntityTypes.SORCERER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
        context.registerEntityAttributes((class_1299)ModEntityTypes.SURRENDERED_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 14.0).method_26868(class_5134.field_23721, 5.0));
        context.registerEntityAttributes((class_1299)ModEntityTypes.NECROMANCER_ENTITY_TYPE.comp_349(), class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23719, 0.38));
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ALCHEMIST_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.ARCHIVIST_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.BASHER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.FIRECALLER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.INQUISITOR_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.INVOKER_ENTITY_TYPE.comp_349(), class_9169.field_48742, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.MARAUDER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.PROVOKER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SORCERER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.SURRENDERED_ENTITY_TYPE.comp_349(), class_9169.field_48742, class_2902.class_2903.field_13203, class_1588::method_20680);
        context.registerSpawnPlacement((class_1299)ModEntityTypes.NECROMANCER_ENTITY_TYPE.comp_349(), class_9169.field_48745, class_2902.class_2903.field_13203, class_3732::method_20739);
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> new class_1799((class_1935)ModItems.HORN_OF_SIGHT_ITEM.comp_349())).displayItems((itemDisplayParameters, output) -> {
            output.method_45421((class_1935)ModItems.IMBUING_TABLE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.UNUSUAL_DUST_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.ILLUSIONARY_DUST_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.HALLOWED_GEM_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.PRIMAL_ESSENCE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.PLATINUM_CHUNK_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.PLATINUM_SHEET_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.PLATINUM_INFUSED_HATCHET_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.HORN_OF_SIGHT_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.LOST_CANDLE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MAGICAL_FIRE_CHARGE_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.PROVOKER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.BASHER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.SORCERER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.ARCHIVIST_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.INQUISITOR_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.MARAUDER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.INVOKER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.ALCHEMIST_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.FIRECALLER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.NECROMANCER_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.SURRENDERED_SPAWN_EGG_ITEM.comp_349());
            output.method_45421((class_1935)ModItems.ILLUSIONER_SPAWN_EGG_ITEM.comp_349());
        }));
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

