/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.PlatformClient;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.BetterCombatClientEvents;
import net.bettercombat.api.fx.ParticlePlacement;
import net.bettercombat.api.fx.TrailAppearance;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.Keybindings;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.client.particle.SlashParticleUtil;
import net.bettercombat.config.ClientConfigWrapper;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.logic.WeaponSwing;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.PatternMatching;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftClientInject
implements MinecraftClient_BetterCombat {
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    private int field_1752;
    @Shadow
    @Final
    public class_327 field_1772;
    @Shadow
    public int field_1771;
    @Shadow
    @Final
    public class_329 field_1705;
    @Shadow
    @Nullable
    public class_239 field_1765;
    private boolean isHoldingAttackInput = false;
    private boolean isHarvesting = false;
    private class_1799 upswingStack;
    private class_1799 lastAttacedWithItemStack;
    private WeaponSwing ongoingSwing;
    private int lastAttacked = 1000;
    private float lastSwingDuration = 0.0f;
    private int comboReset = 0;
    private List<class_1297> targetsInReach = null;

    private class_310 thisClient() {
        return (class_310)this;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(class_437 screen, CallbackInfo ci) {
        BetterCombatClientMod.ENABLED = false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doAttack(CallbackInfoReturnable<Boolean> info) {
        if (!BetterCombatClientMod.ENABLED) {
            return;
        }
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null && attributes.attacks() != null) {
            if (this.isTargetingMineableBlock() || this.isHarvesting) {
                this.isHarvesting = true;
                return;
            }
            this.startUpswing(attributes);
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_handleBlockBreaking(boolean bl, CallbackInfo ci) {
        if (!BetterCombatClientMod.ENABLED) {
            return;
        }
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null && attributes.attacks() != null) {
            boolean isPressed = client.field_1690.field_1886.method_1434();
            if (isPressed && !this.isHoldingAttackInput) {
                if (this.isTargetingMineableBlock() || this.isHarvesting) {
                    this.isHarvesting = true;
                    return;
                }
                ci.cancel();
            }
            if (BetterCombatClientMod.config.isHoldToAttackEnabled && isPressed) {
                this.isHoldingAttackInput = true;
                this.startUpswing(attributes);
                ci.cancel();
            } else {
                this.isHarvesting = false;
                this.isHoldingAttackInput = false;
            }
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doItemUse(CallbackInfo ci) {
        if (!BetterCombatClientMod.ENABLED) {
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        double upswingRate = hand.upswingRate();
        if (this.currentUpswingTicks() > 0 || (double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            ci.cancel();
        }
    }

    private boolean isTargetingMineableBlock() {
        class_1799 itemStack;
        String id;
        if (!BetterCombatClientMod.config.isMiningWithWeaponsEnabled) {
            return false;
        }
        String regex = BetterCombatClientMod.config.mineWithWeaponBlacklist;
        if (regex != null && !regex.isEmpty() && PatternMatching.matches(id = class_7923.field_41178.method_10221((Object)(itemStack = this.field_1724.method_6047()).method_7909()).toString(), regex)) {
            return false;
        }
        if (BetterCombatClientMod.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled && this.hasTargetsInReach()) {
            return false;
        }
        class_310 client = this.thisClient();
        class_239 crosshairTarget = client.field_1765;
        if (crosshairTarget != null && crosshairTarget.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)crosshairTarget;
            class_2338 pos = blockHitResult.method_17777();
            class_2680 clicked = this.field_1687.method_8320(pos);
            if (this.shouldSwingThruGrass()) {
                if (!clicked.method_26220((class_1922)this.field_1687, pos).method_1110() || clicked.method_26214((class_1922)this.field_1687, pos) != 0.0f) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean shouldSwingThruGrass() {
        if (!BetterCombatClientMod.config.isSwingThruGrassEnabled) {
            return false;
        }
        if (BetterCombatClientMod.config.isSwingThruGrassSmart && !this.hasTargetsInReach()) {
            return false;
        }
        String regex = BetterCombatClientMod.config.swingThruGrassBlacklist;
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        class_1799 itemStack = this.field_1724.method_6047();
        String id = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        return !PatternMatching.matches(id, regex);
    }

    @Unique
    private int currentTime() {
        if (this.field_1724 == null) {
            return 0;
        }
        return this.field_1724.field_6012;
    }

    @Unique
    private int currentUpswingTicks() {
        if (this.ongoingSwing == null) {
            return 0;
        }
        return this.ongoingSwing.upswingTicksLeft(this.currentTime());
    }

    private void startUpswing(WeaponAttributes attributes) {
        if (this.field_1724.method_3144()) {
            return;
        }
        AttackHand attackHand = this.getCurrentHand();
        if (attackHand == null) {
            return;
        }
        float upswingRate = (float)attackHand.upswingRate();
        if (this.currentUpswingTicks() > 0 || this.field_1771 > 0 || this.field_1724.method_6115() || (double)this.field_1724.method_7261(0.0f) < 1.0 - (double)upswingRate) {
            return;
        }
        this.field_1724.method_6075();
        this.lastAttacked = 0;
        this.upswingStack = this.field_1724.method_6047();
        float attackCooldownTicksFloat = PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724);
        int attackCooldownTicks = Math.round(attackCooldownTicksFloat);
        this.comboReset = Math.round(attackCooldownTicksFloat * BetterCombatMod.config.combo_reset_rate);
        int upswingTicks = Math.max(Math.round(attackCooldownTicksFloat * upswingRate), 1);
        this.ongoingSwing = new WeaponSwing(attackHand, this.currentTime(), upswingTicks, attackCooldownTicksFloat);
        this.lastSwingDuration = attackCooldownTicksFloat;
        this.field_1752 = attackCooldownTicks;
        this.setMiningCooldown(attackCooldownTicks);
        String animationName = attackHand.attack().animation();
        boolean isOffHand = attackHand.isOffHand();
        AnimatedHand animatedHand = AnimatedHand.from(isOffHand, attributes.isTwoHanded());
        ((PlayerAttackAnimatable)this.field_1724).playAttackAnimation(animationName, animatedHand, attackCooldownTicksFloat, upswingRate);
        List<ParticlePlacement> particles = SlashParticleUtil.trailParticlesFromAttack(attackHand);
        TrailAppearance appearance = SlashParticleUtil.appearanceFromItemStack(attackHand.itemStack());
        Packets.AttackAnimation packet = new Packets.AttackAnimation(this.field_1724.method_5628(), animatedHand, animationName, attackCooldownTicksFloat, upswingRate, (float)PlayerAttackHelper.getStaticRange((class_1657)this.field_1724, attackHand.itemStack()), upswingTicks, new Packets.SwingParticles(particles, appearance));
        Platform.networkC2S_Send(packet);
        BetterCombatClientEvents.ATTACK_START.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, attackHand));
    }

    private void cancelSwingIfNeeded() {
        if (this.upswingStack != null && !MinecraftClientInject.areItemStackEqual(this.field_1724.method_6047(), this.upswingStack)) {
            this.cancelWeaponSwing();
            return;
        }
    }

    private void attackFromUpswingIfNeeded() {
        if (this.ongoingSwing != null && this.currentUpswingTicks() == 0) {
            this.performAttack();
            this.upswingStack = null;
        }
    }

    private void resetComboIfNeeded() {
        if (this.lastAttacked > this.comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!PlayerAttackHelper.shouldAttackWithOffHand((class_1657)this.field_1724, this.getComboCount()) && (this.field_1724.method_6047() == null || this.lastAttacedWithItemStack != null && !this.lastAttacedWithItemStack.method_7909().equals(this.field_1724.method_6047().method_7909()))) {
            this.setComboCount(0);
        }
    }

    private boolean shouldUpdateTargetsInReach() {
        if (BetterCombatClientMod.config.isHighlightCrosshairEnabled || BetterCombatClientMod.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled) {
            return this.targetsInReach == null;
        }
        return false;
    }

    private void updateTargetsInReach(List<class_1297> targets) {
        this.targetsInReach = targets;
    }

    private void updateTargetsIfNeeded() {
        if (this.shouldUpdateTargetsInReach()) {
            List<class_1297> targets = List.of();
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
            if (hand != null) {
                WeaponAttributes attributes = WeaponRegistry.getAttributes(hand.itemStack());
                double range = PlayerAttackHelper.getRangeForItem((class_1657)this.field_1724, hand.itemStack());
                range *= (double)hand.attack().rangeMultiplier();
                if (attributes != null && attributes.attacks() != null) {
                    targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, this.getCursorTarget(), hand.attack(), range);
                }
            }
            this.updateTargetsInReach(targets);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        this.targetsInReach = null;
        ++this.lastAttacked;
        if (this.ongoingSwing != null && this.ongoingSwing.ticksLeft(this.currentTime()) <= 0) {
            this.ongoingSwing = null;
        }
        this.cancelSwingIfNeeded();
        this.attackFromUpswingIfNeeded();
        this.updateTargetsIfNeeded();
        this.resetComboIfNeeded();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        if (Keybindings.toggleMineKeyBinding.method_1436()) {
            BetterCombatClientMod.config.isMiningWithWeaponsEnabled = !BetterCombatClientMod.config.isMiningWithWeaponsEnabled;
            AutoConfig.getConfigHolder(ClientConfigWrapper.class).save();
            String message = class_1074.method_4662((String)(BetterCombatClientMod.config.isMiningWithWeaponsEnabled ? "hud.bettercombat.mine_with_weapons_on" : "hud.bettercombat.mine_with_weapons_off"), (Object[])new Object[0]);
            this.field_1705.method_1758((class_2561)class_2561.method_43470((String)message), false);
        }
    }

    private void performAttack() {
        if (Keybindings.feintKeyBinding.method_1434()) {
            this.field_1724.method_7350();
            this.cancelWeaponSwing();
            return;
        }
        WeaponSwing weaponSwing = this.ongoingSwing;
        if (weaponSwing == null) {
            return;
        }
        AttackHand hand = weaponSwing.attackHand();
        if (hand == null) {
            return;
        }
        WeaponAttributes.Attack attack = hand.attack();
        double upswingRate = hand.upswingRate();
        if ((double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            return;
        }
        class_1297 cursorTarget = this.getCursorTarget();
        double range = PlayerAttackHelper.getRangeForItem((class_1657)this.field_1724, hand.itemStack());
        List<class_1297> targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, cursorTarget, attack, range *= (double)hand.attack().rangeMultiplier());
        this.updateTargetsInReach(targets);
        if (targets.size() == 0) {
            PlatformClient.onEmptyLeftClick((class_1657)this.field_1724);
            if (this.field_1765.method_17783() == class_239.class_240.field_1332) {
                class_3965 blockHitResult = (class_3965)this.field_1765;
                class_2338 pos = blockHitResult.method_17777();
                Packets.C2S_BlockHit packet = new Packets.C2S_BlockHit(pos);
                Platform.networkC2S_Send(packet);
            }
        }
        Packets.C2S_AttackRequest packet = new Packets.C2S_AttackRequest(this.getComboCount(), this.field_1724.method_5715(), this.field_1724.method_31548().field_7545, cursorTarget, targets);
        Platform.networkC2S_Send(packet);
        for (class_1297 target : targets) {
            this.field_1724.method_7324(target);
        }
        this.field_1724.method_7350();
        BetterCombatClientEvents.ATTACK_HIT.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, hand, targets, cursorTarget));
        List<ParticlePlacement> particles = SlashParticleUtil.trailParticlesFromAttack(hand);
        TrailAppearance appearance = SlashParticleUtil.appearanceFromItemStack(hand.itemStack());
        SlashParticleUtil.spawnParticles((class_742)this.field_1724, hand.isOffHand(), (float)PlayerAttackHelper.getStaticRange((class_1657)this.field_1724, hand.itemStack()), particles, appearance);
        this.setComboCount(this.getComboCount() + 1);
        if (!hand.isOffHand()) {
            this.lastAttacedWithItemStack = hand.itemStack();
        }
    }

    private AttackHand getCurrentHand() {
        return PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
    }

    private void setComboCount(int comboCount) {
        ((PlayerAttackProperties)this.field_1724).setComboCount(comboCount);
    }

    private static boolean areItemStackEqual(class_1799 left, class_1799 right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return class_1799.method_7973((class_1799)left, (class_1799)right);
    }

    private void setMiningCooldown(int ticks) {
        class_310 client = this.thisClient();
        ((MinecraftClientAccessor)client).setAttackCooldown(ticks);
    }

    private void cancelWeaponSwing() {
        int downWind = (int)Math.round((double)PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724) * (1.0 - 0.5 * (double)BetterCombatMod.config.upswing_multiplier));
        ((PlayerAttackAnimatable)this.field_1724).stopAttackAnimation(downWind);
        Packets.AttackAnimation packet = Packets.AttackAnimation.stop(this.field_1724.method_5628(), downWind);
        Platform.networkC2S_Send(packet);
        this.upswingStack = null;
        this.ongoingSwing = null;
        this.field_1752 = 0;
        this.setMiningCooldown(0);
    }

    @Override
    public int getComboCount() {
        return ((PlayerAttackProperties)this.field_1724).getComboCount();
    }

    @Override
    public boolean hasTargetsInReach() {
        return this.targetsInReach != null && !this.targetsInReach.isEmpty();
    }

    @Override
    public float getSwingProgress() {
        if ((float)this.lastAttacked > this.lastSwingDuration || this.lastSwingDuration <= 0.0f) {
            return 1.0f;
        }
        return (float)this.lastAttacked / this.lastSwingDuration;
    }

    @Override
    public int getUpswingTicks() {
        return this.currentUpswingTicks();
    }

    @Override
    public void cancelUpswing() {
        if (this.currentUpswingTicks() > 0) {
            this.cancelWeaponSwing();
        }
    }

    @Override
    public AttackHand getCurrentAttackHand() {
        if (this.ongoingSwing != null) {
            return this.ongoingSwing.attackHand();
        }
        return null;
    }
}

