/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import snownee.kiwi.Kiwi;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.resource.AlternativesFileToIdConverter;

public class OneTimeLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public static <T> Map<class_2960, T> load(class_3300 resourceManager, String directory, Codec<T> codec) {
        return OneTimeLoader.load(resourceManager, directory, codec, $ -> true);
    }

    public static <T> Map<class_2960, T> load(class_3300 resourceManager, String directory, Codec<T> codec, Predicate<class_2960> listFilter) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory).setListFilter(listFilter);
        HashMap results = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            DataResult<T> result = OneTimeLoader.parseFile(entry.getKey(), entry.getValue(), codec);
            if (result.error().isPresent()) {
                Kiwi.LOGGER.error("Failed to parse " + String.valueOf(entry.getKey()) + ": " + String.valueOf(result.error().get()));
                continue;
            }
            class_2960 id = fileToIdConverter.fileToId(entry.getKey());
            results.put(id, result.result().orElseThrow());
        }
        return results;
    }

    public static <T> T loadFile(class_3300 resourceManager, String directory, class_2960 id, Codec<T> codec) {
        AlternativesFileToIdConverter fileToIdConverter = AlternativesFileToIdConverter.yamlOrJson(directory);
        class_2960 file = fileToIdConverter.idToFile(id);
        Optional resource = resourceManager.method_14486(file);
        if (resource.isEmpty()) {
            return null;
        }
        DataResult<T> result = OneTimeLoader.parseFile(file, (class_3298)resource.get(), codec);
        if (result.error().isPresent()) {
            Kiwi.LOGGER.error("Failed to parse " + String.valueOf(file) + ": " + String.valueOf(result.error().get()));
            return null;
        }
        return result.result().orElseThrow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> DataResult<T> parseFile(class_2960 file, class_3298 resource, Codec<T> codec) {
        String ext = file.method_12832().substring(file.method_12832().length() - 5);
        try (BufferedReader reader = resource.method_43039();){
            DataResult result;
            if (ext.equals(".json")) {
                result = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class)));
            } else {
                if (!ext.equals(".yaml")) {
                    DataResult dataResult2 = DataResult.error(() -> "Unknown extension: " + ext);
                    return dataResult2;
                }
                result = codec.parse((DynamicOps)JavaOps.INSTANCE, KUtil.loadYaml(reader, Object.class));
            }
            DataResult dataResult = result;
            return dataResult;
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to load " + String.valueOf(file) + ": " + String.valueOf(e));
        }
    }
}

