/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1856;

public class IngredientCodecs {
    public static MapCodec<class_1856> NON_EMPTY_MAP_CODEC = null;
    public static MapCodec<class_1856.class_1859> VALUE_MAP_CODEC = null;
    public static MapCodec<class_1856.class_1857> ITEM_VALUE_MAP_CODEC = null;
    public static MapCodec<class_1856.class_1858> TAG_VALUE_MAP_CODEC = null;

    public static <A, E, B> MapCodec<Either<E, B>> dispatchMapOrElse(Codec<A> typeCodec, final String typeKey, Function<? super E, ? extends A> type, Function<? super A, ? extends MapCodec<? extends E>> codec, final MapCodec<B> fallbackCodec) {
        final MapCodec dispatchCodec = typeCodec.dispatchMap(typeKey, type, codec);
        return new MapCodec<Either<E, B>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.concat(dispatchCodec.keys(ops), fallbackCodec.keys(ops)).distinct();
            }

            public <T> DataResult<Either<E, B>> decode(DynamicOps<T> ops, MapLike<T> input) {
                if (input.get(typeKey) != null) {
                    return dispatchCodec.decode(ops, input).map(Either::left);
                }
                return fallbackCodec.decode(ops, input).map(Either::right);
            }

            public <T> RecordBuilder<T> encode(Either<E, B> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return (RecordBuilder)input.map(dispatched -> dispatchCodec.encode(dispatched, ops, prefix), fallback -> fallbackCodec.encode(fallback, ops, prefix));
            }

            public String toString() {
                return "DispatchOrElse[" + String.valueOf(dispatchCodec) + ", " + String.valueOf(fallbackCodec) + "]";
            }
        };
    }

    public static <F, S> MapCodec<Either<F, S>> xor(MapCodec<F> first, MapCodec<S> second) {
        return new XorMapCodec<F, S>(first, second);
    }

    private static final class XorMapCodec<F, S>
    extends MapCodec<Either<F, S>> {
        private final MapCodec<F> first;
        private final MapCodec<S> second;

        private XorMapCodec(MapCodec<F> first, MapCodec<S> second) {
            this.first = first;
            this.second = second;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(this.first.keys(ops), this.second.keys(ops)).distinct();
        }

        public <T> DataResult<Either<F, S>> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult firstResult = this.first.decode(ops, input).map(Either::left);
            DataResult secondResult = this.second.decode(ops, input).map(Either::right);
            Optional firstValue = firstResult.result();
            Optional secondValue = secondResult.result();
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, cannot pick the correct one; first: " + String.valueOf(firstValue.get()) + " second: " + String.valueOf(secondValue.get()), (Object)((Either)firstValue.get()));
            }
            if (firstValue.isPresent()) {
                return firstResult;
            }
            if (secondValue.isPresent()) {
                return secondResult;
            }
            return firstResult.apply2((x, y) -> y, secondResult);
        }

        public <T> RecordBuilder<T> encode(Either<F, S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return (RecordBuilder)input.map(x -> this.first.encode(x, ops, prefix), x -> this.second.encode(x, ops, prefix));
        }

        public String toString() {
            return "XorMapCodec[" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + "]";
        }
    }
}

