/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.DumperOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.LoaderOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.Yaml;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.constructor.Constructor;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.error.YAMLException;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.Node;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.NodeId;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.SequenceNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.representer.Representer;

public final class KUtil {
    public static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,number,0.#}");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    private static final Yaml YAML;
    private static class_1863 recipeManager;
    public static final List<class_2350> DIRECTIONS;

    private KUtil() {
    }

    public static String formatComma(long number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static String formatCompact(long number) {
        int unit = 1000;
        if (number < (long)unit) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(unit));
        if (exp - 1 >= 0 && exp - 1 < 6) {
            char pre = "kMGTPE".charAt(exp - 1);
            return MESSAGE_FORMAT.format(new Double[]{(double)number / Math.pow(unit, exp)}) + pre;
        }
        return Long.toString(number);
    }

    public static String trimRL(class_2960 rl) {
        return KUtil.trimRL(rl, "minecraft");
    }

    public static String trimRL(String rl) {
        return KUtil.trimRL(rl, "minecraft");
    }

    public static String trimRL(class_2960 rl, String defaultNamespace) {
        return rl.method_12836().equals(defaultNamespace) ? rl.method_12832() : rl.toString();
    }

    public static String trimRL(String rl, String defaultNamespace) {
        if (rl.startsWith(defaultNamespace + ":")) {
            return rl.substring(defaultNamespace.length() + 1);
        }
        return rl;
    }

    @Nullable
    public static class_2960 RL(@Nullable String string) {
        try {
            return class_2960.method_12829((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static class_2960 RL(@Nullable String string, String defaultNamespace) {
        if (string != null && !((String)string).contains(":")) {
            string = defaultNamespace + ":" + (String)string;
        }
        return KUtil.RL((String)string);
    }

    @Nullable
    public static class_1863 getRecipeManager() {
        class_634 connection;
        if (recipeManager == null && Platform.isPhysicalClient() && (connection = class_310.method_1551().method_1562()) != null) {
            return connection.method_2877();
        }
        return recipeManager;
    }

    public static void setRecipeManager(class_1863 recipeManager) {
        KUtil.recipeManager = recipeManager;
    }

    public static <I extends class_9695, T extends class_1860<I>> List<class_8786<T>> getRecipes(class_3956<T> recipeTypeIn) {
        class_1863 manager = KUtil.getRecipeManager();
        if (manager == null) {
            return List.of();
        }
        return KUtil.getRecipeManager().method_30027(recipeTypeIn);
    }

    public static int friendlyCompare(String a, String b) {
        int aLength = a.length();
        int bLength = b.length();
        int minSize = Math.min(aLength, bLength);
        boolean asNumeric = false;
        int lastNumericCompare = 0;
        for (int i = 0; i < minSize; ++i) {
            boolean bNumber;
            char aChar = a.charAt(i);
            char bChar = b.charAt(i);
            boolean aNumber = aChar >= '0' && aChar <= '9';
            boolean bl = bNumber = bChar >= '0' && bChar <= '9';
            if (asNumeric) {
                if (aNumber && bNumber) {
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aNumber) {
                    return 1;
                }
                if (bNumber) {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    if (aChar != bChar) {
                        return aChar - bChar;
                    }
                    asNumeric = false;
                    continue;
                }
                return lastNumericCompare;
            }
            if (aNumber && bNumber) {
                asNumeric = true;
                if (lastNumericCompare != 0) continue;
                lastNumericCompare = aChar - bChar;
                continue;
            }
            if (aChar == bChar) continue;
            return aChar - bChar;
        }
        if (asNumeric) {
            if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                return 1;
            }
            if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                return -1;
            }
            if (lastNumericCompare == 0) {
                return aLength - bLength;
            }
            return lastNumericCompare;
        }
        return aLength - bLength;
    }

    public static String friendlyText(String s) {
        StringBuilder sb = new StringBuilder();
        MutableBoolean lastIsUpper = new MutableBoolean(true);
        MutableBoolean nextIsUpper = new MutableBoolean(true);
        s.codePoints().forEach(ch -> {
            if (ch == 95 || ch == 46) {
                sb.append(' ');
                nextIsUpper.setTrue();
                return;
            }
            if (Character.isUpperCase(ch) && lastIsUpper.isFalse()) {
                sb.append(' ');
            } else if (Character.isLowerCase(ch)) {
                if (nextIsUpper.isTrue()) {
                    ch = Character.toUpperCase(ch);
                } else if (lastIsUpper.isTrue() && sb.length() > 1 && Character.isUpperCase(sb.codePointAt(sb.length() - 2))) {
                    sb.insert(sb.length() - 1, ' ');
                }
            }
            lastIsUpper.setValue(Character.isUpperCase(ch));
            nextIsUpper.setFalse();
            sb.appendCodePoint(ch);
        });
        return sb.toString();
    }

    public static boolean canPlayerBreak(class_1657 player, class_2680 state, class_2338 pos) {
        if (!player.method_7294() || !player.method_37908().method_8505(player, pos)) {
            return false;
        }
        return player.method_7337() || !(state.method_26165(player, (class_1922)player.method_37908(), pos) <= 0.0f);
    }

    public static int applyAlpha(int color, float alpha) {
        int alphaChannel;
        int prevAlphaChannel = color >> 24 & 0xFF;
        if (prevAlphaChannel > 0) {
            alpha *= (float)prevAlphaChannel / 256.0f;
        }
        if ((alphaChannel = (int)(255.0f * class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f))) < 5) {
            return 0;
        }
        return color & 0xFFFFFF | alphaChannel << 24;
    }

    public static void displayClientMessage(@Nullable class_1657 player, boolean client, String key, Object ... args) {
        if (player == null) {
            return;
        }
        if (client != player.method_37908().field_9236) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43469((String)key, (Object[])args));
    }

    public static class_1269 onAttackEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_1799 stack;
        class_1533 frame;
        if (entity instanceof class_1533 && !(frame = (class_1533)entity).method_6940().method_7960() && !frame.method_5740() && !frame.method_5655() && (stack = player.method_5998(hand)).method_31574(class_1802.field_8827)) {
            frame.method_5648(!frame.method_5767());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static class_5250 clickToCopy(class_5250 component) {
        String str = component.getString();
        return component.method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_21462, str)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))).method_10975(str));
    }

    public static <T> T loadYaml(String yaml, Class<? super T> type) {
        return YAML.loadAs(yaml, type);
    }

    public static <T> T loadYaml(Reader reader, Class<? super T> type) {
        return YAML.loadAs(reader, type);
    }

    public static void dumpYaml(Object object, Writer writer) {
        YAML.dump(object, writer);
    }

    static {
        DIRECTIONS = class_2350.method_42013().toList();
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        YAML = new Yaml(new ResafeConstructor(new LoaderOptions()), new Representer(dumperOptions), dumperOptions);
    }

    public static class ResafeConstructor
    extends Constructor {
        public ResafeConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
            this.yamlClassConstructors.put(NodeId.scalar, undefinedConstructor);
            this.yamlClassConstructors.put(NodeId.mapping, new ConstructSafeMapping());
            this.yamlClassConstructors.put(NodeId.sequence, new ConstructSafeSequence());
        }

        private class ConstructSafeMapping
        extends Constructor.ConstructMapping {
            private ConstructSafeMapping() {
            }

            @Override
            public Object construct(Node node) {
                MappingNode mnode = (MappingNode)node;
                if (node.isTwoStepsConstruction()) {
                    return ResafeConstructor.this.newMap(mnode);
                }
                return ResafeConstructor.this.constructMapping(mnode);
            }

            @Override
            public void construct2ndStep(Node node, Object object) {
                ResafeConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
            }
        }

        private class ConstructSafeSequence
        extends Constructor.ConstructSequence {
            private ConstructSafeSequence() {
            }

            @Override
            public Object construct(Node node) {
                SequenceNode snode = (SequenceNode)node;
                if (Set.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        throw new YAMLException("Set cannot be recursive.");
                    }
                    return ResafeConstructor.this.constructSet(snode);
                }
                if (Collection.class.isAssignableFrom(node.getType())) {
                    if (node.isTwoStepsConstruction()) {
                        return ResafeConstructor.this.newList(snode);
                    }
                    return ResafeConstructor.this.constructSequence(snode);
                }
                if (node.isTwoStepsConstruction()) {
                    return ResafeConstructor.this.createArray(node.getType(), snode.getValue().size());
                }
                return ResafeConstructor.this.constructArray(snode);
            }
        }
    }
}

