/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KUtil;

public final class TooltipEvents {
    public static final String disableDebugTooltipCommand = "@kiwi disable debugTooltip";
    private static final DebugTooltipCache cache = new DebugTooltipCache();
    private static boolean firstSeenDebugTooltip = true;
    private static long latestPressF3;
    private static boolean holdAlt;
    private static long holdAltStart;
    private static boolean showTagsBeforeAlt;

    private TooltipEvents() {
    }

    public static void globalTooltip(class_1799 stack, List<class_2561> tooltip, class_1836 flag) {
        if (KiwiClientConfig.globalTooltip) {
            ModItem.addTip(stack, tooltip, flag);
        }
    }

    public static void debugTooltip(class_1799 itemStack, List<class_2561> tooltip, class_1836 flag) {
        if (!flag.method_8035()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        long millis = class_156.method_658();
        if (KiwiClientConfig.f3CopyInInventory && mc.field_1724 != null && millis - latestPressF3 > 500L && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)292)) {
            latestPressF3 = millis;
            class_5250 component = class_2561.method_43470((String)class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString());
            mc.field_1774.method_1455(component.getString());
            mc.field_1724.method_7353((class_2561)KUtil.clickToCopy(component), false);
        }
        if (KiwiClientConfig.hideDataComponentsTooltip) {
            tooltip.removeIf(c -> c.method_10851() instanceof class_2588 && "item.components".equals(((class_2588)c.method_10851()).method_11022()));
        }
        if (KiwiClientConfig.tagsTooltip) {
            cache.maybeUpdateTags(itemStack);
            boolean alt = class_437.method_25443();
            if (!holdAlt && alt) {
                holdAltStart = millis;
                showTagsBeforeAlt = TooltipEvents.cache.showTags;
            } else if (holdAlt && !alt && TooltipEvents.cache.showTags && millis - holdAltStart < 500L) {
                TooltipEvents.cache.pageNow = TooltipEvents.cache.pageNow + (class_437.method_25441() ? -1 : 1);
                TooltipEvents.cache.needUpdatePreferredType = true;
            }
            if (alt && millis - holdAltStart >= 500L) {
                TooltipEvents.cache.showTags = !showTagsBeforeAlt;
                TooltipEvents.cache.lastShowTags = millis;
            }
            holdAlt = alt;
            if (!TooltipEvents.cache.pages.isEmpty()) {
                TooltipEvents.trySendTipMsg(mc);
                cache.appendTagsTooltip(tooltip);
            }
        }
    }

    private static void trySendTipMsg(class_310 mc) {
        if (firstSeenDebugTooltip && mc.field_1724 != null) {
            firstSeenDebugTooltip = false;
            if (KiwiClientConfig.debugTooltipMsg) {
                class_5250 clickHere = class_2561.method_43471((String)"tip.kiwi.click_here").method_27694($ -> $.method_10958(new class_2558(class_2558.class_2559.field_21462, disableDebugTooltipCommand)));
                mc.field_1724.method_43496((class_2561)class_2561.method_43469((String)"tip.kiwi.debug_tooltip", (Object[])new Object[]{clickHere.method_27692(class_124.field_1075)}));
                KiwiClientConfig.debugTooltipMsg = false;
                KiwiConfigManager.getHandler(KiwiClientConfig.class).save();
            }
        }
    }

    private static class DebugTooltipCache {
        private final List<String> pageTypes = Lists.newArrayList();
        private final List<List<String>> pages = Lists.newArrayList();
        private final List<List<String>> translatedPages = Lists.newArrayList();
        private int pageNow = 0;
        private class_1799 itemStack = class_1799.field_8037;
        private boolean showTags;
        private long lastShowTags;
        private String preferredType;
        public boolean needUpdatePreferredType;

        private DebugTooltipCache() {
        }

        public void maybeUpdateTags(class_1799 itemStack) {
            if (this.itemStack == itemStack) {
                return;
            }
            this.itemStack = itemStack;
            this.pages.clear();
            this.translatedPages.clear();
            this.pageTypes.clear();
            this.pageNow = 0;
            this.addPages("item", itemStack.method_40133());
            class_1792 item = itemStack.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            if (block != class_2246.field_10124) {
                this.addPages("block", DebugTooltipCache.getTags(class_7923.field_41175, block));
            }
            if (item instanceof class_1826) {
                class_1826 spawnEggItem = (class_1826)item;
                class_1299 type = spawnEggItem.method_8015(itemStack);
                this.addPages("entity_type", DebugTooltipCache.getTags(class_7923.field_41177, type));
            } else if (item instanceof class_1755) {
                class_1755 bucketItem = (class_1755)item;
                this.addPages("fluid", DebugTooltipCache.getTags(class_7923.field_41173, Platform.getFluidFromBucket(bucketItem)));
            }
            for (int i = 0; i < this.pages.size(); ++i) {
                if (!this.pageTypes.get(i).equals(this.preferredType)) continue;
                this.pageNow = i;
                break;
            }
        }

        private static <T> Stream<class_6862<T>> getTags(class_2378<T> registry, T object) {
            return registry.method_29113(object).flatMap(arg_0 -> registry.method_40264(arg_0)).stream().flatMap(class_6880::method_40228);
        }

        public void addPages(String type, Stream<? extends class_6862<?>> stream) {
            List<class_6862> tags = stream.sorted(Comparator.comparing($ -> $.comp_327())).toList();
            if (tags.isEmpty()) {
                return;
            }
            int i = 0;
            ArrayList page = Lists.newArrayList();
            ArrayList translatedPage = Lists.newArrayList();
            for (class_6862 tag : tags) {
                page.add("#" + String.valueOf(tag.comp_327()));
                String translationKey = Platform.getTagTranslationKey(tag);
                if (class_1074.method_4663((String)translationKey)) {
                    translatedPage.add("#" + class_1074.method_4662((String)translationKey, (Object[])new Object[0]));
                } else {
                    translatedPage.add("#" + String.valueOf(tag.comp_327()));
                }
                if (++i != KiwiClientConfig.tagsTooltipTagsPerPage) continue;
                this.pages.add(page);
                this.translatedPages.add(translatedPage);
                this.pageTypes.add(type);
                page = Lists.newArrayList();
                translatedPage = Lists.newArrayList();
                i = 0;
            }
            if (!page.isEmpty()) {
                this.pages.add(page);
                this.translatedPages.add(translatedPage);
                this.pageTypes.add(type);
            }
        }

        public void appendTagsTooltip(List<class_2561> tooltip) {
            boolean showTranslatedTags;
            if (this.pages.isEmpty()) {
                return;
            }
            if (this.showTags && class_156.method_658() - this.lastShowTags > 60000L) {
                this.showTags = false;
            }
            if (!this.showTags) {
                if (KiwiClientConfig.tagsTooltipAppendKeybindHint) {
                    this.findIdLine(tooltip, i -> tooltip.set(i, (class_2561)((class_2561)tooltip.get(i)).method_27661().method_27693(" (alt)")));
                }
                return;
            }
            this.lastShowTags = class_156.method_658();
            ArrayList sub = Lists.newArrayList();
            this.pageNow = Math.floorMod(this.pageNow, this.pages.size());
            if (this.needUpdatePreferredType) {
                this.needUpdatePreferredType = false;
                this.preferredType = this.pageTypes.get(this.pageNow);
            }
            List<String> page = (showTranslatedTags = KiwiClientConfig.showTranslatedTagsByDefault ^ class_437.method_25441()) ? this.translatedPages.get(this.pageNow) : this.pages.get(this.pageNow);
            for (String tag : page) {
                sub.add(class_2561.method_43470((String)tag).method_27692(class_124.field_1063));
            }
            int index = this.findIdLine(tooltip, i -> {
                String type = this.pageTypes.get(this.pageNow);
                tooltip.set(i, (class_2561)((class_2561)tooltip.get(i)).method_27661().method_27693(" (%s/%s...%s)".formatted(this.pageNow + 1, this.pages.size(), type)));
            });
            index = index == -1 ? tooltip.size() : index + 1;
            tooltip.addAll(index, sub);
        }

        private int findIdLine(List<class_2561> tooltip, IntConsumer consumer) {
            String id = class_7923.field_41178.method_10221((Object)this.itemStack.method_7909()).toString();
            for (int i = 0; i < tooltip.size(); ++i) {
                class_2561 component = tooltip.get(i);
                if (!component.getString().equals(id)) continue;
                consumer.accept(i);
                return i;
            }
            return -1;
        }
    }
}

