/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_5444;
import net.minecraft.class_5819;
import net.minecraft.class_5843;
import net.minecraft.class_5868;
import net.minecraft.class_6661;
import net.minecraft.class_6798;

public class HeightRangeFilter
extends class_6661 {
    public static final MapCodec<HeightRangeFilter> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)VerticalProvider.CODEC.listOf().optionalFieldOf("below", List.of()).forGetter(p -> p.below), (App)VerticalProvider.CODEC.listOf().optionalFieldOf("above", List.of()).forGetter(p -> p.above)).apply((Applicative)i, HeightRangeFilter::new));
    private final List<VerticalProvider> below;
    private final List<VerticalProvider> above;

    private HeightRangeFilter(List<VerticalProvider> below, List<VerticalProvider> above) {
        this.below = below;
        this.above = above;
    }

    protected boolean method_38918(class_5444 context, class_5819 random, class_2338 pos) {
        int limitY;
        for (VerticalProvider provider : this.below) {
            limitY = provider.resolveY(context, pos.method_10263(), pos.method_10260());
            if (pos.method_10264() <= limitY) continue;
            return false;
        }
        for (VerticalProvider provider : this.above) {
            limitY = provider.resolveY(context, pos.method_10263(), pos.method_10260());
            if (pos.method_10264() >= limitY) continue;
            return false;
        }
        return true;
    }

    public class_6798<?> method_39615() {
        return MoonlightRegistry.HEIGHT_RANGE.get();
    }

    private static interface VerticalProvider {
        public static final CodecMapRegistry<VerticalProvider> REG = (CodecMapRegistry)class_156.method_656(() -> {
            CodecMapRegistry reg = new CodecMapRegistry("vertical_providers");
            reg.register("anchor", Anchor.CODEC);
            reg.register("sea_level", SeaLevelAnchor.CODEC);
            reg.register("heightmap", HeightmapAnchor.CODEC);
            return reg;
        });
        public static final Codec<VerticalProvider> CODEC = REG.dispatch(VerticalProvider::getCodec);

        public int resolveY(class_5444 var1, int var2, int var3);

        public MapCodec<? extends VerticalProvider> getCodec();
    }

    public record HeightmapAnchor(class_2902.class_2903 heightmap, int offset) implements VerticalProvider
    {
        public static final MapCodec<HeightmapAnchor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2902.class_2903.field_24772.fieldOf("heightmap").forGetter(HeightmapAnchor::heightmap), (App)Codec.INT.fieldOf("offset").forGetter(HeightmapAnchor::offset)).apply((Applicative)instance, HeightmapAnchor::new));

        @Override
        public int resolveY(class_5444 context, int x, int z) {
            return context.method_30460(this.heightmap, x, z) + this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " from heightmap " + String.valueOf(this.heightmap);
        }

        public MapCodec<HeightmapAnchor> getCodec() {
            return CODEC;
        }
    }

    public record SeaLevelAnchor(int offset) implements VerticalProvider
    {
        public static final MapCodec<SeaLevelAnchor> CODEC = Codec.INT.fieldOf("offset").xmap(SeaLevelAnchor::new, SeaLevelAnchor::offset);

        @Override
        public int resolveY(class_5444 context, int x, int z) {
            return context.method_34383().method_8615() + this.offset;
        }

        @Override
        public String toString() {
            return this.offset + " from sea level";
        }

        public MapCodec<SeaLevelAnchor> getCodec() {
            return CODEC;
        }
    }

    public record Anchor(class_5843 anchor) implements VerticalProvider
    {
        public static final MapCodec<Anchor> CODEC = class_5843.field_28915.fieldOf("anchor").xmap(Anchor::new, Anchor::anchor);

        @Override
        public int resolveY(class_5444 context, int x, int z) {
            return this.anchor.method_33844((class_5868)context);
        }

        @Override
        public String toString() {
            return this.anchor.toString();
        }

        public MapCodec<Anchor> getCodec() {
            return CODEC;
        }
    }
}

