/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.BlockAndItem;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.ColorSetModification;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7654;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlocksColorInternal
extends class_4080<List<JsonElement>> {
    public static final BlocksColorInternal INSTANCE = new BlocksColorInternal();
    public static final List<class_1767> VANILLA_COLORS = List.of(class_1767.field_7952, class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963);
    public static final List<class_1767> MODDED_COLORS = List.of((class_1767[])Arrays.stream(class_1767.values()).filter(v -> !VANILLA_COLORS.contains(v)).toArray(class_1767[]::new));
    private static final List<String> KNOWN_COLOR_MODS = Stream.of("tinted", "dye_depot", "dyenamics", "delicate_dyes", "mint").filter(PlatHelper::isModLoaded).toList();
    private State defaultState;
    private State state;
    private final Gson gson = new Gson();

    protected List<JsonElement> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<JsonElement> output = new ArrayList<JsonElement>();
        String directory = "color_sets";
        class_7654 filetoidconverter = class_7654.method_45114((String)directory);
        for (Map.Entry entry : filetoidconverter.method_45116(resourceManager).entrySet()) {
            class_2960 resourcelocation = (class_2960)entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);
            List value = (List)entry.getValue();
            for (class_3298 r : value) {
                try (BufferedReader reader = r.method_43039();){
                    JsonElement jsonelement = (JsonElement)class_3518.method_15276((Gson)this.gson, (Reader)reader, JsonElement.class);
                    output.add(jsonelement);
                }
                catch (JsonParseException | IOException | IllegalArgumentException var14) {
                    Moonlight.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)var14);
                }
            }
        }
        return output;
    }

    protected void apply(List<JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ArrayList<ColorSetModification> colorSets = new ArrayList<ColorSetModification>();
        for (JsonElement json : object) {
            try {
                ColorSetModification cs = (ColorSetModification)((Pair)ColorSetModification.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
                colorSets.add(cs);
            }
            catch (Exception ex) {
                Moonlight.LOGGER.info("Failed to load custom color set definition {}. Ignoring", (Object)json, (Object)ex);
            }
        }
        this.state = this.state.cloneModified(colorSets);
    }

    public void setup() {
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<String, class_1767> colors = new HashMap<String, class_1767>();
        VANILLA_COLORS.forEach(d -> colors.put(d.method_7792(), (class_1767)d));
        ArrayList<String> colorPriority = new ArrayList<String>(colors.keySet().stream().toList());
        Map<String, ColoredSet<class_2248>> blockSets = this.scanRegistryAndDetectSets((Map<String, class_1767>)colors, (List<String>)colorPriority, (class_2378)class_7923.field_41175);
        Map<String, ColoredSet<class_1792>> itemSets = this.scanRegistryAndDetectSets((Map<String, class_1767>)colors, (List<String>)colorPriority, (class_2378)class_7923.field_41178);
        this.state = this.defaultState = new State(blockSets, itemSets);
        Moonlight.LOGGER.info("Initialized color sets in {}ms", (Object)sw.elapsed().toMillis());
    }

    private <T> Map<String, ColoredSet<T>> scanRegistryAndDetectSets(Map<String, class_1767> colors, List<String> colorPriority, class_2378<T> registry) {
        HashMap<class_2960, ColorSetBuilder> groupedByType = new HashMap<class_2960, ColorSetBuilder>();
        colorPriority.sort(Comparator.comparingInt(String::length));
        Collections.reverse(colorPriority);
        block0: for (Map.Entry e : registry.method_29722()) {
            class_2960 id = ((class_5321)e.getKey()).method_29177();
            String name = id.method_12832();
            if (!name.contains("_")) continue;
            for (String c : colorPriority) {
                class_2960 newId = null;
                if (name.startsWith(c + "_")) {
                    newId = id.method_45136(name.substring((c + "_").length()));
                }
                if (name.endsWith("_" + c)) {
                    newId = id.method_45136(name.substring(0, name.length() - ("_" + c).length()));
                }
                if (newId == null) continue;
                class_1767 dyeColor = colors.get(c);
                groupedByType.computeIfAbsent(newId, a -> new ColorSetBuilder()).setColor(dyeColor, e.getValue());
                continue block0;
            }
        }
        HashMap<String, ColoredSet<T>> result = new HashMap<String, ColoredSet<T>>();
        for (Map.Entry j : groupedByType.entrySet()) {
            ColorSetBuilder set = (ColorSetBuilder)j.getValue();
            class_2960 id = (class_2960)j.getKey();
            if (this.isHardcodedBlacklisted(id) || !set.hasAllVanilla()) continue;
            this.addExtraEntries(id, registry, set);
            result.put(id.toString(), set.build());
        }
        return result;
    }

    private <T> void addExtraEntries(class_2960 id, class_2378<T> registry, ColorSetBuilder<T> colorsToObj) {
        block0: for (class_1767 c : MODDED_COLORS) {
            String namespace = id.method_12836();
            String path = id.method_12832();
            for (String mod : KNOWN_COLOR_MODS) {
                for (String s : new String[]{namespace + ":" + path + "_%s", namespace + ":%s_" + path, mod + ":" + path + "_%s", mod + ":%s_" + path}) {
                    Optional o = registry.method_17966(class_2960.method_60654((String)String.format(s, c.method_7792())));
                    if (!o.isPresent()) continue;
                    colorsToObj.setColor(c, o.get());
                    continue block0;
                }
            }
        }
        Optional o = registry.method_17966(id);
        Object def = o.orElseGet(() -> registry.method_17966(class_2960.method_60654((String)id.method_12832())).orElseGet(() -> colorsToObj.getColor(class_1767.field_7952)));
        colorsToObj.setColor(null, def);
    }

    private boolean isHardcodedBlacklisted(class_2960 id) {
        String modId = id.method_12836();
        return modId.equals("energeticsheep") || modId.equals("xycraft_world") || modId.equals("botania") || modId.equals("spectrum");
    }

    @Nullable
    public class_1767 getColor(class_2248 block) {
        return (class_1767)this.state.obj2Colors.get((Object)block);
    }

    @Nullable
    public class_1767 getColor(class_1792 item) {
        return (class_1767)this.state.obj2Colors.get((Object)item);
    }

    @Nullable
    public class_1792 getColoredItem(String key, @Nullable class_1767 color) {
        ColoredSet<class_1792> set = this.getItemSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    @Nullable
    public class_2248 getColoredBlock(String key, @Nullable class_1767 color) {
        ColoredSet<class_2248> set = this.getBlockSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    public Set<String> getBlockKeys() {
        return this.state.blockColorSets.keySet();
    }

    public Set<String> getItemKeys() {
        return this.state.itemColorSets.keySet();
    }

    @Nullable
    public class_2248 changeColor(class_2248 old, @Nullable class_1767 newColor) {
        class_2248 b;
        ColoredSet<class_2248> set;
        String key = this.getKey(old);
        if (key != null && (set = this.getBlockSet(key)) != null && (b = set.with(newColor)) != old) {
            return b;
        }
        return null;
    }

    @Nullable
    public class_1792 changeColor(class_1792 old, @Nullable class_1767 newColor) {
        class_1792 i;
        ColoredSet<class_1792> set;
        String key = this.getKey(old);
        if (key != null && (set = this.getItemSet(key)) != null && (i = set.with(newColor)) != old) {
            return i;
        }
        return null;
    }

    @Nullable
    public String getKey(class_2248 block) {
        return (String)this.state.obj2Type.get((Object)block);
    }

    @Nullable
    public String getKey(class_1792 item) {
        return (String)this.state.obj2Type.get((Object)item);
    }

    @Nullable
    private ColoredSet<class_2248> getBlockSet(String key) {
        key = class_2960.method_60654((String)key).toString();
        return this.state.blockColorSets.get(key);
    }

    @Nullable
    private ColoredSet<class_1792> getItemSet(String key) {
        key = class_2960.method_60654((String)key).toString();
        return this.state.itemColorSets.get(key);
    }

    @Nullable
    public class_6885<class_2248> getBlockHolderSet(String key) {
        ColoredSet<class_2248> set = this.getBlockSet(key);
        if (set != null) {
            return set.makeHolderSet((class_2378<class_2248>)class_7923.field_41175);
        }
        return null;
    }

    @Nullable
    public class_6885<class_1792> getItemHolderSet(String key) {
        ColoredSet<class_1792> set = this.getItemSet(key);
        if (set != null) {
            return set.makeHolderSet((class_2378<class_1792>)class_7923.field_41178);
        }
        return null;
    }

    static class State {
        private final Map<String, ColoredSet<class_2248>> blockColorSets;
        private final Map<String, ColoredSet<class_1792>> itemColorSets;
        private final Object2ObjectOpenHashMap<Object, class_1767> obj2Colors = new Object2ObjectOpenHashMap();
        private final Object2ObjectOpenHashMap<Object, String> obj2Type = new Object2ObjectOpenHashMap();

        private State(Map<String, ColoredSet<class_2248>> blockColorSets, Map<String, ColoredSet<class_1792>> itemColorSets) {
            ColoredSet<class_2248> set;
            String id;
            this.blockColorSets = blockColorSets;
            this.itemColorSets = itemColorSets;
            for (Map.Entry<String, ColoredSet<class_2248>> entry : blockColorSets.entrySet()) {
                id = entry.getKey();
                set = entry.getValue();
                for (Map.Entry v : set.colorsToObj.entrySet()) {
                    this.obj2Colors.put(v.getValue(), (Object)v.getKey());
                    this.obj2Type.put(v.getValue(), (Object)id);
                }
            }
            for (Map.Entry<String, ColoredSet<class_2248>> entry : itemColorSets.entrySet()) {
                id = entry.getKey();
                set = entry.getValue();
                for (Map.Entry v : set.colorsToObj.entrySet()) {
                    this.obj2Colors.put(v.getValue(), (Object)v.getKey());
                    this.obj2Type.put(v.getValue(), (Object)id);
                }
            }
        }

        private State cloneModified(List<ColorSetModification> mods) {
            Map blockBuilder = this.blockColorSets.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ColorSetBuilder.from((ColoredSet)e.getValue()))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (ColorSetBuilder)e.getValue()), HashMap::putAll);
            Map itemBuilder = this.itemColorSets.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ColorSetBuilder.from((ColoredSet)e.getValue()))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (ColorSetBuilder)e.getValue()), HashMap::putAll);
            mods.sort(Comparator.comparingInt(m -> m.replace() ? 1 : 0));
            for (ColorSetModification mod : mods) {
                String id = mod.getId().toString();
                ColorSetBuilder blockSet = null;
                ColorSetBuilder itemSet = null;
                if (mod.hasBlocks()) {
                    if (mod.replace()) {
                        blockBuilder.put(id, new ColorSetBuilder());
                    }
                    blockSet = (ColorSetBuilder)blockBuilder.get(id);
                }
                if (mod.hasItems()) {
                    if (mod.replace()) {
                        itemBuilder.put(id, new ColorSetBuilder());
                    }
                    itemSet = (ColorSetBuilder)itemBuilder.get(id);
                }
                for (Map.Entry<class_1767, BlockAndItem> e2 : mod.entrySet()) {
                    @Nullable class_1767 color = e2.getKey();
                    @Nullable class_2248 b = e2.getValue().block();
                    @Nullable class_1792 i = e2.getValue().item();
                    if (b != null && blockSet != null) {
                        blockSet.setColor(color, b);
                    }
                    if (i == null || itemSet == null) continue;
                    itemSet.setColor(color, i);
                }
            }
            Map newBlockSets = blockBuilder.entrySet().stream().filter(e -> !((ColorSetBuilder)e.getValue()).isEmpty()).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ColorSetBuilder)e.getValue()).build()), HashMap::putAll);
            Map newItemSets = itemBuilder.entrySet().stream().filter(e -> !((ColorSetBuilder)e.getValue()).isEmpty()).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((ColorSetBuilder)e.getValue()).build()), HashMap::putAll);
            return new State(newBlockSets, newItemSets);
        }
    }

    private static class ColorSetBuilder<T> {
        private final Map<class_1767, T> colorsToObj = new HashMap<class_1767, T>();

        private ColorSetBuilder() {
        }

        private static <T> ColorSetBuilder<T> from(ColoredSet<T> other) {
            ColorSetBuilder<T> b = new ColorSetBuilder<T>();
            b.colorsToObj.putAll(other.colorsToObj);
            return b;
        }

        private void setColor(@Nullable class_1767 color, T b) {
            this.colorsToObj.put(color, b);
        }

        private boolean isEmpty() {
            return this.colorsToObj.isEmpty();
        }

        private ColoredSet<T> build() {
            return new ColoredSet<T>(this.colorsToObj);
        }

        public boolean hasAllVanilla() {
            return VANILLA_COLORS.stream().allMatch(this.colorsToObj::containsKey);
        }

        @Nullable
        public T getColor(class_1767 dyeColor) {
            return this.colorsToObj.get(dyeColor);
        }
    }

    private record ColoredSet<T>(Map<class_1767, T> colorsToObj) {
        private ColoredSet(Map<class_1767, T> colorsToObj) {
            this.colorsToObj = new HashMap<class_1767, T>(colorsToObj);
        }

        private class_6885<T> makeHolderSet(class_2378<T> registry) {
            return class_6885.method_40244(arg_0 -> registry.method_47983(arg_0), new ArrayList<T>(this.colorsToObj.values()));
        }

        @Nullable
        private T with(@Nullable class_1767 newColor) {
            if (newColor != null && !this.colorsToObj.containsKey(newColor)) {
                return null;
            }
            return this.colorsToObj.getOrDefault(newColor, this.colorsToObj.get(null));
        }
    }
}

