/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.pack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.pack.ImageMerger;
import net.minecraft.class_1011;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.Nullable;

public class MergedDynamicClientResourcesProvider
implements class_3262,
SimplePackProvider {
    private final Set<DynamicResourcesProvider> providers = new HashSet<DynamicResourcesProvider>();
    private final List<class_3262> packResourcesStack = new ArrayList<class_3262>();
    private final class_9224 locationInfo;
    private final Set<String> modNamespaces = new HashSet<String>();
    private class_3272 metadata;
    private byte[] packIcon;

    public MergedDynamicClientResourcesProvider(class_9224 info) {
        this.locationInfo = info;
    }

    public void add(DynamicResourcesProvider provider) {
        if (provider.getPackType() != class_3264.field_14188) {
            throw new IllegalArgumentException("Tried to merge a pack provider of type " + String.valueOf(provider.getPackType()) + " to a merged provider of type " + String.valueOf(class_3264.field_14188));
        }
        if (this.providers.add(provider)) {
            this.packResourcesStack.add(provider.getPackResources());
            this.packResourcesStack.sort(Comparator.comparing(class_3262::method_14409));
            this.modNamespaces.add(provider.getName().method_12836());
        }
    }

    public void addLegacy(DynamicResourcePack dynPack) {
        this.packResourcesStack.add(dynPack);
        this.packResourcesStack.sort(Comparator.comparing(class_3262::method_14409));
        this.modNamespaces.add(dynPack.mainNamespace);
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        if (fileName.equals("pack.png") && this.packIcon != null) {
            return () -> new ByteArrayInputStream(this.packIcon);
        }
        for (class_3262 packResources : this.packResourcesStack) {
            class_7367 r = packResources.method_14410(strings);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        class_3262 packResources;
        class_7367 ioSupplier;
        Iterator<class_3262> iterator = this.packResourcesStack.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((ioSupplier = (packResources = iterator.next()).method_14405(packType, location)) == null);
        return ioSupplier;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        HashMap map = new HashMap();
        for (class_3262 packResources : this.packResourcesStack) {
            Objects.requireNonNull(map);
            packResources.method_14408(packType, namespace, path, map::putIfAbsent);
        }
        map.forEach(resourceOutput);
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> set = new HashSet<String>();
        for (class_3262 packResources : this.packResourcesStack) {
            set.addAll(packResources.method_14406(type));
        }
        return set;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> serializer) throws IOException {
        if (this.metadata == null) {
            this.metadata = new class_3272((class_2561)class_2561.method_43469((String)"message.moonlight.merged_pack.description", (Object[])new Object[]{this.modNamespaces.size()}), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
        }
        return (T)(serializer == class_3272.field_14202 ? this.metadata : null);
    }

    public class_9224 method_56926() {
        return this.locationInfo;
    }

    public void close() {
        this.packResourcesStack.forEach(class_3262::close);
    }

    public int size() {
        return this.packResourcesStack.size();
    }

    private void checkInitialized() {
        if (this.packIcon == null) {
            this.packIcon = this.createIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createIcon() {
        block24: {
            ArrayList<class_1011> icons = new ArrayList<class_1011>();
            for (Object p2 : this.packResourcesStack) {
                class_7367 icon = p2.method_14410(new String[]{"pack.png"});
                if (icon != null) {
                    try (InputStream s = (InputStream)icon.get();){
                        icons.add(class_1011.method_4309((InputStream)s));
                    }
                    catch (Exception e) {
                        Moonlight.LOGGER.error("Failed to read pack icon from {}", (Object)p2.method_14409(), (Object)e);
                    }
                    continue;
                }
                Moonlight.LOGGER.warn("Pack {} has no icon", (Object)p2.method_14409());
            }
            try {
                Object p2;
                block23: {
                    class_1011 image = ImageMerger.mergeSquare(icons, ImageMerger.Mode.MIN_AREA_NO_UPSCALE, -16777216);
                    try {
                        p2 = image.method_24036();
                        if (image == null) break block23;
                    }
                    catch (Throwable p2) {
                        try {
                            if (image != null) {
                                try {
                                    image.close();
                                }
                                catch (Throwable throwable) {
                                    p2.addSuppressed(throwable);
                                }
                            }
                            throw p2;
                        }
                        catch (Exception ignored) {
                            Moonlight.LOGGER.error("Failed to merge pack icons");
                            for (class_1011 i : icons) {
                                i.close();
                            }
                            break block24;
                        }
                    }
                    image.close();
                }
                return p2;
            }
            finally {
                for (class_1011 i : icons) {
                    i.close();
                }
            }
        }
        return null;
    }

    @Override
    public class_3288 createPack() {
        final MergedDynamicClientResourcesProvider resources = this;
        return class_3288.method_45275((class_9224)this.locationInfo, (class_3288.class_7680)new class_3288.class_7680(){

            public class_3262 method_52424(class_9224 location) {
                MergedDynamicClientResourcesProvider.this.checkInitialized();
                return resources;
            }

            public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                return resources;
            }
        }, (class_3264)class_3264.field_14188, (class_9225)new class_9225(true, class_3288.class_3289.field_14280, false));
    }
}

