/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import java.util.Arrays;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.ColorSpaces;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_3532;

public class HCLVColor
extends BaseColor<HCLVColor> {
    public HCLVColor(float h, float c, float l, float a) {
        super(h, c, l, a);
    }

    public String toString() {
        return String.format("H: %s, C: %s, L %s", (int)(255.0f * this.hue()), (int)(255.0f * this.chroma()), (int)(255.0f * this.luminance()));
    }

    public float hue() {
        return this.v0;
    }

    public float chroma() {
        return this.v1;
    }

    public float luminance() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public HCLVColor withHue(float hue) {
        return new HCLVColor(hue, this.chroma(), this.luminance(), this.alpha());
    }

    public HCLVColor withChroma(float chroma) {
        return new HCLVColor(this.hue(), chroma, this.luminance(), this.alpha());
    }

    public HCLVColor withLuminance(float luminance) {
        return new HCLVColor(this.hue(), this.chroma(), luminance, this.alpha());
    }

    public HCLVColor withAlpha(float alpha) {
        return new HCLVColor(this.hue(), this.chroma(), this.luminance(), alpha);
    }

    @Override
    public RGBColor asRGB() {
        return ColorSpaces.HCLVtoLUV(this).asRGB();
    }

    @Override
    public HCLVColor asHCLV() {
        return this;
    }

    public static HCLVColor averageColors(HCLVColor ... colors) {
        float size = colors.length;
        Stream<Float> list = Arrays.stream(colors).map(HCLVColor::hue);
        Float[] hues = (Float[])list.toArray(Float[]::new);
        float s = 0.0f;
        float v = 0.0f;
        float a = 0.0f;
        for (HCLVColor c : colors) {
            s += c.chroma();
            v += c.luminance();
            a += c.alpha();
        }
        return new HCLVColor(HCLVColor.averageAngles(hues), s / size, v / size, a / size);
    }

    @Override
    public HCLVColor multiply(float hue, float chroma, float luminance, float alpha) {
        return new HCLVColor(class_3532.method_15363((float)(hue * this.hue()), (float)0.0f, (float)1.0f), class_3532.method_15363((float)(chroma * this.chroma()), (float)0.0f, (float)1.0f), class_3532.method_15363((float)(luminance * this.luminance()), (float)0.0f, (float)1.0f), class_3532.method_15363((float)(alpha * this.alpha()), (float)0.0f, (float)1.0f));
    }

    @Override
    public HCLVColor mixWith(HCLVColor color, float bias) {
        float h;
        float i = 1.0f - bias;
        for (h = HCLVColor.weightedAverageAngles(this.hue(), color.hue(), bias); h < 0.0f; h += 1.0f) {
        }
        float c = this.chroma() * i + color.chroma() * bias;
        float b = this.luminance() * i + color.luminance() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new HCLVColor(h, c, b, a);
    }

    @Override
    public HCLVColor fromRGB(RGBColor rgb) {
        return rgb.asHCLV();
    }

    @Override
    public float distTo(HCLVColor other) {
        float h = this.hue();
        float h2 = other.hue();
        float c = this.chroma();
        float c2 = other.chroma();
        double x = (double)c * Math.cos((double)h * Math.PI * 2.0) - (double)c2 * Math.cos((double)h2 * Math.PI * 2.0);
        double y = (double)c * Math.sin((double)h * Math.PI * 2.0) - (double)c2 * Math.sin((double)h2 * Math.PI * 2.0);
        return (float)Math.sqrt(x * x + y * y + (double)((this.luminance() - other.luminance()) * (this.luminance() - other.luminance())));
    }
}

