/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.trades.BiomeVariantItemListing;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.trades.NoOpListing;
import net.mehvahdjukaar.moonlight.api.trades.RemoveNonDataListingListing;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListingManager
extends class_4309 {
    private static final SidedInstance<ItemListingManager> INSTANCE = SidedInstance.of(ItemListingManager::new);
    protected static final CodecMapRegistry<ModItemListing> LISTING_TYPES = MapRegistry.ofCodec();
    private final Map<class_1299<?>, Set<ModItemListing>> specialTradesAdded = new HashMap();
    private final Map<class_3852, Set<ModItemListing>> tradesAdded = new HashMap<class_3852, Set<ModItemListing>>();
    private final Map<class_1299<?>, Int2ObjectArrayMap<Set<class_3853.class_1652>>> specialTradesRemoved = new HashMap();
    private final Map<class_3852, Int2ObjectArrayMap<Set<class_3853.class_1652>>> tradesRemoved = new HashMap<class_3852, Int2ObjectArrayMap<Set<class_3853.class_1652>>>();
    private final class_7225.class_7874 registryAccess;

    @ApiStatus.Internal
    public static void init() {
        LISTING_TYPES.register(class_2960.method_60654((String)"simple"), SimpleItemListing.CODEC);
        LISTING_TYPES.register(class_2960.method_60654((String)"remove_all_non_data"), RemoveNonDataListingListing.CODEC);
        LISTING_TYPES.register(class_2960.method_60654((String)"no_op"), NoOpListing.CODEC);
        LISTING_TYPES.register(class_2960.method_60654((String)"villager_type_variant"), BiomeVariantItemListing.CODEC);
    }

    public ItemListingManager(class_7225.class_7874 provider) {
        super(new Gson(), "moonlight/villager_trade");
        this.registryAccess = provider;
        INSTANCE.set(this.registryAccess, this);
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        ModItemListing listing;
        Int2ObjectMap wanderingTraderTrades;
        Int2ObjectArrayMap<Set<class_3853.class_1652>> removed;
        Int2ObjectMap<class_3853.class_1652[]> tradeMap;
        RemoveNonDataListingListing listing2;
        this.restoreVanillaState();
        ArrayList<Pair> toAdd = new ArrayList<Pair>();
        ArrayList<Pair> toAddSpecial = new ArrayList<Pair>();
        ArrayList<Pair> toRemove = new ArrayList<Pair>();
        ArrayList<Pair> toRemoveSpecial = new ArrayList<Pair>();
        class_6903 ops = ForgeHelper.conditionalOps(JsonOps.INSTANCE, this.registryAccess, this);
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            class_2960 id = e.getKey();
            if (!id.method_12832().contains("/")) continue;
            class_2960 targetId = id.method_45134(p -> p.substring(0, p.lastIndexOf(47)));
            Optional profession = class_7923.field_41195.method_17966(targetId);
            if (profession.isPresent()) {
                ModItemListing trade = ItemListingManager.parseOrThrow(json, id, ops).orElse(null);
                if (trade == null || trade instanceof NoOpListing) continue;
                if (trade instanceof RemoveNonDataListingListing) {
                    RemoveNonDataListingListing rl = (RemoveNonDataListingListing)trade;
                    toRemove.add(Pair.of((Object)rl, (Object)((class_3852)profession.get())));
                    continue;
                }
                toAdd.add(Pair.of((Object)trade, (Object)((class_3852)profession.get())));
                continue;
            }
            Optional entityType = class_7923.field_41177.method_17966(targetId);
            if (entityType.isPresent()) {
                ModItemListing trade = ItemListingManager.parseOrThrow(json, id, ops).orElse(null);
                if (trade == null || trade instanceof NoOpListing) continue;
                if (trade instanceof RemoveNonDataListingListing) {
                    RemoveNonDataListingListing rl = (RemoveNonDataListingListing)trade;
                    toRemoveSpecial.add(Pair.of((Object)rl, (Object)((class_1299)entityType.get())));
                    continue;
                }
                toAddSpecial.add(Pair.of((Object)trade, (Object)((class_1299)entityType.get())));
                continue;
            }
            Moonlight.LOGGER.warn("Unknown villager type: {}", (Object)targetId);
        }
        for (Pair pair : toRemove) {
            class_3852 profession = (class_3852)pair.getSecond();
            listing2 = (RemoveNonDataListingListing)pair.getFirst();
            removed = this.removeMatchingTrades(listing2, tradeMap = ItemListingManager.getTradeMapForProfession(profession));
            if (removed.isEmpty()) continue;
            this.tradesRemoved.computeIfAbsent(profession, k -> new Int2ObjectArrayMap()).putAll(removed);
        }
        for (Pair pair : toRemoveSpecial) {
            class_1299 entity = (class_1299)pair.getSecond();
            if (entity != class_1299.field_17713 || (removed = this.removeMatchingTrades(listing2 = (RemoveNonDataListingListing)pair.getFirst(), (Int2ObjectMap<class_3853.class_1652[]>)(wanderingTraderTrades = class_3853.field_17724))).isEmpty()) continue;
            this.specialTradesRemoved.computeIfAbsent(entity, k -> new Int2ObjectArrayMap()).putAll(removed);
        }
        for (Pair pair : toAdd) {
            listing = (ModItemListing)pair.getFirst();
            class_3852 profession = (class_3852)pair.getSecond();
            tradeMap = ItemListingManager.getTradeMapForProfession(profession);
            ItemListingManager.addTrade(tradeMap, listing, true);
            this.tradesAdded.computeIfAbsent(profession, k -> new HashSet()).add(listing);
        }
        for (Pair pair : toAddSpecial) {
            listing = (ModItemListing)pair.getFirst();
            class_1299 entity = (class_1299)pair.getSecond();
            if (entity == class_1299.field_17713) {
                wanderingTraderTrades = class_3853.field_17724;
                ItemListingManager.addTrade((Int2ObjectMap<class_3853.class_1652[]>)wanderingTraderTrades, listing, true);
            }
            this.specialTradesAdded.computeIfAbsent(entity, k -> new HashSet()).add(listing);
        }
        int added = this.specialTradesAdded.values().stream().mapToInt(Set::size).sum() + this.tradesAdded.values().stream().mapToInt(Set::size).sum();
        int removed2 = this.tradesRemoved.values().stream().mapToInt(map -> map.values().stream().mapToInt(Set::size).sum()).sum() + this.specialTradesRemoved.values().stream().mapToInt(map -> map.values().stream().mapToInt(Set::size).sum()).sum();
        if (added > 0) {
            Moonlight.LOGGER.info("Applied {} data villager trades", (Object)added);
        }
        if (removed2 > 0) {
            Moonlight.LOGGER.info("Removed {} data villager trades", (Object)removed2);
        }
    }

    @NotNull
    private static Int2ObjectMap<class_3853.class_1652[]> getTradeMapForProfession(class_3852 profession) {
        return class_3853.field_17067.computeIfAbsent(profession, k -> new Int2ObjectArrayMap());
    }

    private static void addTrade(Int2ObjectMap<class_3853.class_1652[]> tradeMap, @NotNull ModItemListing listing, boolean add) {
        int level = listing.getLevel();
        class_3853.class_1652[] existing = (class_3853.class_1652[])tradeMap.computeIfAbsent(level, k -> new class_3853.class_1652[0]);
        tradeMap.put(listing.getLevel(), (Object)ItemListingManager.mergeArrays(existing, add, listing));
    }

    private static class_3853.class_1652[] mergeArrays(class_3853.class_1652[] existing, boolean add, class_3853.class_1652 ... toAdd) {
        ArrayList<class_3853.class_1652> list = new ArrayList<class_3853.class_1652>(List.of(existing));
        if (add) {
            list.addAll(List.of(toAdd));
        } else {
            list.removeAll(List.of(toAdd));
        }
        return (class_3853.class_1652[])list.toArray(class_3853.class_1652[]::new);
    }

    private Int2ObjectArrayMap<Set<class_3853.class_1652>> removeMatchingTrades(RemoveNonDataListingListing removal, Int2ObjectMap<class_3853.class_1652[]> originalTrades) {
        Int2ObjectArrayMap removedTrades = new Int2ObjectArrayMap();
        HashMap<Integer, class_3853.class_1652[]> updatedTrades = new HashMap<Integer, class_3853.class_1652[]>();
        for (Int2ObjectMap.Entry entry : originalTrades.int2ObjectEntrySet()) {
            int level = entry.getIntKey();
            class_3853.class_1652[] trades = (class_3853.class_1652[])entry.getValue();
            ArrayList<class_3853.class_1652> remaining = new ArrayList<class_3853.class_1652>();
            HashSet<class_3853.class_1652> removedAtLevel = new HashSet<class_3853.class_1652>();
            for (class_3853.class_1652 trade : trades) {
                if (removal.matches(level, trade)) {
                    removedAtLevel.add(trade);
                    continue;
                }
                remaining.add(trade);
            }
            if (removedAtLevel.isEmpty()) continue;
            removedTrades.put(level, removedAtLevel);
            updatedTrades.put(level, (class_3853.class_1652[])remaining.toArray(class_3853.class_1652[]::new));
        }
        originalTrades.putAll(updatedTrades);
        return removedTrades;
    }

    private void restoreVanillaState() {
        class_1299 entity;
        class_3853.class_1652[] array;
        int level;
        Int2ObjectMap<class_3853.class_1652[]> tradeMap;
        Set<ModItemListing> listings;
        class_3852 profession;
        for (Map.Entry<class_3852, Set<ModItemListing>> entry : this.tradesAdded.entrySet()) {
            profession = entry.getKey();
            listings = entry.getValue();
            tradeMap = ItemListingManager.getTradeMapForProfession(profession);
            for (ModItemListing listing : listings) {
                level = listing.getLevel();
                array = (class_3853.class_1652[])tradeMap.get(level);
                if (array == null) continue;
                ItemListingManager.addTrade(tradeMap, listing, false);
            }
        }
        for (Map.Entry<class_3852, Set<ModItemListing>> entry : this.specialTradesAdded.entrySet()) {
            entity = (class_1299)entry.getKey();
            listings = entry.getValue();
            if (entity != class_1299.field_17713) continue;
            tradeMap = class_3853.field_17724;
            for (ModItemListing listing : listings) {
                level = listing.getLevel();
                array = (class_3853.class_1652[])tradeMap.get(level);
                if (array == null) continue;
                ItemListingManager.addTrade(tradeMap, listing, false);
            }
        }
        for (Map.Entry<class_3852, Set<ModItemListing>> entry : this.tradesRemoved.entrySet()) {
            profession = entry.getKey();
            Int2ObjectMap removedPerLevel = (Int2ObjectMap)entry.getValue();
            tradeMap = ItemListingManager.getTradeMapForProfession(profession);
            this.restoreMap(tradeMap, (Int2ObjectMap<Set<class_3853.class_1652>>)removedPerLevel);
        }
        for (Map.Entry<class_3852, Set<ModItemListing>> entry : this.specialTradesRemoved.entrySet()) {
            entity = (class_1299)entry.getKey();
            if (entity != class_1299.field_17713) continue;
            Int2ObjectMap tradeMap2 = class_3853.field_17724;
            Int2ObjectMap removedPerLevel = (Int2ObjectMap)entry.getValue();
            this.restoreMap((Int2ObjectMap<class_3853.class_1652[]>)tradeMap2, (Int2ObjectMap<Set<class_3853.class_1652>>)removedPerLevel);
        }
        this.tradesAdded.clear();
        this.specialTradesAdded.clear();
        this.tradesRemoved.clear();
        this.specialTradesRemoved.clear();
    }

    private void restoreMap(Int2ObjectMap<class_3853.class_1652[]> tradeMap, Int2ObjectMap<Set<class_3853.class_1652>> removedPerLevel) {
        for (Int2ObjectMap.Entry levelEntry : removedPerLevel.int2ObjectEntrySet()) {
            int level = levelEntry.getIntKey();
            Set removedTrades = (Set)levelEntry.getValue();
            class_3853.class_1652[] currentArray = (class_3853.class_1652[])tradeMap.get(level);
            tradeMap.put(level, (Object)ItemListingManager.mergeArrays(currentArray, true, (class_3853.class_1652[])removedTrades.toArray(class_3853.class_1652[]::new)));
        }
    }

    private static Optional<ModItemListing> parseOrThrow(JsonElement j, class_2960 id, DynamicOps<JsonElement> ops) {
        return (Optional)ForgeHelper.conditionalCodec(ModItemListing.CODEC).parse(ops, (Object)j).getOrThrow();
    }

    public static List<? extends class_3853.class_1652> getVillagerListings(class_3852 profession, int level) {
        class_3853.class_1652[] array = (class_3853.class_1652[])ItemListingManager.getTradeMapForProfession(profession).get(level);
        if (array == null) {
            return List.of();
        }
        return Arrays.stream(array).toList();
    }

    public static List<? extends class_3853.class_1652> getSpecialListings(class_1299<?> entityType, int level, class_7225.class_7874 provider) {
        if (entityType == class_1299.field_17713) {
            class_3853.class_1652[] array = (class_3853.class_1652[])class_3853.field_17724.get(level);
            if (array == null) {
                return List.of();
            }
            return Arrays.stream(array).toList();
        }
        Set<ModItemListing> special = ItemListingManager.INSTANCE.get((class_7225.class_7874)provider).specialTradesAdded.get(entityType);
        if (special == null) {
            return List.of();
        }
        ArrayList<ModItemListing> listings = new ArrayList<ModItemListing>();
        for (ModItemListing listing : special) {
            if (listing.getLevel() != level) continue;
            listings.add(listing);
        }
        return listings;
    }

    @Deprecated(forRemoval=true)
    public static List<? extends class_3853.class_1652> getSpecialListings(class_1299<?> entityType, int level) {
        return ItemListingManager.getSpecialListings(entityType, level, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    public static void registerSerializer(class_2960 id, MapCodec<? extends ModItemListing> trade) {
        LISTING_TYPES.register(id, trade);
    }

    public static void registerSimple(class_2960 id, class_3853.class_1652 instance, int level) {
        SpecialListing specialListing = new SpecialListing(instance, level);
        ItemListingManager.registerSerializer(id, specialListing.getCodec());
    }

    private static class SpecialListing
    implements ModItemListing {
        private final MapCodec<ModItemListing> codec = MapCodec.unit((Object)this);
        private final class_3853.class_1652 listing;
        private final int level;

        public SpecialListing(class_3853.class_1652 listing, int level) {
            this.listing = listing;
            this.level = level;
        }

        @Override
        public MapCodec<? extends ModItemListing> getCodec() {
            return this.codec;
        }

        @Nullable
        public class_1914 method_7246(class_1297 trader, class_5819 random) {
            return this.listing.method_7246(trader, random);
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

