/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe.fabric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditionType;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ResourceConditionsBridge {
    public static final ResourceCondition FALSE = new ResourceCondition(){

        public ResourceConditionType<?> getType() {
            return FALSE_TYPE;
        }

        public boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable class_7225.class_7874 registryLookup) {
            return false;
        }
    };
    public static final ResourceConditionType<ResourceCondition> FALSE_TYPE = ResourceConditionType.create((class_2960)class_2960.method_60654((String)"fabric:false"), (MapCodec)MapCodec.unit((Object)FALSE));

    public static void init() {
        try {
            ResourceConditions.register(ModLoadedCondition.TYPE);
            ResourceConditions.register(TagEmptyCondition.TYPE);
            ResourceConditions.register(FALSE_TYPE);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to register fabric conditions", (Throwable)e);
        }
    }

    public record ModLoadedCondition(String modIds) implements ResourceCondition
    {
        public static final MapCodec<ModLoadedCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("modid").forGetter(ModLoadedCondition::modIds)).apply((Applicative)instance, ModLoadedCondition::new));
        public static final ResourceConditionType<ModLoadedCondition> TYPE = ResourceConditionType.create((class_2960)class_2960.method_60654((String)"fabric:mod_loaded"), CODEC);

        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        public boolean test(@Nullable class_7225.class_7874 registryLookup) {
            return PlatHelper.isModLoaded(this.modIds);
        }
    }

    public record TagEmptyCondition(class_6862<class_1792> tag) implements ResourceCondition
    {
        public static final MapCodec<TagEmptyCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(TagEmptyCondition::tag)).apply((Applicative)instance, TagEmptyCondition::new));
        public static final ResourceConditionType<TagEmptyCondition> TYPE = ResourceConditionType.create((class_2960)class_2960.method_60654((String)"fabric:tag_empty"), CODEC);

        public ResourceConditionType<?> getType() {
            return TYPE;
        }

        public boolean test(@Nullable class_7225.class_7874 registryLookup) {
            if (registryLookup == null) {
                Moonlight.LOGGER.error("Registry Lookup was null, failing tag_empty resource condition check");
                return !ResourceConditionsImpl.tagsPopulated((class_2960)this.tag.comp_326().method_29177(), List.of(this.tag.comp_327()));
            }
            Optional opt = registryLookup.method_46762(class_7924.field_41197).method_46733(this.tag);
            return opt.isEmpty() || ((class_6885.class_6888)opt.get()).method_40239().findAny().isEmpty();
        }
    }
}

