/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.ThrowingSupplier;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.RecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8490;
import net.minecraft.class_8786;

public class ResourceSink {
    private final String packNamespace;
    private final String packId;
    private final Map<class_2960, byte[]> resources = new HashMap<class_2960, byte[]>();
    private final Map<class_6862<?>, SimpleTagBuilder> tags = new HashMap();

    public ResourceSink(String packNamespace, String packId) {
        this.packNamespace = packNamespace;
        this.packId = packId;
    }

    protected void addBytes(class_2960 id, byte[] bytes) {
        this.resources.put(id, (byte[])Preconditions.checkNotNull((Object)bytes));
    }

    public void addResource(StaticResource resource) {
        this.addBytes(resource.location, resource.data);
    }

    private void addJson(class_2960 path, JsonElement json) {
        try {
            this.addBytes(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            Moonlight.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
        }
    }

    public void addJson(class_2960 location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    public void addBytes(class_2960 location, byte[] bytes, ResType resType) {
        this.addBytes(resType.getPath(location), bytes);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(class_2960 path, TextureImage image) {
        this.addAndCloseTexture(path, image, true);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(class_2960 path, TextureImage image, boolean isOnAtlas) {
        try (TextureImage textureImage = image;){
            this.addTexture(path, image, isOnAtlas);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this, (Object)e);
        }
    }

    public void addAndCloseTexture(class_2960 path, Supplier<TextureImage> image) {
        try (TextureImage img = image.get();){
            this.addTexture(path, img);
        }
    }

    @Deprecated(forRemoval=true)
    public void addTexture(class_2960 path, TextureImage image, boolean onAtlas) {
        this.addTexture(path, image);
    }

    public void addTexture(class_2960 path, TextureImage image) {
        try {
            this.addBytes(path, image.getImage().method_24036(), ResType.TEXTURES);
            if (image.getMcMeta() != null) {
                this.addJson(path, (JsonElement)image.getMcMeta().toJson(), ResType.MCMETA);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(forRemoval=true)
    public void markNotClearable(class_2960 path) {
    }

    public void addBlockModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    public void addItemModel(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    public void addBlockState(class_2960 modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    public void addLang(class_2960 langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    public void addLang(class_2960 langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }

    public void addTag(SimpleTagBuilder builder, class_5321<? extends class_2378<?>> reg) {
        class_6862 key = class_6862.method_40092(reg, (class_2960)builder.getId());
        this.tags.merge(key, builder, (a, b) -> {
            a.merge((SimpleTagBuilder)((Object)b));
            return a;
        });
    }

    public void addSimpleBlockLootTable(class_2248 block) {
        this.addLootTable(block, ResourceSink.createSingleItemTable((class_1935)block).method_334(class_173.field_1172));
    }

    public void addLootTable(class_2248 block, class_52.class_53 table) {
        this.addLootTable(block.method_26162().method_29177(), table.method_338());
    }

    public void addLootTable(class_2960 id, class_52 table) {
        this.addJson(id, (JsonElement)class_8490.field_44498.comp_2520.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)table).getOrThrow(), ResType.LOOT_TABLES);
    }

    protected static class_52.class_53 createSingleItemTable(class_1935 itemLike) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)itemLike)).method_354());
    }

    public void addRecipe(class_8786<?> holder) {
        this.addRecipe(holder.comp_1933(), holder.comp_1932());
    }

    public void addRecipe(class_1860<?> recipe, class_2960 id) {
        this.addRecipeNoAdvancement(recipe, id);
    }

    public void addRecipeNoAdvancement(class_1860<?> recipe, class_2960 id) {
        this.addJson(id, RPUtils.writeRecipe(recipe), ResType.RECIPES);
    }

    public void addResourceIfNotPresent(class_3300 manager, StaticResource resource) {
        if (!this.alreadyHasAssetAtLocation(manager, resource.location)) {
            this.addResource(resource);
        }
    }

    public void addJsonUnlessPresent(class_3300 manager, class_2960 path, ThrowingSupplier<JsonElement> jsonSupplier) {
        if (!this.alreadyHasAssetAtLocation(manager, path)) {
            try {
                this.addJson(path, jsonSupplier.get());
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to write JSON {} to resource pack.", (Object)path, (Object)e);
            }
        }
    }

    public boolean alreadyHasTextureAtLocation(class_3300 manager, class_2960 res) {
        return this.alreadyHasAssetAtLocation(manager, res, ResType.TEXTURES);
    }

    @Deprecated(forRemoval=true)
    public void addTextureIfNotPresent(class_3300 manager, String relativePath, Supplier<TextureImage> textureSupplier) {
        this.addTextureIfNotPresent(manager, relativePath, textureSupplier, true);
    }

    @Deprecated(forRemoval=true)
    public void addTextureIfNotPresent(class_3300 manager, String relativePath, Supplier<TextureImage> textureSupplier, boolean isOnAtlas) {
        this.addTextureIfNotPresent(manager, relativePath.contains(":") ? class_2960.method_60654((String)relativePath) : class_2960.method_60655((String)this.packNamespace, (String)relativePath), textureSupplier);
    }

    public void addTextureIfNotPresent(class_3300 manager, class_2960 res, Supplier<TextureImage> textureSupplier) {
        if (!this.alreadyHasTextureAtLocation(manager, res)) {
            try (TextureImage textureImage = textureSupplier.get();){
                this.addTexture(res, textureImage);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to generate texture {}: {}", (Object)res, (Object)e);
            }
        }
    }

    public void addTextureUnlessPresent(class_3300 manager, class_2960 res, ThrowingSupplier<TextureImage> textureSupplier) {
        if (!this.alreadyHasTextureAtLocation(manager, res)) {
            try (TextureImage textureImage = textureSupplier.get();){
                this.addTexture(res, textureImage);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to generate texture {}: {}", (Object)res, (Object)e);
            }
        }
    }

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res, ResType type) {
        return this.alreadyHasAssetAtLocation(manager, type.getPath(res));
    }

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res) {
        Optional resource = manager.method_14486(res);
        return resource.filter(value -> !value.method_14480().equals(this.packId)).isPresent();
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, String keyword, String replaceWith) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, s -> s.replace(keyword, replaceWith));
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform) throws NoSuchElementException {
        this.addSimilarJsonResource(manager, resource, textTransform, textTransform);
    }

    public void addSimilarJsonResource(class_3300 manager, StaticResource resource, Function<String, String> textTransform, Function<String, String> pathTransform) throws NoSuchElementException {
        class_2960 fullPath = resource.location;
        StringBuilder builder = new StringBuilder();
        String[] partial = fullPath.method_12832().split("/");
        for (int i = 0; i < partial.length; ++i) {
            if (i != 0) {
                builder.append("/");
            }
            if (i == partial.length - 1) {
                builder.append(pathTransform.apply(partial[i]));
                continue;
            }
            builder.append(partial[i]);
        }
        class_2960 newRes = class_2960.method_60655((String)this.packNamespace, (String)builder.toString());
        if (!this.alreadyHasAssetAtLocation(manager, newRes)) {
            String fullText = resource.asString();
            fullText = textTransform.apply(fullText);
            this.addBytes(newRes, fullText.getBytes());
        }
    }

    public void copyResource(class_3300 manager, class_2960 from, class_2960 to, boolean lenient) {
        Optional resource = manager.method_14486(from);
        if (resource.isPresent()) {
            StaticResource s = StaticResource.of((class_3298)resource.get(), from);
            this.addBytes(to, s.data);
        } else if (lenient) {
            Moonlight.LOGGER.info("Resource {} not found for copying to {}", (Object)from, (Object)to);
        } else {
            throw new NoSuchElementException("Resource " + String.valueOf(from) + " not found for copying to " + String.valueOf(to));
        }
    }

    public <T extends BlockType> void addBlockTypeSwapRecipe(class_3300 manager, class_2960 originalRecipeId, T originalMat, T destinationMat, class_2960 baseID) {
        StaticResource originalResource = StaticResource.getOrThrow(manager, ResType.RECIPES.getPath(originalRecipeId));
        JsonObject originalJson = originalResource.toJson();
        class_1860<?> originalRecipe = RPUtils.readRecipe((JsonElement)originalJson);
        class_8786<?> newRecipe = RecipeTemplate.makeSimilarRecipe(originalRecipe, originalMat, destinationMat, baseID);
        JsonElement newJson = RPUtils.writeRecipe(newRecipe.comp_1933());
        if (newJson instanceof JsonObject) {
            JsonObject jo = (JsonObject)newJson;
            for (Map.Entry e : originalJson.entrySet()) {
                String key = (String)e.getKey();
                if (!key.contains("condition") || jo.has(key)) continue;
                jo.add(key, (JsonElement)e.getValue());
            }
        }
        if (!this.alreadyHasAssetAtLocation(manager, newRecipe.comp_1932())) {
            this.addJson(newRecipe.comp_1932(), newJson, ResType.RECIPES);
        }
    }

    public void appendModelOverride(class_3300 manager, class_2960 modelRes, Consumer<RPUtils.OverrideAppender> modelConsumer) {
        JsonElement json = RPUtils.makeModelOverride(manager, modelRes, modelConsumer);
        this.addItemModel(modelRes, json);
    }

    public static void acceptSinks(IEditablePackResources pack, Collection<ResourceSink> sinks) {
        HashMultimap tags = HashMultimap.create();
        for (ResourceSink sink : sinks) {
            for (Map.Entry<class_2960, byte[]> entry : sink.resources.entrySet()) {
                pack.addResource(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : sink.tags.entrySet()) {
                tags.put((Object)((class_6862)entry.getKey()), (Object)((SimpleTagBuilder)((Object)entry.getValue())));
            }
        }
        ResourceSink dummy = new ResourceSink("dummy", "dummy");
        for (class_6862 key : tags.keySet()) {
            Iterator iterator = tags.get((Object)key).iterator();
            if (!iterator.hasNext()) continue;
            SimpleTagBuilder builder = (SimpleTagBuilder)((Object)iterator.next());
            while (iterator.hasNext()) {
                builder.merge((SimpleTagBuilder)((Object)iterator.next()));
            }
            class_2960 tagId = builder.getId();
            class_2960 loc = ResType.TAGS.getPath(tagId.method_45136(key.comp_326().method_29177().method_12832() + "/" + tagId.method_12832()));
            dummy.addJson(loc, builder.serializeToJson(), ResType.GENERIC);
        }
        dummy.resources.forEach(pack::addResource);
    }

    public void appendItemToEnchantment(class_3300 manager, class_5321<class_1887> ench, class_1792 ... items) {
        class_2960 id = ench.method_29177();
        try (InputStream model = manager.getResourceOrThrow(ResType.ENCHANTMENTS.getPath(id)).method_14482();){
            String asString;
            JsonObject json = RPUtils.deserializeJson(model);
            JsonElement supportedItems = json.get("supported_items");
            SimpleTagBuilder tb = SimpleTagBuilder.of(id.method_45138("enchantable/"));
            String tagName = tb.getTagString();
            if (supportedItems instanceof JsonArray) {
                JsonArray arr = (JsonArray)supportedItems;
                for (JsonElement a : arr) {
                    String asString2;
                    if (!a.isJsonPrimitive() || tagName.equals(asString2 = a.getAsString())) continue;
                    tb.add(asString2);
                }
            } else if (supportedItems.isJsonPrimitive() && !tagName.equals(asString = supportedItems.getAsString())) {
                tb.add(asString);
            }
            for (class_1792 item : items) {
                tb.addEntry(item);
            }
            json.addProperty("supported_items", tagName);
            this.addJson(id, (JsonElement)json, ResType.ENCHANTMENTS);
            this.addTag(tb, class_7924.field_41197);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

