/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3861;
import net.minecraft.class_3955;
import net.minecraft.class_3975;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8786;
import net.minecraft.class_8957;
import org.jetbrains.annotations.NotNull;

public class RecipeTemplate {
    private static final Map<Class<? extends class_1860<?>>, TriFunction<class_1860<?>, BlockType, BlockType, class_1860<?>>> REMAPPERS = new HashMap();

    public static <R extends class_1860<?>> void registerSimple(Class<R> type, RecipeFactory<R> factory) {
        RecipeTemplate.register(type, (R r, BlockType f, BlockType t) -> RecipeTemplate.createSimple(r, factory, f, t));
    }

    @Deprecated(forRemoval=true)
    public static <R extends class_1860<?>> void register(Class<R> type, BiFunction<R, UnaryOperator<class_1799>, R> factory) {
        if (PlatHelper.isDev()) {
            throw new UnsupportedOperationException("You must register this using RecipeTemplate.register()");
        }
    }

    public static <R extends class_1860<?>> void register(Class<R> type, TriFunction<R, BlockType, BlockType, R> factory) {
        REMAPPERS.put(type, (r, f, t) -> (class_1860)factory.apply((Object)r, (BlockType)f, (BlockType)t));
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType, R extends class_1860<?>> class_8786<?> makeSimilarRecipe(R original, T originalMat, T destinationMat, String baseID) {
        return RecipeTemplate.makeSimilarRecipe(original, originalMat, destinationMat, class_2960.method_60654((String)baseID));
    }

    public static <T extends BlockType, R extends class_1860<?>> class_8786<?> makeSimilarRecipe(R original, @NotNull T originalMat, @NotNull T destinationMat, class_2960 baseID) {
        Class clazz = original.getClass();
        TriFunction<class_1860<?>, BlockType, BlockType, class_1860<?>> remapper = REMAPPERS.get(clazz);
        if (remapper == null) {
            throw new UnsupportedOperationException("Recipe class " + String.valueOf(clazz) + " not supported. You must register it using RecipeTemplate.register()");
        }
        class_2960 newId = baseID.method_45134(p -> p + "/" + destinationMat.getAppendableId());
        Preconditions.checkNotNull(original, (Object)("Found null from block type for remapping for recipe " + String.valueOf(originalMat) + " with id " + String.valueOf(newId)));
        Preconditions.checkNotNull(originalMat, (Object)("Found null from block type for remapping for recipe " + String.valueOf(originalMat) + " with id " + String.valueOf(newId)));
        class_1860<?> remapped = remapper.apply(original, originalMat, destinationMat);
        return new class_8786(newId, remapped);
    }

    private static <R extends class_1860<?>> R createSimple(R or, RecipeFactory<R> factory, @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull((Object)from, (Object)("Found null from block type for recipe remapping on recipe " + String.valueOf(or)));
        Preconditions.checkNotNull((Object)to, (Object)("Found null to block type for recipe remapping on recipe " + String.valueOf(or)));
        List<class_1856> newList = RecipeTemplate.convertIngredients((class_2371<class_1856>)or.method_8117(), from, to);
        class_1799 originalResult = or.method_8110((class_7225.class_7874)class_5455.field_40585);
        class_1799 newResult = RecipeTemplate.convertItemStack(originalResult, from, to);
        class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])newList.toArray(class_1856[]::new)));
        class_7710 cat = class_7710.field_40251;
        if (or instanceof class_3955) {
            class_3955 cr = (class_3955)or;
            cat = cr.method_45441();
        }
        return factory.create(or.method_8112(), cat, newResult, (class_2371<class_1856>)ingredients);
    }

    private static class_1869 createShaped(class_1869 or, @NotNull BlockType from, @NotNull BlockType to) {
        Preconditions.checkNotNull((Object)from, (Object)("Found null from block type for recipe remapping on recipe " + String.valueOf(or)));
        Preconditions.checkNotNull((Object)to, (Object)("Found null to block type for recipe remapping on recipe " + String.valueOf(or)));
        List<class_1856> newList = RecipeTemplate.convertIngredients((class_2371<class_1856>)or.method_8117(), from, to);
        class_1799 originalResult = or.method_8110((class_7225.class_7874)class_5455.field_40585);
        class_1799 newResult = RecipeTemplate.convertItemStack(originalResult, from, to);
        class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])newList.toArray(class_1856[]::new)));
        class_8957 pattern = new class_8957(or.method_8150(), or.method_8158(), ingredients, Optional.of(RecipeTemplate.packRecipePattern(or.method_8150(), or.method_8158(), (class_2371<class_1856>)ingredients)));
        return new class_1869(or.method_8112(), or.method_45441(), pattern, newResult);
    }

    private static class_8957.class_8958 packRecipePattern(int width, int height, class_2371<class_1856> ingredients) {
        HashMap<Character, class_1856> key = new HashMap<Character, class_1856>();
        ArrayList<String> pattern = new ArrayList<String>();
        char nextSymbol = 'A';
        for (int row = 0; row < height; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; ++col) {
                class_1856 ingredient = (class_1856)ingredients.get(row * width + col);
                if (ingredient.method_8103()) {
                    rowPattern.append(' ');
                    continue;
                }
                Character symbol = null;
                for (Map.Entry entry : key.entrySet()) {
                    if (entry.getValue() != ingredient) continue;
                    symbol = (Character)entry.getKey();
                    break;
                }
                if (symbol == null) {
                    char c = nextSymbol;
                    nextSymbol = (char)(nextSymbol + 1);
                    symbol = Character.valueOf(c);
                    key.put(symbol, ingredient);
                }
                rowPattern.append(symbol);
            }
            pattern.add(rowPattern.toString());
        }
        return new class_8957.class_8958(key, pattern);
    }

    public static <T extends BlockType> class_1799 convertItemStack(class_1799 original, T from, T to) {
        class_1792 changed = BlockType.changeItemType(original.method_7909(), from, to);
        if (changed == null) {
            throw new UnsupportedOperationException("Failed to convert item stack: could not change " + String.valueOf(original.method_7909()) + " from " + String.valueOf(from.getId()) + " to " + String.valueOf(to.getId()));
        }
        return original.method_60503((class_1935)changed);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static <R extends class_1860<?>> List<class_1856> convertIngredients(class_2371<class_1856> or, UnaryOperator<class_1799> typeChanger) {
        ArrayList<class_1856> newList = new ArrayList<class_1856>((Collection<class_1856>)or);
        for (int i = 0; i < newList.size(); ++i) {
            class_1799 intItem;
            class_1856 ingredient = (class_1856)or.get(i);
            if (ingredient.method_8103() || (intItem = (class_1799)typeChanger.apply(ingredient.method_8105()[0])) == null) continue;
            newList.set(i, class_1856.method_8101((class_1799[])new class_1799[]{intItem}));
        }
        return newList;
    }

    @NotNull
    public static <R extends class_1860<?>> List<class_1856> convertIngredients(class_2371<class_1856> or, @NotNull BlockType from, @NotNull BlockType to) {
        ArrayList<class_1856> newList = new ArrayList<class_1856>();
        HashMap<class_1856, class_1856> convertedMap = new HashMap<class_1856, class_1856>();
        for (class_1856 ingredient : or) {
            if (ingredient.method_8103()) {
                newList.add(ingredient);
                continue;
            }
            newList.add(convertedMap.computeIfAbsent(ingredient, i -> BlockTypeSwapIngredient.create(i, from, to)));
        }
        return newList;
    }

    static {
        RecipeTemplate.register(class_1869.class, RecipeTemplate::createShaped);
        RecipeTemplate.registerSimple(class_1867.class, class_1867::new);
        RecipeTemplate.registerSimple(class_3975.class, (group, category, result, ingredients) -> new class_3975(group, (class_1856)ingredients.getFirst(), result));
        RecipeTemplate.register(class_3861.class, (R recipe, BlockType oldType, BlockType newType) -> RecipeTemplate.createSimple(recipe, (group, category, result, ingredients) -> new class_3861(group, recipe.method_45438(), (class_1856)ingredients.getFirst(), result, recipe.method_8171(), recipe.method_8167()), oldType, newType));
    }

    public static interface RecipeFactory<R extends class_1860<?>> {
        public R create(String var1, class_7710 var2, class_1799 var3, class_2371<class_1856> var4);
    }
}

