/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.management.openmbean.InvalidOpenTypeException;
import net.mehvahdjukaar.moonlight.api.client.TextureCache;
import net.mehvahdjukaar.moonlight.api.resources.RecipeTemplate;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_799;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public class RPUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String serializeJson(JsonElement json) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                jsonWriter.setLenient(true);
                jsonWriter.setIndent("  ");
                Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                string = stringWriter.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject deserializeJson(InputStream stream) {
        return class_3518.method_15255((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static class_2960 findFirstBlockTextureLocation(class_3300 manager, class_2248 block) throws FileNotFoundException {
        return RPUtils.findFirstBlockTextureLocation(manager, block, t -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static class_2960 findFirstBlockTextureLocation(class_3300 manager, class_2248 block, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((class_1935)block, texturePredicate);
        if (cached != null) {
            return class_2960.method_60654((String)cached);
        }
        class_2960 blockId = Utils.getID(block);
        Optional blockState = manager.method_14486(ResType.BLOCKSTATES.getPath(blockId));
        try (InputStream bsStream2 = ((class_3298)blockState.orElseThrow()).method_14482();){
            JsonObject bsElement = RPUtils.deserializeJson(bsStream2);
            Set<String> models = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model"));
            for (String modelPath : models) {
                List<String> textures = RPUtils.findAllTexturesInModelRecursive(manager, modelPath);
                for (String t : textures) {
                    TextureCache.add((class_1935)block, t);
                    if (!texturePredicate.test(t)) continue;
                    class_2960 class_29602 = class_2960.method_60654((String)t);
                    return class_29602;
                }
            }
        }
        catch (Exception bsStream2) {
            // empty catch block
        }
        List<String> hack = RPUtils.guessBlockTextureLocation(blockId, block);
        for (String t : hack) {
            TextureCache.add((class_1935)block, t);
            if (!texturePredicate.test(t)) continue;
            return class_2960.method_60654((String)t);
        }
        throw new FileNotFoundException("Could not find any texture associated to the given block " + String.valueOf(blockId));
    }

    private static Set<String> guessItemTextureLocation(class_2960 id, class_1792 item) {
        return Set.of(id.method_12836() + ":item/" + String.valueOf(item));
    }

    private static List<String> guessBlockTextureLocation(class_2960 id, class_2248 block) {
        String key;
        String name = id.method_12832();
        ArrayList<String> textures = new ArrayList<String>();
        WoodType w = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((class_1935)block);
        if (w != null && (Objects.equals(key = w.getChildKey(block), "log") || Objects.equals(key, "stripped_log"))) {
            textures.add(id.method_12836() + ":block/" + name + "_top");
            textures.add(id.method_12836() + ":block/" + name + "_side");
        }
        textures.add(id.method_12836() + ":block/" + name);
        return textures;
    }

    @NotNull
    private static List<String> findAllTexturesInModelRecursive(class_3300 manager, String modelPath) throws Exception {
        JsonObject modelElement;
        try (InputStream modelStream = ((class_3298)manager.method_14486(ResType.MODELS.getPath(modelPath)).get()).method_14482();){
            modelElement = RPUtils.deserializeJson(modelStream).getAsJsonObject();
        }
        catch (Exception e) {
            throw new Exception("Failed to parse model at " + modelPath);
        }
        ArrayList<String> textures = new ArrayList<String>(RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject("textures")));
        if (textures.isEmpty() && modelElement.has("parent")) {
            String parentPath = modelElement.get("parent").getAsString();
            textures.addAll(RPUtils.findAllTexturesInModelRecursive(manager, parentPath));
        }
        return textures;
    }

    public static class_2960 findFirstItemTextureLocation(class_3300 manager, class_1792 block) throws FileNotFoundException {
        return RPUtils.findFirstItemTextureLocation(manager, block, t -> true);
    }

    public static class_2960 findFirstItemTextureLocation(class_3300 manager, class_1792 item, Predicate<String> texturePredicate) throws FileNotFoundException {
        Set<String> textures;
        String cached = TextureCache.getCached((class_1935)item, texturePredicate);
        if (cached != null) {
            return class_2960.method_60654((String)cached);
        }
        class_2960 itemId = Utils.getID(item);
        Optional itemModel = manager.method_14486(ResType.ITEM_MODELS.getPath(itemId));
        try (InputStream stream = ((class_3298)itemModel.orElseThrow()).method_14482();){
            JsonObject bsElement = RPUtils.deserializeJson(stream);
            textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures"));
        }
        catch (Exception ignored) {
            textures = RPUtils.guessItemTextureLocation(itemId, item);
        }
        for (String t : textures) {
            TextureCache.add((class_1935)item, t);
            if (!texturePredicate.test(t)) continue;
            return class_2960.method_60654((String)t);
        }
        throw new FileNotFoundException("Could not find any texture associated to the given item " + String.valueOf(itemId));
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            HashSet<String> list = new HashSet<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e, filter)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            HashSet<String> list = new HashSet<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                Set<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return Set.of(element.getAsString());
    }

    public static class_1860<?> readRecipe(class_3300 manager, String location) {
        return RPUtils.readRecipeAbsolute(manager, ResType.RECIPES.getPath(location));
    }

    public static class_1860<?> readRecipe(class_3300 manager, class_2960 location) {
        return RPUtils.readRecipeAbsolute(manager, ResType.RECIPES.getPath(location));
    }

    private static class_1860<?> readRecipeAbsolute(class_3300 manager, class_2960 location) {
        class_1860<?> class_18602;
        block8: {
            Optional resource = manager.method_14486(location);
            InputStream stream = ((class_3298)resource.orElseThrow()).method_14482();
            try {
                JsonObject element = RPUtils.deserializeJson(stream);
                class_18602 = RPUtils.readRecipe((JsonElement)element);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
                }
            }
            stream.close();
        }
        return class_18602;
    }

    public static class_1860<?> readRecipe(JsonElement element) {
        return (class_1860)class_1860.field_47319.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow();
    }

    public static <T extends class_1860<?>> JsonElement writeRecipe(T recipe) {
        return (JsonElement)class_1860.field_47319.encodeStart((DynamicOps)JsonOps.INSTANCE, recipe).getOrThrow();
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> class_8786<?> makeSimilarRecipe(class_1860<?> original, T originalMat, T destinationMat, String baseID) {
        return RPUtils.makeSimilarRecipe(original, originalMat, destinationMat, class_2960.method_60654((String)baseID));
    }

    @Deprecated(forRemoval=true)
    public static <T extends BlockType> class_8786<?> makeSimilarRecipe(class_1860<?> original, T originalMat, T destinationMat, class_2960 baseID) {
        return RecipeTemplate.makeSimilarRecipe(original, originalMat, destinationMat, baseID);
    }

    public static Path getResourcePath(Path path, class_2960 k, class_3264 packType) {
        return path.resolve(packType.method_14413()).resolve(k.method_12836()).resolve(k.method_12832());
    }

    public static void writeResource(class_2960 id, byte[] bytes, Path path, class_3264 packType) {
        Path p = RPUtils.getResourcePath(path, id, packType);
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Files.write(p, bytes, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(forRemoval=true)
    public static void appendModelOverride(class_3300 manager, DynamicTexturePack pack, class_2960 modelRes, Consumer<OverrideAppender> modelConsumer) {
        Optional o = manager.method_14486(ResType.ITEM_MODELS.getPath(modelRes));
        if (o.isPresent()) {
            try (InputStream model = ((class_3298)o.get()).method_14482();){
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.has("overrides") ? json.getAsJsonArray("overrides") : new JsonArray();
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeModelOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                pack.addItemModel(modelRes, (JsonElement)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void appendModelOverride(class_3300 manager, ResourceSink pack, class_2960 modelRes, Consumer<OverrideAppender> modelConsumer) {
        JsonElement json = RPUtils.makeModelOverride(manager, modelRes, modelConsumer);
        pack.addItemModel(modelRes, json);
    }

    public static JsonElement makeModelOverride(class_3300 manager, class_2960 modelRes, Consumer<OverrideAppender> modelConsumer) {
        JsonObject jsonObject;
        block8: {
            InputStream model = manager.getResourceOrThrow(ResType.ITEM_MODELS.getPath(modelRes)).method_14482();
            try {
                JsonObject json = RPUtils.deserializeJson(model);
                JsonArray overrides = json.has("overrides") ? json.getAsJsonArray("overrides") : new JsonArray();
                modelConsumer.accept(ov -> overrides.add((JsonElement)RPUtils.serializeModelOverride(ov)));
                json.add("overrides", (JsonElement)overrides);
                jsonObject = json;
                if (model == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (model != null) {
                        try {
                            model.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            model.close();
        }
        return jsonObject;
    }

    private static JsonObject serializeModelOverride(class_799 override) {
        JsonObject json = new JsonObject();
        json.addProperty("model", override.method_3472().toString());
        JsonObject predicates = new JsonObject();
        override.method_33690().forEach(p -> predicates.addProperty(p.method_33692().toString(), (Number)Float.valueOf(p.method_33693())));
        json.add("predicate", (JsonElement)predicates);
        return json;
    }

    @FunctionalInterface
    public static interface OverrideAppender {
        public void add(class_799 var1);
    }
}

