/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_9248;

public class RegistryQueue<T> {
    private final class_5321<? extends class_2378<T>> registry;
    private final List<RegEntryHolder<? extends T, T>> entries = new ArrayList<RegEntryHolder<? extends T, T>>();
    private final List<Consumer<Registrator<T>>> batchRegistration = new ArrayList<Consumer<Registrator<T>>>();

    public RegistryQueue(class_5321<? extends class_2378<T>> registry) {
        this.registry = registry;
    }

    public class_5321<? extends class_2378<T>> getRegistry() {
        return this.registry;
    }

    public <A extends T> RegEntryHolder<A, T> add(Supplier<A> factory, class_2960 name) {
        RegEntryHolder wrapper = new RegEntryHolder(name, factory, this.registry);
        this.entries.add(wrapper);
        return wrapper;
    }

    public void add(Consumer<Registrator<T>> eventListener) {
        this.batchRegistration.add(eventListener);
    }

    void initializeEntries() {
        this.entries.forEach(e -> e.initialize(true));
        this.batchRegistration.forEach(e -> e.accept((n, s) -> RegHelper.registerAsync(n, () -> s, this.registry)));
    }

    public static class RegEntryHolder<T extends R, R>
    implements RegSupplier<T> {
        private class_5321<? extends class_2378<R>> registryKey;
        private Supplier<T> regSupplier;
        private final class_5321<R> id;
        private class_6880<T> holder = null;

        public RegEntryHolder(class_2960 id, Supplier<T> factory, class_5321<? extends class_2378<R>> registry) {
            this.regSupplier = factory;
            this.id = class_5321.method_29179(registry, (class_2960)id);
            this.registryKey = registry;
        }

        @Override
        public T get() {
            return this.comp_349();
        }

        @Override
        public class_2960 getId() {
            return this.id.method_29177();
        }

        @Override
        public class_5321<R> getKey() {
            return this.id;
        }

        void initialize(boolean throwMissingReg) {
            if (this.holder != null) {
                return;
            }
            class_2385 writableRegistry = (class_2385)class_7923.field_41167.method_10223(this.registryKey.method_29177());
            if (writableRegistry == null) {
                if (throwMissingReg) {
                    throw new IllegalStateException("Registry not found: " + String.valueOf(this.registryKey.method_29177()));
                }
                return;
            }
            this.holder = writableRegistry.method_10272(this.id, this.regSupplier.get(), class_9248.field_49136);
            this.regSupplier = null;
            this.registryKey = null;
            Object entry = this.holder.comp_349();
            if (PlatHelper.getPhysicalSide().isClient() && entry instanceof ICustomItemRendererProvider) {
                ICustomItemRendererProvider pr = (ICustomItemRendererProvider)entry;
                if (BuiltinItemRendererRegistry.INSTANCE.get((class_1935)pr) == null) {
                    BuiltinItemRendererRegistry.INSTANCE.register((class_1935)pr, (BuiltinItemRendererRegistry.DynamicItemRenderer)pr.getRendererFactory().get());
                } else if (PlatHelper.isDev()) {
                    throw new AssertionError();
                }
            }
        }

        public T comp_349() {
            this.initialize(true);
            if (this.holder == null) {
                throw new NullPointerException("Trying to access unbound value: " + String.valueOf(this.id));
            }
            return (T)this.holder.comp_349();
        }

        public boolean method_40227() {
            this.initialize(false);
            return this.holder != null && this.holder.method_40227();
        }

        public boolean method_40226(class_2960 location) {
            return this.id.method_29177().equals((Object)location);
        }

        public boolean method_40225(class_5321<T> resourceKey) {
            return resourceKey == this.id;
        }

        public boolean method_40224(Predicate<class_5321<T>> predicate) {
            return predicate.test(this.id);
        }

        public boolean method_40220(class_6862<T> tagKey) {
            this.initialize(false);
            return this.holder != null && this.holder.method_40220(tagKey);
        }

        public boolean method_55838(class_6880<T> holder) {
            this.initialize(false);
            return this.holder != null && this.holder.method_55838(holder);
        }

        public Stream<class_6862<T>> method_40228() {
            this.initialize(false);
            return this.holder != null ? this.holder.method_40228() : Stream.empty();
        }

        public Either<class_5321<T>, T> method_40229() {
            return Either.left(this.id);
        }

        public Optional<class_5321<T>> method_40230() {
            return Optional.of(this.id);
        }

        public class_6880.class_6882 method_40231() {
            return class_6880.class_6882.field_36446;
        }

        public boolean method_46745(class_7876<T> owner) {
            this.initialize(false);
            return this.holder != null && this.holder.method_46745(owner);
        }

        public boolean equals(Object obj) {
            class_6880 h;
            if (this == obj) {
                return true;
            }
            return obj instanceof class_6880 && (h = (class_6880)obj).method_40231() == class_6880.class_6882.field_36446 && h.method_40225(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "RegistryHolderSupplier{%s}", this.id);
        }

        public class_6880<T> getDelegate() {
            this.initialize(false);
            class_6880<T> h = this.holder;
            if (h instanceof RegEntryHolder) {
                RegEntryHolder ro = (RegEntryHolder)h;
                return ro.getDelegate();
            }
            if (h != null) {
                return h;
            }
            return this;
        }
    }
}

