/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidStackImpl;
import net.mehvahdjukaar.moonlight.api.misc.HolderRef;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidStack
implements class_9322 {
    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group((App)SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder), (App)class_5699.field_33441.optionalFieldOf("count", (Object)1).forGetter(SoftFluidStack::getCount), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(stack -> stack.components.method_57940())).apply((Applicative)i, SoftFluidStack::of));
    public static final class_9139<class_9129, SoftFluidStack> STREAM_CODEC = class_9139.method_56436(SoftFluid.STREAM_CODEC, SoftFluidStack::getHolder, (class_9139)class_9135.field_48550, SoftFluidStack::getCount, (class_9139)class_9326.field_49590, s -> s.components.method_57940(), SoftFluidStack::of);
    private final class_6880<SoftFluid> fluidHolder;
    private final SoftFluid fluid;
    private int count;
    @NotNull
    private final class_9335 components;
    private boolean isEmptyCache;
    private final class_6880<SoftFluid> myEmptyFluid;

    protected SoftFluidStack(class_6880<SoftFluid> fluid, int count, class_9326 components) {
        this.fluidHolder = fluid;
        if (components == null) {
            Moonlight.LOGGER.error("Some mod passed a null components, fix me");
            components = class_9326.field_49588;
        }
        this.fluid = (SoftFluid)this.fluidHolder.comp_349();
        this.components = class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)Objects.requireNonNull(components, "component map cant be null"));
        this.count = count;
        this.updateEmpty();
        this.myEmptyFluid = this.haxFindEmpty(this.fluidHolder);
    }

    private class_6880<SoftFluid> haxFindEmpty(class_6880<SoftFluid> fluidHolder) {
        class_7225.class_7226<SoftFluid> ra = Utils.hackyFindRegistryOf(fluidHolder, SoftFluidRegistry.KEY);
        return MLBuiltinSoftFluids.EMPTY.lookup(ra);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, @NotNull class_9326 tag) {
        void var2_2;
        void var1_1;
        return SoftFluidStackImpl.of(fluid, (int)var1_1, (class_9326)var2_2);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count) {
        return SoftFluidStack.of(fluid, count, class_9326.field_49588);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, 1);
    }

    public static SoftFluidStack bucket(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(class_6880<SoftFluid> fluid) {
        return SoftFluidStack.of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    @Deprecated(forRemoval=true)
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount) {
        return SoftFluidStack.fromFluid(fluid, amount, class_9326.field_49588);
    }

    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @NotNull class_7225.class_7874 reg) {
        return SoftFluidStack.fromFluid(fluid, amount, class_9326.field_49588, reg);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @NotNull class_9326 component) {
        class_5455 reg = Utils.hackyGetRegistryAccess();
        return SoftFluidStack.fromFluid(fluid, amount, component, (class_7225.class_7874)reg);
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @NotNull class_9326 component, class_7225.class_7874 reg) {
        class_6880<SoftFluid> f = SoftFluidInternal.fromVanillaFluid(fluid, reg);
        if (f == null) {
            return SoftFluidStack.empty(reg);
        }
        return SoftFluidStack.of(f, amount, component);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid) {
        return SoftFluidStack.fromFluid(fluid, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid, class_7225.class_7874 reg) {
        if (fluid.method_15767(class_3486.field_15517)) {
            return SoftFluidStack.fromFluid(fluid.method_15772(), 3, class_9326.field_49588, reg);
        }
        return SoftFluidStack.fromFluid(fluid.method_15772(), SoftFluid.BUCKET_COUNT, class_9326.field_49588, reg);
    }

    @Deprecated(forRemoval=true)
    public static SoftFluidStack empty() {
        return SoftFluidStack.of(SoftFluidRegistry.hackyGetEmpty(), 0);
    }

    public static SoftFluidStack empty(class_7225.class_7874 lookupProvider) {
        return SoftFluidStack.of(SoftFluidRegistry.getEmpty(lookupProvider), 0);
    }

    public static SoftFluidStack empty(class_7871<SoftFluid> reg) {
        return SoftFluidStack.of(SoftFluidRegistry.getEmpty(reg), 0);
    }

    public class_2561 getDisplayName() {
        if (MLBuiltinSoftFluids.POTION.is(this.fluidHolder)) {
            PotionBottleType bottle = PotionBottleType.getOrDefault(this);
            return bottle.getTranslatedName();
        }
        return this.fluid().getTranslatedName();
    }

    public class_2520 save(class_7225.class_7874 lookupProvider) {
        DataResult a = CODEC.encodeStart((DynamicOps)lookupProvider.method_57093((DynamicOps)class_2509.field_11560), (Object)this);
        if (a.isSuccess()) {
            return (class_2520)a.getOrThrow();
        }
        Moonlight.LOGGER.error("Failed to encode fluid stack. HOW??, {}", a.error().get());
        if (PlatHelper.isDev()) {
            a.getOrThrow();
        }
        return new class_2487();
    }

    public static SoftFluidStack load(class_7225.class_7874 lookupProvider, class_2520 tag) {
        return (SoftFluidStack)CODEC.parse((DynamicOps)lookupProvider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).getOrThrow();
    }

    public boolean is(HolderRef<SoftFluid> fluid) {
        return fluid.is(this.fluidHolder);
    }

    public boolean is(HolderReference<SoftFluid> fluid) {
        return fluid.is(this.fluidHolder);
    }

    public boolean is(class_6862<SoftFluid> tag) {
        return this.getHolder().method_40220(tag);
    }

    public boolean is(class_5321<SoftFluid> location) {
        return this.getHolder().method_40225(location);
    }

    @Deprecated(forRemoval=true)
    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(class_6880<SoftFluid> fluid) {
        return fluid == this.fluidHolder || fluid.method_40225(this.fluidKey());
    }

    @Deprecated(forRemoval=true)
    private class_6880<SoftFluid> getFluid() {
        return this.isEmptyCache ? this.myEmptyFluid : this.fluidHolder;
    }

    public final class_6880<SoftFluid> getHolder() {
        return this.isEmptyCache ? this.myEmptyFluid : this.fluidHolder;
    }

    public final SoftFluid fluid() {
        return this.isEmptyCache ? (SoftFluid)this.myEmptyFluid.comp_349() : this.fluid;
    }

    public final class_5321<SoftFluid> fluidKey() {
        return (class_5321)this.getHolder().method_40230().get();
    }

    public boolean isEmpty() {
        return this.isEmptyCache;
    }

    protected void updateEmpty() {
        this.isEmptyCache = this.count <= 0 || MLBuiltinSoftFluids.EMPTY.is(this.fluidHolder);
    }

    public int getCount() {
        return this.isEmptyCache ? 0 : this.count;
    }

    public void setCount(int count) {
        if (MLBuiltinSoftFluids.EMPTY.is(this.fluidHolder)) {
            if (PlatHelper.isDev()) {
                throw new AssertionError();
            }
            return;
        }
        this.count = count;
        this.updateEmpty();
    }

    public void grow(int amount) {
        this.setCount(this.count + amount);
    }

    public void shrink(int amount) {
        this.setCount(this.count - amount);
    }

    public void consume(int amount, @Nullable class_1309 entity) {
        if (entity == null || !entity.method_56992()) {
            this.shrink(amount);
        }
    }

    public SoftFluidStack copy() {
        return SoftFluidStack.of(this.getHolder(), this.count, this.components.method_57941().method_57940());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) {
            this.shrink(i);
        }
        return stack;
    }

    public boolean isSameFluidSameComponents(SoftFluidStack other) {
        if (!this.is(other.getHolder())) {
            return false;
        }
        return this.isEmpty() && other.isEmpty() || Objects.equals(this.components, other.components);
    }

    public static int hashFluidAndComponents(@Nullable SoftFluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getHolder().hashCode();
            return 31 * i + stack.getComponents().hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftFluidStack)) {
            return false;
        }
        SoftFluidStack that = (SoftFluidStack)o;
        return this.count == that.count && Objects.equals(this.fluidHolder.method_40230(), that.fluidHolder.method_40230()) && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.fluidHolder.method_40230(), this.count, this.components);
    }

    public String toString() {
        return this.getCount() + " " + String.valueOf(this.getHolder());
    }

    @Deprecated(forRemoval=true)
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack) {
        return SoftFluidStack.fromItem(itemStack, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    }

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack, class_7225.class_7874 reg) {
        Optional<FluidContainerList.Category> category;
        class_1792 filledContainer = itemStack.method_7909();
        Object fluid = SoftFluidInternal.fromVanillaItem(filledContainer, reg);
        if (fluid != null && !MLBuiltinSoftFluids.EMPTY.is(fluid) && (category = ((SoftFluid)fluid.comp_349()).getContainerList().getCategoryFromFilled(filledContainer)).isPresent()) {
            int count = category.get().getCapacity();
            class_9326.class_9327 fluidComponents = class_9326.method_57841();
            class_1844 potion = (class_1844)itemStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            if (potion.method_57401(class_1847.field_8991)) {
                fluid = MLBuiltinSoftFluids.WATER.getHolder(reg);
            } else if (potion.method_57405()) {
                PotionBottleType bottleType = PotionBottleType.getOrDefault(filledContainer);
                fluidComponents.method_57854(MoonlightRegistry.BOTTLE_TYPE.get(), (Object)bottleType);
            }
            SoftFluidStack sfStack = SoftFluidStack.of(fluid, count, fluidComponents.method_57852());
            SoftFluidStack.copyComponentsTo((class_9322)itemStack, sfStack, ((SoftFluid)fluid.comp_349()).getPreservedComponents());
            return Pair.of((Object)sfStack, (Object)category.get());
        }
        return null;
    }

    public Pair<class_1799, FluidContainerList.Category> splitToItem(class_1799 emptyContainer) {
        Pair<class_1799, FluidContainerList.Category> r = this.toItem(emptyContainer);
        if (r != null) {
            this.shrink(((FluidContainerList.Category)r.getSecond()).getCapacity());
        }
        return r;
    }

    @Deprecated(forRemoval=true)
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer, boolean dontModifyStack) {
        Pair<class_1799, FluidContainerList.Category> r = this.toItem(emptyContainer);
        if (r != null && !dontModifyStack) {
            this.shrink(((FluidContainerList.Category)r.getSecond()).getCapacity());
        }
        return r;
    }

    @Nullable
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer) {
        FluidContainerList.Category category;
        class_1799[] filledStacks;
        Optional<FluidContainerList.Category> opt = this.fluid().getContainerList().getCategoryFromEmpty(emptyContainer.method_7909());
        if (opt.isPresent() && (filledStacks = this.createFilledStacks(category = opt.get(), true)).length != 0) {
            return Pair.of((Object)filledStacks[0], (Object)category);
        }
        return null;
    }

    public Multimap<FluidContainerList.Category, class_1799> toAllPossibleFilledItems() {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (FluidContainerList.Category category : this.fluid().getContainerList()) {
            for (class_1799 filled : this.createFilledStacks(category, false)) {
                result.put((Object)category, (Object)filled);
            }
        }
        return result;
    }

    private class_1799[] createFilledStacks(FluidContainerList.Category category, boolean onlyFirst) {
        int shrinkAmount = category.getCapacity();
        if (shrinkAmount > this.getCount()) {
            return new class_1799[0];
        }
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (class_1935 class_19352 : category.getFilledItems()) {
            class_1799 filledStack = new class_1799(class_19352);
            if (category.getEmptyContainer() == class_1802.field_8469 && this.is(MLBuiltinSoftFluids.POTION)) {
                PotionBottleType type = PotionBottleType.getOrDefault(this);
                filledStack = type.getDefaultItem();
            }
            if (category.getEmptyContainer() == class_1802.field_8469 && this.is(MLBuiltinSoftFluids.WATER)) {
                filledStack = class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991);
            }
            this.copyComponentsTo((class_9322)filledStack);
            results.add(filledStack);
            if (!onlyFirst) continue;
            break;
        }
        return results.toArray(new class_1799[0]);
    }

    public void copyComponentsTo(class_9322 to) {
        SoftFluidStack.copyComponentsTo(this, to, this.fluid.getPreservedComponents());
    }

    protected static void copyComponentsTo(class_9322 from, class_9322 to, class_6885<class_9331<?>> types) {
        for (class_6880 h : types) {
            class_9331 type = (class_9331)h.comp_349();
            SoftFluidStack.copyComponentTo(from, to, type);
        }
    }

    private static <A> void copyComponentTo(class_9322 from, class_9322 to, class_9331<A> comp) {
        Object componentValue = from.method_57824(comp);
        if (componentValue != null) {
            if (to instanceof class_1799) {
                class_1799 is = (class_1799)to;
                is.method_57379(comp, componentValue);
            } else if (to instanceof SoftFluidStack) {
                SoftFluidStack sf = (SoftFluidStack)to;
                sf.set(comp, componentValue);
            } else {
                PlatHelper.setComponent(to, comp, componentValue);
            }
        }
    }

    public FluidContainerList getContainerList() {
        return this.fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return this.fluid().getFoodProvider();
    }

    public boolean isEquivalent(class_6880<class_3611> fluid) {
        return this.isEquivalent(fluid, class_9326.field_49588);
    }

    public boolean isEquivalent(class_6880<class_3611> fluid, class_9326 componentPatch) {
        return this.fluid().isEquivalent(fluid) && Objects.equals(this.components.method_57940(), componentPatch);
    }

    public class_6880<class_3611> getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    public int getStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);
        if (specialColor != 0) {
            return specialColor;
        }
        return fluid.getTintColor();
    }

    public int getFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getStillColor(world, pos);
    }

    public int getParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        int tintColor = this.getStillColor(world, pos);
        if (tintColor == -1) {
            return this.fluid().getAverageTextureTintColor();
        }
        return tintColor;
    }

    @NotNull
    public class_9335 getComponents() {
        return this.components;
    }

    @Nullable
    public <T> T set(class_9331<? super T> type, @Nullable T component) {
        return (T)this.components.method_57938(type, component);
    }
}

