/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class RecipeDefaults {
    public final List<class_2960> added = Lists.newArrayList();
    public final List<Resolution> resolutions = Lists.newArrayList();
    public final List<Tag> tags = Lists.newArrayList();

    public void add(class_2960 id) {
        this.added.add(id);
    }

    public void add(class_2960 id, JsonArray arr) {
        this.resolutions.add(new Resolution(id, arr.asList()));
    }

    public void addTag(JsonElement tag, JsonElement stack) {
        this.tags.add(new Tag(tag, stack));
    }

    public void remove(class_2960 id) {
        this.added.remove(id);
        this.resolutions.removeIf(r -> r.recipe.equals((Object)id));
    }

    public void clear() {
        this.added.clear();
        this.resolutions.clear();
        this.tags.clear();
    }

    public Map<EmiIngredient, EmiRecipe> bake() {
        EmiRecipe recipe;
        HashMap map = Maps.newHashMap();
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return map;
        }
        EmiRecipeManager manager = EmiApi.getRecipeManager();
        for (class_2960 id : this.added) {
            recipe = manager.getRecipe(id);
            if (recipe == null) continue;
            for (EmiIngredient emiIngredient : recipe.getOutputs()) {
                map.put(emiIngredient, recipe);
            }
        }
        for (Resolution r : this.resolutions) {
            recipe = manager.getRecipe(r.recipe);
            if (recipe == null) continue;
            for (JsonElement jsonElement : r.stacks) {
                EmiIngredient stack = EmiIngredientSerializer.getDeserialized(jsonElement);
                if (stack.isEmpty()) continue;
                map.put(stack, recipe);
            }
        }
        for (Tag t : this.tags) {
            EmiIngredient tag = EmiIngredientSerializer.getDeserialized(t.tag);
            EmiIngredient stack = EmiIngredientSerializer.getDeserialized(t.stack);
            if (tag.isEmpty() || stack.isEmpty() || stack.getEmiStacks().size() != 1 || !tag.getEmiStacks().containsAll(stack.getEmiStacks())) continue;
            map.put(tag, new EmiResolutionRecipe(tag, stack.getEmiStacks().get(0)));
        }
        return map;
    }

    public record Resolution(class_2960 recipe, List<JsonElement> stacks) {
    }

    public record Tag(JsonElement tag, JsonElement stack) {
    }
}

