/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.densityfunction;

import com.github.mim1q.minecells.util.MathUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record CliffDensityFunction(int gridSize, boolean zAxis, int width, int offset, int fromY, int toY, double taperWidth, Optional<class_6910> offsetNoise) implements class_6910
{
    public static final class_7243<CliffDensityFunction> CODEC_HOLDER = class_7243.method_42116((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("grid_size", (Object)1024).forGetter(it -> it.gridSize), (App)Codec.BOOL.optionalFieldOf("z_axis", (Object)false).forGetter(it -> it.zAxis), (App)Codec.INT.fieldOf("width").forGetter(it -> it.width), (App)Codec.INT.fieldOf("offset").forGetter(it -> it.offset), (App)Codec.INT.fieldOf("from_y").forGetter(it -> it.fromY), (App)Codec.INT.fieldOf("to_y").forGetter(it -> it.toY), (App)Codec.DOUBLE.fieldOf("taper_width").forGetter(it -> it.taperWidth), (App)class_6910.field_37057.optionalFieldOf("offset_noise").forGetter(it -> it.offsetNoise)).apply((Applicative)instance, CliffDensityFunction::new)));

    public double method_40464(class_6910.class_6912 pos) {
        double maxDist;
        int coord = (this.zAxis ? pos.comp_373() : pos.comp_371()) - this.offset;
        int y = pos.comp_372();
        int center = MathUtils.getClosestMultiplePosition(new class_2382(coord, 0, 0), this.gridSize).method_10263();
        int dist = Math.abs(coord - center);
        if ((double)dist > (maxDist = (double)this.width / 2.0)) {
            return 0.0;
        }
        if (this.offsetNoise.isPresent()) {
            double sample = this.offsetNoise.get().method_40464(pos) * 0.8;
            dist += (int)(this.taperWidth * sample);
        }
        if (y <= this.fromY || y >= this.toY) {
            return 1.0;
        }
        double heightFraction = (double)(y - this.fromY) / (double)(this.toY - this.fromY);
        heightFraction = 2.0 * (heightFraction - 0.5);
        heightFraction = (heightFraction = 1.0 - Math.abs(heightFraction)) > 0.5 ? 1.0 : 2.0 * heightFraction;
        double distanceToEdge = maxDist - (double)dist;
        double randomOffset = 1.0;
        double maxDistanceToEdge = this.taperWidth * heightFraction * randomOffset;
        return MathUtils.easeInQuad(0.0f, 1.0f, (float)class_3532.method_15350((double)(distanceToEdge / maxDistanceToEdge * randomOffset), (double)0.0, (double)1.0));
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        Optional<class_6910> offsetNoise = this.offsetNoise.map(it -> it.method_40469(visitor));
        return visitor.apply((class_6910)new CliffDensityFunction(this.gridSize, this.zAxis, this.width, this.offset, this.fromY, this.toY, this.taperWidth, offsetNoise));
    }

    public double comp_377() {
        return 0.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}

