/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.util;

import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MathUtils {
    public static class_243 vectorRotateY(class_243 vector, float theta) {
        double z = vector.field_1350 * (double)class_3532.method_15374((float)theta) + vector.field_1352 * (double)class_3532.method_15362((float)theta);
        double x = vector.field_1350 * (double)class_3532.method_15362((float)theta) - vector.field_1352 * (double)class_3532.method_15374((float)theta);
        return new class_243(x, vector.field_1351, z);
    }

    public static Vector3f vectorRotateY(Vector3f vector, float theta) {
        float z = vector.z() * class_3532.method_15374((float)theta) + vector.x() * class_3532.method_15362((float)theta);
        float x = vector.z() * class_3532.method_15362((float)theta) - vector.x() * class_3532.method_15374((float)theta);
        return new Vector3f(x, vector.y(), z);
    }

    public static class_243 lerp(class_243 v0, class_243 v1, float delta) {
        double x = class_3532.method_16436((double)delta, (double)v0.field_1352, (double)v1.field_1352);
        double y = class_3532.method_16436((double)delta, (double)v0.field_1351, (double)v1.field_1351);
        double z = class_3532.method_16436((double)delta, (double)v0.field_1350, (double)v1.field_1350);
        return new class_243(x, y, z);
    }

    public static float lerp(float a, float b, float delta) {
        return class_3532.method_16439((float)delta, (float)a, (float)b);
    }

    public static float easeInOutQuad(float a, float b, float delta) {
        delta = delta < 0.5f ? 2.0f * delta * delta : 1.0f - (-2.0f * delta + 2.0f) * (-2.0f * delta + 2.0f) * 0.5f;
        return class_3532.method_16439((float)delta, (float)a, (float)b);
    }

    public static float easeOutBounce(float a, float b, float delta) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (delta < 1.0f / d1) {
            return MathUtils.lerp(a, b, n1 * delta * delta);
        }
        if (delta < 2.0f / d1) {
            return MathUtils.lerp(a, b, n1 * (delta -= 1.5f / d1) * delta + 0.75f);
        }
        if (delta < 2.5f / d1) {
            return MathUtils.lerp(a, b, n1 * (delta -= 2.25f / d1) * delta + 0.9375f);
        }
        return MathUtils.lerp(a, b, n1 * (delta -= 2.625f / d1) * delta + 0.984375f);
    }

    public static float easeOutBack(float a, float b, float delta) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return MathUtils.lerp(a, b, 1.0f + c3 * (float)Math.pow(delta - 1.0f, 3.0) + c1 * (float)Math.pow(delta - 1.0f, 2.0));
    }

    public static float easeInQuad(float a, float b, float delta) {
        return MathUtils.lerp(a, b, delta * delta);
    }

    public static float easeOutQuad(float a, float b, float delta) {
        return MathUtils.lerp(a, b, 1.0f - (1.0f - delta) * (1.0f - delta));
    }

    public static float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static int getClosestMultiple(int value, int multiple) {
        return Math.round((float)value / (float)multiple) * multiple;
    }

    public static class_2382 getClosestMultiplePosition(class_2382 pos, int multiple) {
        int x = pos.method_10263();
        int z = pos.method_10260();
        x = Math.round((float)x / (float)multiple) * multiple;
        z = Math.round((float)z / (float)multiple) * multiple;
        return new class_2382(x, 0, z);
    }

    public static class_2382 getRotatedOffsetWithinChunk(class_2382 offset, class_2470 rotation) {
        int x = offset.method_10263();
        int y = offset.method_10264();
        int z = offset.method_10260();
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case class_2470.field_11467 -> new class_2382(x, y, z);
            case class_2470.field_11463 -> new class_2382(15 - z, y, x);
            case class_2470.field_11464 -> new class_2382(15 - x, y, 15 - z);
            case class_2470.field_11465 -> new class_2382(z, y, 15 - x);
        };
    }

    public static class_2382 getSpiralPosition(int i) {
        int k = (int)Math.ceil((Math.sqrt(++i) - 1.0) / 2.0);
        int t = 2 * k + 1;
        int m = t * t;
        if (i >= m - --t) {
            return new class_2382(k - (m - i), 0, -k);
        }
        if (i >= (m -= t) - t) {
            return new class_2382(-k, 0, -k + (m - i));
        }
        if (i >= (m -= t) - t) {
            return new class_2382(-k + (m - i), 0, k);
        }
        return new class_2382(k, 0, k - (m - i - t));
    }

    public static int getSpiralIndex(int x, int z) {
        if (z * z >= x * x) {
            int p = 4 * z * z - z - x;
            if (z < x) {
                return p - 2 * (z - x);
            }
            return p;
        }
        int p = 4 * x * x - z - x;
        if (z < x) {
            return p + 2 * (z - x);
        }
        return p;
    }

    public static class PosRotScale {
        private final Vector3f pos;
        private final Vector3f rot;
        private final Vector3f scale;

        private PosRotScale(Vector3f pos, Vector3f rot, Vector3f scale) {
            this.pos = pos;
            this.rot = rot;
            this.scale = scale;
        }

        public static PosRotScale ofRadians(float px, float py, float pz, float rx, float ry, float rz, float sx, float sy, float sz) {
            return PosRotScale.ofRadians(new Vector3f(px, py, pz), new Vector3f(rx, ry, rz), new Vector3f(sx, sy, sz));
        }

        public static PosRotScale ofDegrees(Vector3f pos, Vector3f rot, Vector3f scale) {
            rot.mul((float)Math.PI / 180);
            return PosRotScale.ofRadians(pos, rot, scale);
        }

        public static PosRotScale ofDegrees(float px, float py, float pz, float rx, float ry, float rz, float sx, float sy, float sz) {
            return PosRotScale.ofDegrees(new Vector3f(px, py, pz), new Vector3f(rx, ry, rz), new Vector3f(sx, sy, sz));
        }

        public static PosRotScale ofRadians(Vector3f pos, Vector3f rot, Vector3f scale) {
            return new PosRotScale(pos, rot, scale);
        }

        public void apply(class_4587 matrices) {
            matrices.method_46416(this.getPos().x, this.getPos().y, this.getPos().z);
            matrices.method_22907(new Quaternionf().rotationZYX(this.getRot().z, this.getRot().y, this.getRot().x));
            matrices.method_22905(this.getScale().x, this.getScale().y, this.getScale().z);
        }

        public Vector3f getPos() {
            return this.pos;
        }

        public Vector3f getRot() {
            return this.rot;
        }

        public Vector3f getScale() {
            return this.scale;
        }
    }
}

